/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.mixin.GuiGraphicsAccessor;
import io.github.axolotlclient.modules.hud.gui.hud.PlayerHudCommon;
import io.github.axolotlclient.modules.hud.util.PlayerHudEntityRenderState;
import io.github.axolotlclient.modules.hud.util.PlayerHudEntityRenderer;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_11256;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PlayerHud
extends PlayerHudCommon {
    private class_10042 reusedPlayerRendererState = null;
    private PlayerHudEntityRenderer renderer;

    public PlayerHud() {
        Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
    }

    public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
        this.yawOffset += (event.yaw() - event.prevYaw()) / 2.0f;
    }

    public void tick() {
        super.tick();
        class_310 client = class_310.method_1551();
        if (client.field_1724 != null && client.field_1724.method_20232()) {
            float rawPitch = client.field_1724.method_5799() ? -90.0f - client.field_1724.method_36455() : -90.0f;
            float pitch = class_3532.method_16439((float)client.field_1724.method_6024(1.0f), (float)0.0f, (float)rawPitch);
            float height = client.field_1724.method_17682();
            float offset = (float)(Math.sin(Math.toRadians(pitch)) * (double)height);
            this.yOffset = Math.abs(offset);
        } else if (client.field_1724 != null && client.field_1724.method_6128()) {
            float j = (float)client.field_1724.method_6003() + 1.0f;
            float k = class_3532.method_15363((float)(j * j / 100.0f), (float)0.0f, (float)1.0f);
            float pitch = k * (-90.0f - client.field_1724.method_36455()) + 90.0f;
            float height = client.field_1724.method_17682() / 2.0f;
            this.yOffset = (float)(Math.sin(Math.toRadians(pitch)) * (double)height);
            if (pitch < 0.0f) {
                this.yOffset -= (float)((1.0 / (1.0 + Math.exp(-pitch / 4.0f)) - 0.5) * 2.0);
            }
        } else {
            this.yOffset *= 0.8f;
        }
    }

    protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
        class_310 client = class_310.method_1551();
        class_332 graphics = (class_332)ctx;
        if (client.field_1724 == null) {
            return;
        }
        if (!placeholder && ((Boolean)this.autoHide.get()).booleanValue()) {
            if (this.isPerformingAction()) {
                this.hide = -1L;
            } else if (this.hide == -1L) {
                this.hide = System.currentTimeMillis();
            }
            if (this.hide != -1L && System.currentTimeMillis() - this.hide > 500L) {
                return;
            }
        }
        float lerpY = this.lastYOffset + (this.yOffset - this.lastYOffset) * delta;
        float scale = this.getScale() * 40.0f;
        Quaternionf quaternion = new Quaternionf().rotateZ((float)Math.PI);
        float deltaYaw = client.field_1724.method_61415(delta);
        if (((Boolean)this.dynamicRotation.get()).booleanValue()) {
            deltaYaw -= this.lastYawOffset + (this.yawOffset - this.lastYawOffset) * delta;
        }
        Quaternionf quaternionf2 = new Quaternionf().fromAxisAngleDeg((Vector3fc)new Vector3f(0.0f, 1.0f, 0.0f), deltaYaw - 180.0f + ((Double)this.rotation.get()).floatValue());
        quaternion.mul((Quaternionfc)quaternionf2);
        this.renderEntityInInventory(graphics, (int)x, (int)y, (int)(x + (double)((float)this.getWidth() * this.getScale())), (int)(y + (double)((float)this.getHeight() * this.getScale())), scale / client.field_1724.method_55693(), new Vector3f(0.0f, client.field_1724.method_17682() / 2.0f - lerpY * client.field_1724.method_55693(), 0.0f), quaternion, quaternionf2, (class_1309)client.field_1724);
    }

    private void renderEntityInInventory(class_332 guiGraphics, int i, int j, int k, int l, float f, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, class_1309 livingEntity) {
        class_310 mc = class_310.method_1551();
        class_898 entityRenderDispatcher = mc.method_1561();
        if (this.renderer == null) {
            this.renderer = new PlayerHudEntityRenderer(mc.method_22940().method_23000(), entityRenderDispatcher);
        }
        class_897 entityRenderer = entityRenderDispatcher.method_3953((class_1297)livingEntity);
        if (this.reusedPlayerRendererState == null) {
            this.reusedPlayerRendererState = (class_10042)entityRenderer.method_55269();
        }
        entityRenderer.method_62354((class_1297)livingEntity, (class_10017)this.reusedPlayerRendererState, 1.0f);
        this.reusedPlayerRendererState.field_53337 = null;
        this.reusedPlayerRendererState.field_58169 = null;
        ((GuiGraphicsAccessor)guiGraphics).getGuiRenderState().method_70922((class_11256)new PlayerHudEntityRenderState((class_10017)this.reusedPlayerRendererState, vector3f, quaternionf, quaternionf2, i, j, k, l, f, ((GuiGraphicsAccessor)guiGraphics).getScissorStack().method_70863(), this.renderer));
    }

    private boolean isPerformingAction() {
        class_746 player = class_310.method_1551().field_1724;
        return player.method_18276() || player.method_5624() || player.method_6128() || player.method_31549().field_7479 || player.method_5869() || player.method_20232() || player.method_5765() || player.method_6115() || player.method_3144() || player.field_6235 > 0 || player.method_5809();
    }
}

