/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.screenshotUtils;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.StringArrayOption;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.modules.screenshotUtils.GalleryScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageInstance;
import io.github.axolotlclient.modules.screenshotUtils.ImageScreen;
import io.github.axolotlclient.modules.screenshotUtils.ImageShare;
import io.github.axolotlclient.modules.screenshotUtils.ScreenshotCopying;
import io.github.axolotlclient.util.Util;
import io.github.axolotlclient.util.options.GenericOption;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class ScreenshotUtils
extends AbstractModule {
    private static final ScreenshotUtils Instance = new ScreenshotUtils();
    private final OptionCategory category = OptionCategory.create((String)"screenshotUtils");
    private final BooleanOption enabled = new BooleanOption("enabled", Boolean.valueOf(false));
    private final Map<BooleanSupplier, Action> actions = (Map)class_156.method_656(() -> {
        LinkedHashMap<BooleanSupplier, Action> actions = new LinkedHashMap<BooleanSupplier, Action>();
        actions.put(() -> true, new Action("copyAction", class_124.field_1075, "copy_image", ScreenshotCopying::copy));
        actions.put(() -> true, new Action("deleteAction", class_124.field_1076, "delete_image", file -> {
            try {
                Files.delete(file);
                Util.addMessageToChatHud((class_2561)class_2561.method_43470((String)class_1074.method_4662((String)"screenshot_deleted", (Object[])new Object[0]).replace("<name>", file.getFileName().toString())));
            }
            catch (Exception e) {
                AxolotlClient.LOGGER.warn("Couldn't delete Screenshot " + file.getFileName().toString(), new Object[0]);
            }
        }));
        actions.put(() -> true, new Action("openAction", class_124.field_1068, "open_image", file -> class_156.method_668().method_673(file.toUri())));
        actions.put(() -> true, new Action("viewInGalleryAction", class_124.field_1076, "view_in_gallery", file -> {
            try {
                ImageInstance.LocalImpl instance = new ImageInstance.LocalImpl(file);
                class_310.method_1551().method_20493(() -> class_310.method_1551().method_1507(ImageScreen.create(null, CompletableFuture.completedFuture(instance), true)));
            }
            catch (Exception ignored) {
                Util.addMessageToChatHud((class_2561)class_2561.method_43471((String)"screenshot.gallery.view.error"));
            }
        }));
        actions.put(() -> API.getInstance().isAuthenticated(), new Action("uploadAction", class_124.field_1075, "upload_image", ImageShare.getInstance()::uploadImage));
        return actions;
    });
    private final StringArrayOption autoExec = new StringArrayOption("autoExec", (String[])class_156.method_656(() -> {
        ArrayList<String> names = new ArrayList<String>();
        names.add("off");
        this.actions.forEach((condition, action) -> names.add(action.getName()));
        return names.toArray(new String[0]);
    }), "off");

    public void init() {
        this.category.add(new Option[]{this.enabled, this.autoExec, new GenericOption("imageViewer", "openViewer", () -> this.client.method_1507((class_437)new GalleryScreen(this.client.field_1755)))});
        AxolotlClient.config().general.add(new OptionCategory[]{this.category});
    }

    public class_5250 onScreenshotTaken(class_5250 text, File shot) {
        class_2561 t;
        if (((Boolean)this.enabled.get()).booleanValue() && (t = this.getUtilsText(shot.toPath())) != null) {
            return text.method_27693("\n").method_10852(t);
        }
        return text;
    }

    @Nullable
    private class_2561 getUtilsText(Path file) {
        if (!((String)this.autoExec.get()).equals("off")) {
            this.actions.forEach((condition, action) -> {
                if (condition.getAsBoolean() && ((String)this.autoExec.get()).equals(action.getName())) {
                    action.getClickEvent(file).doAction();
                }
            });
            return null;
        }
        class_5250 message = class_2561.method_43473();
        this.actions.forEach((condition, action) -> {
            if (condition.getAsBoolean()) {
                message.method_10852(action.getText(file)).method_27693(" ");
            }
        });
        return message;
    }

    @Generated
    public static ScreenshotUtils getInstance() {
        return Instance;
    }

    public static class Action {
        private final String translationKey;
        private final class_124 formatting;
        private final String hoverTextKey;
        private final OnActionCall clickEvent;

        public class_2561 getText(Path file) {
            return class_2561.method_43471((String)this.translationKey).method_10862(class_2583.field_24360.method_10977(this.formatting).method_10958((class_2558)this.getClickEvent(file)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)this.hoverTextKey))));
        }

        public String getName() {
            return this.translationKey;
        }

        public CustomClickEvent getClickEvent(Path file) {
            return new CustomClickEvent(this.clickEvent, file);
        }

        @Generated
        public Action(String translationKey, class_124 formatting, String hoverTextKey, OnActionCall clickEvent) {
            this.translationKey = translationKey;
            this.formatting = formatting;
            this.hoverTextKey = hoverTextKey;
            this.clickEvent = clickEvent;
        }
    }

    public static class CustomClickEvent
    implements class_2558 {
        private final OnActionCall action;
        private final Path file;

        public CustomClickEvent(OnActionCall action, Path file) {
            this.action = action;
            this.file = file;
        }

        public void doAction() {
            if (this.file != null) {
                this.action.doAction(this.file);
            } else {
                AxolotlClient.LOGGER.warn("How'd you manage to do this? Now there's a screenshot ClickEvent without a File attached to it!", new Object[0]);
            }
        }

        public class_2558.class_2559 method_10845() {
            return class_2558.class_2559.field_11746;
        }
    }

    public static interface OnActionCall {
        public void doAction(Path var1);
    }
}

