/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.zoom;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.modules.AbstractModule;
import io.github.axolotlclient.util.keybinds.KeyBinds;
import lombok.Generated;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3675;

public class Zoom
extends AbstractModule {
    public static final class_304 key = new class_304("key.zoom", 67, KeyBinds.CATEGORY_AXOLOTLCLIENT);
    public static final FloatOption zoomDivisor = new FloatOption("zoomDivisor", Float.valueOf(4.0f), Float.valueOf(1.0f), Float.valueOf(16.0f));
    public static final FloatOption zoomSpeed = new FloatOption("zoomSpeed", Float.valueOf(7.5f), Float.valueOf(1.0f), Float.valueOf(10.0f));
    public static final BooleanOption zoomScrolling = new BooleanOption("zoomScrolling", Boolean.valueOf(false));
    public static final BooleanOption decreaseSensitivity = new BooleanOption("decreaseSensitivity", Boolean.valueOf(true));
    public static final BooleanOption smoothCamera = new BooleanOption("smoothCamera", Boolean.valueOf(false));
    private static final Zoom Instance = new Zoom();
    public static boolean active;
    private static Double originalSensitivity;
    private static boolean originalSmoothCamera;
    private static float targetFactor;
    private static float divisor;
    private static float lastAnimatedFactor;
    private static float animatedFactor;
    private static double lastReturnedFov;
    public final OptionCategory zoom = OptionCategory.create((String)"zoom");

    public static float getFov(float current, float tickDelta) {
        float result = current * (((Float)zoomSpeed.get()).floatValue() == 10.0f ? targetFactor : class_3532.method_16439((float)tickDelta, (float)lastAnimatedFactor, (float)animatedFactor));
        if (lastReturnedFov != 0.0 && lastReturnedFov != (double)result) {
            class_310.method_1551().field_1769.method_3292();
        }
        lastReturnedFov = result;
        return result;
    }

    public static void update() {
        if (Zoom.shouldStart()) {
            Zoom.start();
        } else if (Zoom.shouldStop()) {
            Zoom.stop();
        }
    }

    private static boolean shouldStart() {
        return Zoom.keyHeld() && !active;
    }

    private static void start() {
        active = true;
        Zoom.setDivisor(((Float)zoomDivisor.get()).floatValue());
        Zoom.setOptions();
    }

    private static boolean shouldStop() {
        return !Zoom.keyHeld() && active;
    }

    private static void stop() {
        active = false;
        targetFactor = 1.0f;
        Zoom.restoreOptions();
    }

    private static boolean keyHeld() {
        return key.method_1434();
    }

    private static void setDivisor(float value) {
        divisor = value;
        targetFactor = 1.0f / value;
    }

    public static void setOptions() {
        originalSensitivity = (Double)class_310.method_1551().field_1690.method_42495().method_41753();
        if (((Boolean)smoothCamera.get()).booleanValue()) {
            originalSmoothCamera = class_310.method_1551().field_1690.field_1914;
            class_310.method_1551().field_1690.field_1914 = true;
        }
        Zoom.updateSensitivity();
    }

    public static void restoreOptions() {
        class_310.method_1551().field_1690.method_42495().method_41748((Object)originalSensitivity);
        class_310.method_1551().field_1690.field_1914 = originalSmoothCamera;
    }

    private static void updateSensitivity() {
        if (((Boolean)decreaseSensitivity.get()).booleanValue()) {
            class_310.method_1551().field_1690.method_42495().method_41748((Object)(originalSensitivity / (double)(divisor * divisor)));
        }
    }

    public static boolean scroll(double amount) {
        if (active && ((Boolean)zoomScrolling.get()).booleanValue() && amount != 0.0) {
            Zoom.setDivisor((float)Math.max(1.0, (double)divisor + amount / Math.abs(amount)));
            Zoom.updateSensitivity();
            return true;
        }
        return false;
    }

    public void init() {
        this.zoom.add(new Option[]{zoomDivisor});
        this.zoom.add(new Option[]{zoomSpeed});
        this.zoom.add(new Option[]{zoomScrolling});
        this.zoom.add(new Option[]{decreaseSensitivity});
        this.zoom.add(new Option[]{smoothCamera});
        KeyBinds.getInstance().register(key);
        AxolotlClient.config().rendering.add(new OptionCategory[]{this.zoom});
        active = false;
        KeyBinds.getInstance().registerWithSimpleAction(new class_304("key.zoom.increase", class_3675.field_16237.method_1444(), KeyBinds.CATEGORY_AXOLOTLCLIENT), () -> Zoom.scroll(((Float)zoomSpeed.get()).floatValue() / 2.0f));
        KeyBinds.getInstance().registerWithSimpleAction(new class_304("key.zoom.decrease", class_3675.field_16237.method_1444(), KeyBinds.CATEGORY_AXOLOTLCLIENT), () -> Zoom.scroll(-((Float)zoomSpeed.get()).floatValue() / 2.0f));
    }

    public void tick() {
        lastAnimatedFactor = animatedFactor;
        animatedFactor += (targetFactor - animatedFactor) * (((Float)zoomSpeed.get()).floatValue() / 10.0f);
    }

    @Generated
    public static Zoom getInstance() {
        return Instance;
    }

    static {
        targetFactor = 1.0f;
        lastAnimatedFactor = 1.0f;
        animatedFactor = 1.0f;
    }
}

