/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8030;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Setter
@Getter
public class ContextMenuContainer implements class_4068, class_364, class_6379 {

	@Nullable
	private ContextMenu menu;

	public ContextMenuContainer() {

	}

	public void removeMenu() {
		menu = null;
	}

	public boolean hasMenu() {
		return menu != null;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		if (menu != null) {
			menu.method_25394(graphics, mouseX, mouseY, delta);
		}
	}

	@Override
	public boolean method_25370() {
		if (menu != null) {
			return menu.method_25370();
		}
		return false;
	}

	@Override
	public void method_25365(boolean focused) {
		if (menu != null) {
			menu.method_25365(focused);
		}
	}

	@Override
	public void method_16014(double mouseX, double mouseY) {
		if (menu != null) {
			menu.method_16014(mouseX, mouseY);
		}
	}

	@Override
	public boolean method_25402(class_11909 event, boolean doubleClick) {
		if (menu != null) {
			if (!menu.method_25405(event.comp_4798(), event.comp_4799())) {
				removeMenu();
				return true;
			}
			if (menu.method_25402(event, doubleClick)) removeMenu();
			return true;
		}
		return false;
	}

	@Override
	public boolean method_25406(class_11909 event) {
		if (menu != null) {
			return menu.method_25406(event);
		}
		return false;
	}

	@Override
	public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
		if (menu != null) {
			return menu.method_25403(event, deltaX, deltaY);
		}
		return false;
	}

	@Override
	public boolean method_25401(double mouseX, double mouseY, double amountX, double amountY) {
		if (menu != null) {
			return menu.method_25401(mouseX, mouseY, amountX, amountY);
		}
		return false;
	}

	@Override
	public boolean method_25404(class_11908 event) {
		if (menu != null) {
			if (event.comp_4795() == class_3675.field_31958) {
				removeMenu();
				return true;
			}
			return menu.method_25404(event);
		}
		return false;
	}

	@Override
	public boolean method_16803(class_11908 event) {
		if (menu != null) {
			return menu.method_16803(event);
		}
		return false;
	}

	@Override
	public boolean method_25400(class_11905 event) {
		if (menu != null) {
			return menu.method_25400(event);
		}
		return false;
	}

	@Nullable
	@Override
	public class_8016 method_48205(class_8023 event) {
		if (menu != null) {
			return menu.method_48205(event);
		}
		return class_364.super.method_48205(event);
	}

	@Override
	public boolean method_25405(double mouseX, double mouseY) {
		if (menu != null) {
			return menu.method_25405(mouseX, mouseY);
		}
		return false;
	}

	@Nullable
	@Override
	public class_8016 method_48218() {
		if (menu != null) {
			return menu.method_48218();
		}
		return class_364.super.method_48218();
	}

	@Override
	public @NotNull class_8030 method_48202() {
		if (menu != null) {
			return menu.method_48202();
		}
		return class_364.super.method_48202();
	}

	@Override
	public class_6380 method_37018() {
		if (menu != null) {
			return menu.method_37018();
		}
		return class_6380.field_33784;
	}

	@Override
	public void method_37020(class_6382 builder) {
		if (menu != null) {
			menu.method_37020(builder);
		}
	}
}
