/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.List;
import net.minecraft.class_10415;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5481;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import io.github.axolotlclient.api.requests.GlobalDataRequest;

public class NewsScreen extends class_437 {

	private final class_437 parent;

	public NewsScreen(class_437 parent) {
		super(class_2561.method_43471("api.notes.title"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		super.method_25394(graphics, mouseX, mouseY, delta);

		graphics.method_27534(field_22793, field_22785, field_22789 / 2, 20, -1);
	}

	@Override
	protected void method_25426() {
		GlobalDataRequest.get().thenAccept(data -> method_37063(new NewsWidget(25, 35, field_22789 - 50, field_22790 - 100, class_2561.method_43470(data.notes().trim().replaceAll("([^\n])\n([^\n])", "$1 $2")))));
		method_37063(class_4185.method_46430(class_5244.field_24339, buttonWidget -> field_22787.method_1507(parent)).method_46434(field_22789 / 2 - 100, field_22790 - 45, 200, 20).method_46431());
	}

	private class NewsWidget extends class_10415 {

		private final List<class_5481> lines;
		private final int contentHeight;

		public NewsWidget(int x, int y, int width, int height, class_2561 component) {
			super(x, y, width, height, component);
			lines = field_22793.method_1728(method_25369(), method_25368() - 4);
			contentHeight = lines.size() * field_22793.field_2000;
		}

		@Override
		protected int method_44391() {
			return contentHeight;
		}

		@Override
		protected void method_44389(class_332 graphics, int mouseX, int mouseY, float partialTick) {
			int y = method_46427() + 2;
			for (class_5481 chsq : lines) {
				graphics.method_35720(field_22793, chsq, method_46426() + 2, y, -1);
				y += field_22793.field_2000;
			}
		}

		@Override
		protected double method_44393() {
			return field_22793.field_2000;
		}

		@Override
		protected void method_47399(class_6382 narrationElementOutput) {
			narrationElementOutput.method_37034(class_6381.field_33788, method_25369());
		}

		@Override
		protected void method_44386(class_332 guiGraphics) {
		}
	}
}
