/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.net.URI;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import net.minecraft.class_7843;
import net.minecraft.class_7940;
import net.minecraft.class_8667;
import io.github.axolotlclient.util.OSUtil;

public class PrivacyNoticeScreen extends class_437 {

	private static final URI TERMS_URI = URI.create(Constants.TERMS);

	private final class_437 parent;
	private final CompletableFuture<Boolean> accepted;

	protected PrivacyNoticeScreen(class_437 parent, CompletableFuture<Boolean> accepted) {
		super(class_2561.method_43471("api.privacyNotice"));
		this.parent = parent;
		this.accepted = accepted;
	}

	@Override
	protected void method_25426() {

		var frame = new class_7843(field_22789, field_22790);
		var layout = frame.method_46441(class_8667.method_52741()).method_52735(20);
		layout.method_52740().method_46467();
		layout.method_52736(new class_7842(method_25440(), method_64506()));
		layout.method_52736(new class_7940(class_2561.method_43471("api.privacyNotice.description"), method_64506()))
			.method_48981(true).method_48984(field_22789 - 50);
		var buttons = layout.method_52736(class_8667.method_52742()).method_52735(4);
		buttons.method_52736(class_4185.method_46430(class_2561.method_43471("api.privacyNotice.accept"), buttonWidget -> {
			field_22787.method_1507(parent);
			APIOptions.getInstance().privacyAccepted.set(Options.PrivacyPolicyState.ACCEPTED);
			accepted.complete(true);
		}).method_46432(100).method_46431());
		buttons.method_52736(class_4185.method_46430(class_2561.method_43471("api.privacyNotice.deny"), buttonWidget -> {
			field_22787.method_1507(parent);
			APIOptions.getInstance().enabled.set(false);
			APIOptions.getInstance().privacyAccepted.set(Options.PrivacyPolicyState.DENIED);
			accepted.complete(false);
		}).method_46432(100).method_46431());
		buttons.method_52736(class_4185.method_46430(class_2561.method_43471("api.privacyNotice.openPolicy"),
			buttonWidget -> OSUtil.getOS().open(TERMS_URI)).method_46432(100).method_46431());
		frame.method_48222();
		frame.method_48206(this::method_37063);
	}
}
