/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Persistence;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8021;
import net.minecraft.class_8132;
import net.minecraft.class_8662;
import net.minecraft.class_8667;
import net.minecraft.client.gui.components.*;

public class CreateChannelScreen extends class_437 {
	private final class_437 parent;

	protected CreateChannelScreen(class_437 parent) {
		super(class_2561.method_43471("api.chat.groups.create"));
		this.parent = parent;
	}

	@Override
	protected void method_25426() {

		class_8132 layout = new class_8132(this);
		layout.method_57726(field_22785, field_22793);

		class_8667 content = class_8667.method_52742().method_52735(8);
		content.method_52740().method_46472();
		content.method_52740().method_46467();

		var names = content.method_52736(class_8667.method_52741().method_52735(20 - field_22793.field_2000 + 8 - 5));
		names.method_52740().method_46471(5);
		var options = content.method_52736(class_8667.method_52741().method_52735(8));
		var nameField = new class_342(field_22793, 150, 20, class_2561.method_43473());
		names.method_52736(text("api.chat.groups.name"));
		options.method_52736(nameField);

		AtomicReference<Supplier<Integer>> count = new AtomicReference<>();
		AtomicReference<Supplier<Long>> duration = new AtomicReference<>();

		AtomicReference<Consumer<Boolean>> countDisabler = new AtomicReference<>();
		AtomicReference<Consumer<Boolean>> durationDisabler = new AtomicReference<>();
		var persistence = class_5676.method_32606(
				type -> class_2561.method_43471("api.chat.persistence." + type.getId()), Persistence.Type.CHANNEL)
			.method_32624(Persistence.Type.values()).method_32616()
			.method_57720(class_2561.method_43473(), (cyclingButtonWidget, object) -> {
				switch (object) {
					case COUNT_DURATION -> {
						countDisabler.get().accept(true);
						countDisabler.get().accept(true);
					}
					case DURATION -> {
						durationDisabler.get().accept(true);
						countDisabler.get().accept(false);
					}
					case COUNT -> {
						countDisabler.get().accept(true);
						durationDisabler.get().accept(false);
					}
					case CHANNEL -> {
						countDisabler.get().accept(false);
						durationDisabler.get().accept(false);
					}
				}
			});
		names.method_52736(text("api.chat.groups.persistence"));
		options.method_52736(persistence);
		names.method_52736(text("api.chat.groups.persistence.count", "api.chat.groups.persistence.count.tooltip"));
		countDisabler.set(sliderAssembly(options::method_52736, val -> (int) (val * 100d), count::set));
		names.method_52736(text("api.chat.groups.persistence.duration", "api.chat.groups.persistence.duration.tooltip"));
		durationDisabler.set(sliderAssembly(options::method_52736, val -> (long) (val * 100d), duration::set));
		countDisabler.get().accept(false);
		durationDisabler.get().accept(false);

		var namesInput = options.method_52736(new class_342(field_22793, 150, 20, class_2561.method_43473()));
		names.method_52736(text("api.chat.groups.participants"));

		layout.method_48999(content);

		var footer = class_8667.method_52742().method_52735(8);
		footer.method_52736(class_4185.method_46430(class_5244.field_24335, widget -> field_22787.method_1507(parent)).method_46431());
		footer.method_52736(class_4185.method_46430(class_5244.field_24334, widget ->
			ChannelRequest.createChannel(nameField.method_1882(), Persistence.of(persistence.method_32603(), count.get().get(),
				duration.get().get()
			),
			Arrays.stream(namesInput.method_1882().split(",")).filter(s -> !s.isEmpty())
				.toArray(String[]::new)
		).thenRun(() -> field_22787.execute(() -> field_22787.method_1507(parent)))).method_46431());
		layout.method_48996(footer);

		layout.method_48222();
		layout.method_48206(this::method_37063);
	}

	private <T> Consumer<Boolean> sliderAssembly(Consumer<class_8021> layoutConsumer, Function<Double, T> valueFunc, Consumer<Supplier<T>> value) {

		AtomicReference<T> currentVal = new AtomicReference<>();
		var slider = new class_357(0, 0, 128, 20, class_2561.method_43473(), 0) {
			@Override
			protected void method_25346() {
				method_25355(class_2561.method_43470(String.valueOf(valueFunc.apply(field_22753))));
			}

			@Override
			protected void method_25344() {
				currentVal.set(valueFunc.apply(field_22753));
			}

			public void method_25347(double v) {
				this.field_22753 = v;
			}
		};
		slider.method_25346();
		slider.method_25344();
		value.accept(currentVal::get);
		var text = new class_342(field_22793, 128, 20, class_2561.method_43473());
		var textButton = class_8662.method_52723(class_2561.method_43471("slider.text_input"), w -> {
			if (slider.field_22764) {
				text.method_48229(slider.method_46426(), slider.method_46427());
				text.method_25358(slider.method_25368());
				text.method_53533(slider.method_25364());
				text.method_1852(String.valueOf(currentVal.get()));
			} else {
				try {
					slider.method_25347(Double.parseDouble(text.method_1882()));
				} catch (Exception ignored) {
				}
			}
			slider.field_22764 = !slider.field_22764;
			text.field_22764 = !slider.field_22764;
		}, true).method_52727(class_2960.method_60655("axolotlclient", "cursor"), 8, 8).method_52726(20, 20).method_52724();
		var assembly = class_8667.method_52742().method_52735(2);
		assembly.method_52736(slider);
		assembly.method_52736(textButton);
		text.field_22764 = false;
		method_37063(text);
		layoutConsumer.accept(assembly);
		return val -> slider.field_22763 = textButton.field_22763 = text.field_22763 = val;
	}

	private class_8021 text(String translationKey) {
		return new class_7842(150, field_22793.field_2000, class_2561.method_43471(translationKey), field_22793);
	}

	private class_8021 text(String translationKey, String tooltipKey) {
		var widget = new class_7842(150, field_22793.field_2000, class_2561.method_43471(translationKey), field_22793);
		widget.method_47400(class_7919.method_47407(class_2561.method_43471(tooltipKey)));
		return widget;
	}
}
