/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.multiplayer;

import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.api.handlers.StatusUpdateHandler;
import io.github.axolotlclient.api.requests.FriendRequest;
import lombok.Getter;
import net.minecraft.class_1074;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_412;
import net.minecraft.class_4185;
import net.minecraft.class_420;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_5244;
import net.minecraft.class_639;
import net.minecraft.class_641;
import net.minecraft.class_642;
import net.minecraft.class_644;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_8132;
import net.minecraft.class_8667;

public class FriendsMultiplayerScreen extends class_437 {
	@Getter
	private final class_644 pinger = new class_644();
	private final class_437 lastScreen;
	protected FriendsMultiplayerSelectionList serverSelectionList;
	private class_4185 selectButton;
	private final class_4185 friendsCountButton = class_4185.method_46430(class_2561.method_43469("api.servers.friends", "..."), button -> {
	}).method_46431();
	private class_642 editingServer;
	private static final class_2561 NO_ONLINE_FRIENDS = class_2561.method_43471("api.servers.friends.no_online_friends");
	private final class_8132 layout = new class_8132(this, 60, 60);

	public FriendsMultiplayerScreen(class_437 lastScreen) {
		super(class_2561.method_43471("api.servers.friends.title"));
		this.lastScreen = lastScreen;
	}

	@Override
	protected void method_25426() {

		var header = this.layout.method_48992(class_8667.method_52741()).method_52735(8);
		header.method_52738(new class_7842(method_25440(), method_64506()), class_7847::method_46467);
		var headerRow = header.method_52736(class_8667.method_52742()).method_52735(4);
		headerRow.method_52740().method_46467();
		headerRow.method_52736(class_4185.method_46430(class_2561.method_43471("api.servers"), button ->
			field_22787.method_1507(new class_500(lastScreen))).method_46432(100).method_46431());
		headerRow.method_52736(friendsCountButton);
		friendsCountButton.method_25358(100);
		friendsCountButton.field_22763 = false;


		this.serverSelectionList = this.layout.method_48999(new FriendsMultiplayerSelectionList(this, this.field_22787, this.field_22789, this.layout.method_57727(), layout.method_48998(), 36));
		FriendRequest.getInstance().getFriends().thenAccept(friends -> {
			friendsCountButton.method_25355(class_2561.method_43469("api.servers.friends", friends.stream().filter(u -> u.getStatus().isOnline()).count()));
			this.serverSelectionList.updateList(friends);
		});
		StatusUpdateHandler.addUpdateListener("friends_multiplayer_screen", serverSelectionList::updateEntry);

		/*addRenderableWidget(Button.builder(Component.translatable("api.servers"), button ->
			minecraft.setScreen(new JoinMultiplayerScreen(lastScreen))).pos(this.width / 2 - 102, 32).width(100).build());
		addRenderableWidget(friendsCountButton).setRectangle(100, 20, width / 2 + 2, 32);
		friendsCountButton.active = false;*/

		class_8667 linearLayout = this.layout.method_48996(class_8667.method_52741().method_52735(4));
		linearLayout.method_52740().method_46467();
		class_8667 linearLayout2 = linearLayout.method_52736(class_8667.method_52742().method_52735(4));
		class_8667 linearLayout3 = linearLayout.method_52736(class_8667.method_52742().method_52735(4));

		this.selectButton = linearLayout2.method_52736(class_4185.method_46430(class_2561.method_43471("selectServer.select"), buttonx -> this.joinSelectedServer()).method_46432(100).method_46431());
		class_4185 directConnect = linearLayout2.method_52736(class_4185.method_46430(class_2561.method_43471("selectServer.direct"), buttonx -> {
			this.editingServer = new class_642(class_1074.method_4662("selectServer.defaultName"), "", class_642.class_8678.field_45611);
			this.field_22787.method_1507(new class_420(this, this::directJoinCallback, this.editingServer));
		}).method_46432(100).method_46431());
		class_4185 friends = linearLayout2.method_52736(class_4185.method_46430(class_2561.method_43471("api.friends"), buttonx ->
			this.field_22787.method_1507(new FriendsScreen(this))).method_46432(100).method_46431());
		class_4185 editButton = linearLayout3.method_52736(class_4185.method_46430(class_2561.method_43471("selectServer.edit"), buttonx -> {
		}).method_46432(74).method_46431());
		editButton.field_22763 = false;
		class_4185 deleteButton = linearLayout3.method_52736(class_4185.method_46430(class_2561.method_43471("selectServer.delete"), buttonx -> {
		}).method_46432(74).method_46431());
		deleteButton.field_22763 = false;
		class_4185 refreshList = linearLayout3.method_52736(
			class_4185.method_46430(class_2561.method_43471("selectServer.refresh"), buttonx -> this.refreshServerList()).method_46432(74).method_46431()
		);
		class_4185 back = linearLayout3.method_52736(class_4185.method_46430(class_5244.field_24339, buttonx -> this.method_25419()).method_46432(74).method_46431());
		/*LinearLayout linearLayout = LinearLayout.vertical();
		EqualSpacingLayout equalSpacingLayout = linearLayout.addChild(new EqualSpacingLayout(308, 20, EqualSpacingLayout.Orientation.HORIZONTAL));
		equalSpacingLayout.addChild(this.selectButton);
		equalSpacingLayout.addChild(directConnect);
		equalSpacingLayout.addChild(friends);
		linearLayout.addChild(SpacerElement.height(4));
		EqualSpacingLayout equalSpacingLayout2 = linearLayout.addChild(new EqualSpacingLayout(308, 20, EqualSpacingLayout.Orientation.HORIZONTAL));
		equalSpacingLayout2.addChild(editButton);
		equalSpacingLayout2.addChild(deleteButton);
		equalSpacingLayout2.addChild(refreshList);
		equalSpacingLayout2.addChild(back);
		linearLayout.arrangeElements();
		FrameLayout.centerInRectangle(linearLayout, 0, this.height - 64, this.width, 64);*/
		layout.method_48206(this::method_37063);
		this.method_48640();
		this.onSelectedChange();
	}

	@Override
	protected void method_48640() {
		this.layout.method_48222();
		if (this.serverSelectionList != null) {
			this.serverSelectionList.method_57712(this.field_22789, this.layout);
		}
	}

	@Override
	public void method_25419() {
		this.field_22787.method_1507(this.lastScreen);
	}

	@Override
	public void method_25393() {
		this.pinger.method_3000();
	}

	@Override
	public void method_25432() {
		StatusUpdateHandler.removeUpdateListener("friends_multiplayer_screen");
		this.pinger.method_3004();
	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);

		if (serverSelectionList.method_25396().isEmpty()) {
			guiGraphics.method_27534(field_22793, NO_ONLINE_FRIENDS, field_22789 / 2, field_22790 / 2 - field_22793.field_2000 / 2, -1);
		}
	}

	private void refreshServerList() {
		this.field_22787.method_1507(new FriendsMultiplayerScreen(this.lastScreen));
	}

	private void directJoinCallback(boolean confirmed) {
		if (confirmed) {
			class_641 servers = new class_641(field_22787);
			servers.method_2981();
			class_642 serverData = servers.method_44295(this.editingServer.field_3761);
			if (serverData == null) {
				servers.method_2988(this.editingServer, true);
				servers.method_2987();
				this.join(this.editingServer);
			} else {
				this.join(serverData);
			}
		} else {
			this.field_22787.method_1507(this);
		}
	}

	public void joinSelectedServer() {
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.method_25334();
		if (entry != null) {
			this.join(entry.getServerData());
		}
	}

	private void join(class_642 server) {
		if (server == null) {
			return;
		}
		class_412.method_36877(this, this.field_22787, class_639.method_2950(server.field_3761), server, false, null);
	}

	public void setSelected(FriendsMultiplayerSelectionList.Entry selected) {
		this.serverSelectionList.setSelected(selected);
		this.onSelectedChange();
	}

	protected void onSelectedChange() {
		this.selectButton.field_22763 = false;
		FriendsMultiplayerSelectionList.Entry entry = this.serverSelectionList.method_25334();
		if (entry != null && !(entry instanceof FriendsMultiplayerSelectionList.LoadingHeader)) {
			this.selectButton.field_22763 = entry.canJoin();
		}
	}
}
