/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1011;
import net.minecraft.class_10799;
import net.minecraft.class_12239;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_642;
import net.minecraft.class_644;
import net.minecraft.class_8573;
import io.github.axolotlclient.bridge.PlatformDispatch;
import io.github.axolotlclient.bridge.impl.AxoSpriteImpl;
import io.github.axolotlclient.bridge.render.AxoSprite;
import io.github.axolotlclient.mixin.MinecraftServerAccessor;
import io.github.axolotlclient.modules.hypixel.autoboop.FilterListConfigurationScreen;
import io.github.axolotlclient.util.ThreadExecuter;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value = PlatformDispatch.class, remap = false)
public abstract class PlatformDispatchMixin {
	@Unique
	private static final class_644 axo$pinger = new class_644();

	@Unique
	private static void getRealTimeServerPing(class_642 server, MutableInt currentServerPing) {
		ThreadExecuter.scheduleTask(() -> {
			try {
				axo$pinger.method_3003(server, () -> {
					}, () -> currentServerPing.setValue(server.field_3758),
					class_12239.method_75867(class_310.method_1551().field_1690.method_1639()));
			} catch (Exception ignored) {
			}
		});
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge.
	 */
	@Overwrite
	public static void pingHud$updatePing(MutableInt currentServerPing) {
		final var minecraft = class_310.method_1551();
		if (minecraft.method_1558() != null) {
			getRealTimeServerPing(minecraft.method_1558(), currentServerPing);
		} else if (minecraft.method_1496()) {
			currentServerPing.setValue(1);
		}
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge.
	 */
	@Overwrite
	public static AxoSprite.Dynamic ipHud$getServerIcon() throws IOException {
		final var minecraft = class_310.method_1551();

		final var icon = minecraft.method_1558() == null ?
			class_8573.method_52200(minecraft.method_1531(), ((MinecraftServerAccessor) minecraft.method_1576()).getStorageSource().method_27005()) :
			class_8573.method_52202(minecraft.method_1531(), Objects.requireNonNull(minecraft.method_1558()).field_3761);

		try {
			final class_1011 img;
			if (minecraft.method_1558() == null) {
				var i = minecraft.method_1576().method_3765().comp_1276();
				if (i.isEmpty()) {
					return null;
				} else {
					img = class_1011.method_49277(i.get().comp_1278());
				}
			} else {
				img = class_1011.method_49277(minecraft.method_1558().method_49306());
			}
			icon.method_52199(img);
		} catch (Throwable e) {
			icon.close();
			throw e;
		}

		class Impl implements AxoSprite.Dynamic, AxoSpriteImpl {
			@Override
			public void draw(class_310 client, class_332 stack, int sX, int sY, int sW, int sH) {
				stack.method_25291(class_10799.field_56883, icon.method_52201(), sX, sY, 0, 0, sW, sH, sW, sH, -1);
			}

			@Override
			public void close() {
				minecraft.execute(icon::close);
			}
		}

		return new Impl();
	}

	/**
	 * @author moehreag
	 * @reason Implement bridge.
	 */
	@Overwrite
	public static void autoBoop$openFiltersScreen(List<String> filters) {
		class_310.method_1551().method_1507(new FilterListConfigurationScreen(filters, class_310.method_1551().field_1755));
	}
}
