/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.internal;

import java.util.Objects;
import net.minecraft.class_10209;
import net.minecraft.class_1074;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_156;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_268;
import net.minecraft.class_270;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_640;
import net.minecraft.class_6880;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.bridge.AxoMinecraftClient;
import io.github.axolotlclient.bridge.AxoPlayerListEntry;
import io.github.axolotlclient.bridge.entity.effect.AxoStatusEffect;
import io.github.axolotlclient.bridge.entity.effect.AxoStatusEffectInstance;
import io.github.axolotlclient.bridge.impl.AxoSpriteImpl;
import io.github.axolotlclient.bridge.internal.PlatformImplInternal;
import io.github.axolotlclient.bridge.item.AxoItem;
import io.github.axolotlclient.bridge.item.AxoItemStack;
import io.github.axolotlclient.bridge.key.AxoKey;
import io.github.axolotlclient.bridge.key.AxoKeybinding;
import io.github.axolotlclient.bridge.key.AxoKeys;
import io.github.axolotlclient.bridge.render.AxoSprite;
import io.github.axolotlclient.bridge.render.AxoWindow;
import io.github.axolotlclient.bridge.scores.AxoTeam;
import io.github.axolotlclient.bridge.util.AxoIdentifier;
import io.github.axolotlclient.bridge.util.AxoProfiler;
import io.github.axolotlclient.bridge.util.AxoText;
import io.github.axolotlclient.mixin.MinecraftClientAccessor;
import io.github.axolotlclient.util.keybinds.KeyBinds;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;

@SuppressWarnings("OverwriteModifiers")
@Mixin(value = PlatformImplInternal.class, remap = false)
public abstract class PlatformImplInternalMixin {
	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static @Nullable AxoWindow getWindow() {
		return class_310.method_1551().method_22683();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoMinecraftClient getMinecraftClientInstance() {
		return class_310.method_1551();
	}

	/**
	 * @author moehreag
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoProfiler getProfiler() {
		return class_10209.method_64146();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static String getTranslatedString(String nameKey, Object[] args) {
		return class_1074.method_4662(nameKey, args);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoItemStack createItemStack(AxoItem item, int count) {
		return new class_1799((class_1792) item, count);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static long getMeasuringTimeMs() {
		return class_156.method_658();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxolotlClientConfigCommon getConfig() {
		return AxolotlClient.config();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static int getCurrentFps() {
		return MinecraftClientAccessor.axolotlclient$getCurrentFps();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoKeybinding createKeyBinding(AxoKey defaultKey, String name) {
		int code = ((class_3675.class_306) Objects.requireNonNullElse(defaultKey, AxoKeys.KEY_UNKNOWN)).method_1444();
		final var binding = new class_304(name, code, KeyBinds.CATEGORY_AXOLOTLCLIENT);
		KeyBinds.getInstance().register(binding);
		return binding;
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoIdentifier createIdentifier(String ns, String path) {
		return class_2960.method_60655(ns, path);
	}

	/**
	 * @author moehreag
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoText.Mutable createEmpty() {
		return class_2561.method_43473();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoText.Mutable createLiteral(String text) {
		return class_2561.method_43470(text);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoText.Mutable createTranslatable(String key, Object... args) {
		return class_2561.method_43469(key, args);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static int tickCount() {
		return class_310.method_1551().field_1705.method_1738();
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static String stripText(String text) {
		return class_124.method_539(text);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static String getTabNameFor(AxoPlayerListEntry player) {
		return class_124.method_539(
			class_310.method_1551().field_1705
				.method_1750()
				.method_1918((class_640) player)
				.getString()
		);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static void setTabListHeader(AxoText text) {
		class_310.method_1551().field_1705.method_1750().method_1925((class_2561) text);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoStatusEffectInstance createStatusEffectInstance(AxoStatusEffect effect, int duration) {
		return new class_1293(new class_6880.class_6881<>((class_1291) effect), duration);
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static AxoSprite createTexture(GraphicsOption option) {
		return (AxoSpriteImpl) (client, stack, sX, sY, sW, sH) ->
			stack.method_25290(
				class_10799.field_56883,
				io.github.axolotlclient.util.Util.getTexture(option), sX, sY, 0, 0,
				sW, sH, option.get().getWidth(), option.get().getHeight()
			);
	}

	/**
	 * @author moehreag
	 * @reason Implement bridge platform.
	 */
	@Overwrite
	public static String getTeamMemberDisplayName(AxoTeam team, String s) {
		return class_268.method_1142((class_270) team, class_2561.method_43470(s)).getString();
	}
}
