/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.item;

import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.class_10630;
import net.minecraft.class_1304;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import io.github.axolotlclient.bridge.item.AxoItemStack;
import io.github.axolotlclient.bridge.item.AxoPlayerInventory;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1661.class)
public abstract class PlayerInventoryMixin implements AxoPlayerInventory {
	@Shadow
	public abstract int getContainerSize();

	@Shadow
	public abstract class_1799 getItem(int slot);

	@Shadow
	public abstract class_1799 getSelectedItem();

	@Shadow
	@Final
	private class_10630 equipment;

	@Shadow
	@Final
	private class_2371<class_1799> items;

	@Override
	public AxoItemStack br$getMainHand() {
		return getSelectedItem();
	}

	@Override
	public List<? extends AxoItemStack> br$getItems() {
		return IntStream.range(0, getContainerSize())
			.mapToObj(this::getItem)
			.toList();
	}

	@Override
	public List<? extends AxoItemStack> br$getArmor() {
		return Stream.of(class_1304.field_6166, class_1304.field_6172, class_1304.field_6174, class_1304.field_6169)
			.map(slot -> equipment.method_66659(slot))
			.toList();
	}

	@Override
	public List<? extends AxoItemStack> br$getNonEquipmentItems() {
		return items.subList(9, 36);
	}

	@Override
	public AxoItemStack br$getOffHand() {
		return equipment.method_66659(class_1304.field_6171);
	}
}
