/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_481;
import net.minecraft.class_5684;
import net.minecraft.class_8000;
import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.github.axolotlclient.modules.scrollableTooltips.ScrollableTooltips;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;

@Mixin(class_332.class)
public abstract class GuiGraphicsMixin {

	@Unique
	private int recursionDepth;

	@WrapMethod(method = "renderTooltip")
	private void axolotlclient$scrollableTooltipsX(class_327 font, List<class_5684> list, int x, int y, class_8000 clientTooltipPositioner, @Nullable class_2960 resourceLocation, Operation<Void> original) {
		if (ScrollableTooltips.getInstance().enabled.get()) {
			class_310 mc = class_310.method_1551();
			if ((!(mc.field_1755 instanceof class_481 c)) || c.method_47424()) {
				if (recursionDepth == 0) {
					x += ScrollableTooltips.getInstance().tooltipOffsetX;
					y += ScrollableTooltips.getInstance().tooltipOffsetY;
				}
			}
		}
		recursionDepth++;
		original.call(font, list, x, y, clientTooltipPositioner, resourceLocation);
		recursionDepth--;
	}
}
