/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.api.requests.UserRequest;
import io.github.axolotlclient.modules.hypixel.LevelHead;
import io.github.axolotlclient.modules.hypixel.NickHider;
import io.github.axolotlclient.modules.hypixel.bedwars.BedwarsMod;
import io.github.axolotlclient.util.duck.SubmitNodeCollectorExtension;
import net.minecraft.class_10055;
import net.minecraft.class_1007;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1007.class)
public abstract class PlayerEntityRendererMixin {

	@WrapOperation(method = "submitNameTag(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V",
		at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/SubmitNodeCollector;submitNameTag(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;ILnet/minecraft/network/chat/Component;ZIDLnet/minecraft/client/renderer/state/CameraRenderState;)V"))
	private void axolotlclient$modifiyName(class_11659 instance, class_4587 poseStack, class_243 vec3, int a, class_2561 component, boolean b, int i, double v, class_12075 cameraRenderState, Operation<Void> original, @Local(argsOnly = true) class_10055 state) {
		if (AxolotlClient.config() != null) {
			var mc = class_310.method_1551();
			if (mc.field_1724 != null) {
				class_1937 level = class_310.method_1551().field_1687;
				class_1297 player = level.method_8469(state.field_53528);
				boolean self = player.method_5667() == mc.field_1724.method_5667();
				if (self && NickHider.getInstance().hideOwnName.get()) {
					component = (class_2561) NickHider.getInstance().editComponent(component, player.method_5477().getString(), NickHider.getInstance().hiddenNameSelf.get());
				} else if (!self && NickHider.getInstance().hideOtherNames.get()) {
					component = (class_2561) NickHider.getInstance().editComponent(component, player.method_5477().getString(), NickHider.getInstance().hiddenNameOthers.get());
				}
			}
		}
		original.call(instance, poseStack, vec3, a, component, b, i, v, cameraRenderState);
	}

	@Inject(method = "submitNameTag(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/renderer/SubmitNodeCollector;submitNameTag(Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/world/phys/Vec3;ILnet/minecraft/network/chat/Component;ZIDLnet/minecraft/client/renderer/state/CameraRenderState;)V", ordinal = 1, shift = At.Shift.AFTER))
	public void axolotlclient$addBadges(class_10055 state, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
		if (!state.field_53334) {
			if (AxolotlClient.config().showBadges.get()) {
				class_1657 entity = (class_1657) class_310.method_1551().field_1687.method_8469(state.field_53528);
				if (entity != null && UserRequest.getOnline(entity.method_5845())) {
					((SubmitNodeCollectorExtension) submitNodeCollector).axolotlclient$lastNameTagSubmitHasBadge();
				}
			}
		}
	}

	@Inject(method = "submitNameTag(Lnet/minecraft/client/renderer/entity/state/AvatarRenderState;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;Lnet/minecraft/client/renderer/state/CameraRenderState;)V", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V"))
	private void addLevel(class_10055 state, class_4587 poseStack, class_11659 submitNodeCollector, class_12075 cameraRenderState, CallbackInfo ci) {
		if (class_310.method_1551().method_1558() != null && class_310.method_1551().method_1558().field_3761.endsWith("hypixel.net")) {
			class_742 entity = (class_742) class_310.method_1551().field_1687.method_8469(state.field_53528);
			if (entity != null) {
				if (BedwarsMod.getInstance().isEnabled() && BedwarsMod.getInstance().inGame() && BedwarsMod.getInstance().bedwarsLevelHead.get()) {
					String text = BedwarsMod.getInstance().getGame().get().getLevelHead(entity);
					if (text != null) {
						var y = state.field_62758 ? -20 : -10;

						if (LevelHead.getInstance().background.get()) {
							y -= 2;
						}

						submitNodeCollector.method_73482(poseStack, state.field_53338, y, class_2561.method_43470(text).method_27694(s -> s.method_36139(LevelHead.getInstance().textColor.get().toInt())), !state.field_53334, state.field_61820, state.field_53332, cameraRenderState);
						((SubmitNodeCollectorExtension) submitNodeCollector).axolotlclient$lastNameTagSubmitIsLevelHead();
					}
				} else if (LevelHead.getInstance().enabled.get()) {
					String text = LevelHead.getInstance().getDisplayString(entity.method_5845());

					var y = state.field_62758 ? -20 : -10;

					if (LevelHead.getInstance().background.get()) {
						y -= 2;
					}

					submitNodeCollector.method_73482(poseStack, state.field_53338, y, class_2561.method_43470(text).method_27694(s -> s.method_36139(LevelHead.getInstance().textColor.get().toInt())), !state.field_53334, state.field_61820, state.field_53332, cameraRenderState);
					((SubmitNodeCollectorExtension) submitNodeCollector).axolotlclient$lastNameTagSubmitIsLevelHead();
				}
			}
		}
	}
}
