/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.AxolotlClient;
import net.minecraft.class_10509;
import net.minecraft.class_11659;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_811;
import net.minecraft.class_9323;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_10509.class)
public abstract class ShieldSpecialRendererMixin {

	@Inject(method = "submit(Lnet/minecraft/core/component/DataComponentMap;Lnet/minecraft/world/item/ItemDisplayContext;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/SubmitNodeCollector;IIZI)V", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/model/object/equipment/ShieldModel;handle()Lnet/minecraft/client/model/geom/ModelPart;"))
	private void axolotlclient$lowShield(class_9323 dataComponentMap, class_811 itemDisplayContext, class_4587 poseStack, class_11659 submitNodeCollector, int i, int j, boolean bl, int k, CallbackInfo ci) {
		if (AxolotlClient.config().lowShield.get()
			&& class_310.method_1551().field_1690.method_31044().method_31034()
			&& (itemDisplayContext.equals(class_811.field_4321)
			|| itemDisplayContext.equals(class_811.field_4322))) {
			poseStack.method_46416(0, 0.2F, 0);
		}
	}
}
