/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4008;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_4008.class)
public abstract class SplashTextResourceSupplierMixin {
	@Unique
	private static final class_2960 EXTRA_SPLASHES = class_2960.method_60655("axolotlclient", "texts/splashes.txt");

	@Inject(method = "prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Ljava/util/List;", at = @At("HEAD"))
	private void addCustomSplashesLoad(class_3300 resourceManager, class_3695 profiler, CallbackInfoReturnable<List<class_2561>> cir, @Share("axolotlclient_splashes") LocalRef<BufferedReader> reader) {
		try {
			reader.set(class_310.method_1551().method_1478().openAsReader(EXTRA_SPLASHES));
		} catch (IOException ignored) {
		}
	}

	@WrapOperation(method = "prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Ljava/util/List;", at = @At(value = "INVOKE", target = "Ljava/io/BufferedReader;lines()Ljava/util/stream/Stream;"))
	private Stream<String> axolotlclient$addCustomSplashes(BufferedReader instance, Operation<Stream<String>> original, @Share("axolotlclient_splashes") LocalRef<BufferedReader> reader) {
		var stream = original.call(instance);
		return Stream.concat(stream, original.call(reader.get()));
	}

	@Inject(method = "prepare(Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)Ljava/util/List;", at = @At("RETURN"))
	private void addCustomSplashesClose(class_3300 resourceManager, class_3695 profiler, CallbackInfoReturnable<List<class_2561>> cir, @Share("axolotlclient_splashes") LocalRef<BufferedReader> reader) {
		try {
			reader.get().close();
		} catch (IOException ignored) {
		}
	}
}
