/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin.api;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.multiplayer.FriendsMultiplayerScreen;
import io.github.axolotlclient.api.requests.FriendRequest;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_500;
import net.minecraft.class_7842;
import net.minecraft.class_7847;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_500.class)
public abstract class JoinMulitplayerScreenMixin extends class_437 {

	@Shadow
	@Final
	private class_437 lastScreen;
	@Unique
	private static final boolean WORLD_HOST_INSTALLED = FabricLoader.getInstance().isModLoaded("world-host");

	protected JoinMulitplayerScreenMixin(class_2561 title) {
		super(title);
	}

	@WrapOperation(method = "init", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/layouts/HeaderAndFooterLayout;addTitleHeader(Lnet/minecraft/network/chat/Component;Lnet/minecraft/client/gui/Font;)V"))
	private void modifyHeader(class_8132 instance, class_2561 message, class_327 font, Operation<Void> original) {
		if (API.getInstance().isAuthenticated() && !WORLD_HOST_INSTALLED) {
			instance.method_48995(60);
			var header = instance.method_48992(class_8667.method_52741()).method_52735(8);
			header.method_52738(new class_7842(message, font), class_7847::method_46467);
			var buttons = header.method_52736(class_8667.method_52742()).method_52735(4);
			buttons.method_52736(class_4185.method_46430(class_2561.method_43471("api.servers"), button -> {

			}).method_46432(100).method_46431()).field_22763 = false;
			var friends = buttons.method_52736(class_4185.method_46430(class_2561.method_43469("api.servers.friends", "..."),
				button -> field_22787.method_1507(new FriendsMultiplayerScreen(this.lastScreen))).method_46432(100).method_46431());
			FriendRequest.getInstance().getOnlineFriendCount().thenAccept(count -> friends.method_25355(class_2561.method_43469("api.servers.friends", count)));
		} else {
			original.call(instance, message, font);
		}
	}
}
