/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.bridge.events.Events;
import io.github.axolotlclient.bridge.events.types.PlayerDirectionChangeEvent;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.mixin.GuiGraphicsAccessor;
import io.github.axolotlclient.modules.hud.util.PlayerHudEntityRenderState;
import io.github.axolotlclient.modules.hud.util.PlayerHudEntityRenderer;
import net.minecraft.class_10042;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.minecraft.class_897;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

/**
 * This implementation of Hud modules is based on KronHUD.
 * <a href="https://github.com/DarkKronicle/KronHUD">Github Link.</a>
 *
 * <p>License: GPL-3.0</p>
 */

public class PlayerHud extends PlayerHudCommon {

	private class_10042 reusedPlayerRendererState = null;
	private PlayerHudEntityRenderer renderer;

	public PlayerHud() {
		super();
		Events.PLAYER_DIRECTION_CHANGE.register(this::onPlayerDirectionChange);
	}

	public void onPlayerDirectionChange(PlayerDirectionChangeEvent event) {
		yawOffset += (event.yaw() - event.prevYaw()) / 2;
	}

	@Override
	public void tick() {
		super.tick();
		var client = class_310.method_1551();
		if (client.field_1724 != null && client.field_1724.method_20232()) {
			float rawPitch = client.field_1724.method_5799() ? -90.0F - client.field_1724.method_36455() : -90.0F;
			float pitch = class_3532.method_16439(client.field_1724.method_6024(1), 0.0F, rawPitch);
			float height = client.field_1724.method_17682();
			// sin = opposite / hypotenuse
			float offset = (float) (Math.sin(Math.toRadians(pitch)) * height);
			yOffset = Math.abs(offset);
		} else if (client.field_1724 != null && client.field_1724.method_6128()) {
			// Elytra!

			float j = (float) client.field_1724.method_6003() + 1;
			float k = class_3532.method_15363(j * j / 100.0F, 0.0F, 1.0F);

			float pitch = k * (-90.0F - client.field_1724.method_36455()) + 90;
			float height = client.field_1724.method_17682() / 2f;
			// sin = opposite / hypotenuse
			yOffset = (float) (Math.sin(Math.toRadians(pitch)) * height);
			if (pitch < 0) {
				yOffset -= (float) (((1 / (1 + Math.exp(-pitch / 4))) - .5) * 2);
			}
		} else {
			yOffset *= .8f;
		}
	}

	@Override
	protected void renderPlayer(AxoRenderContext ctx, boolean placeholder, double x, double y, float delta) {
		var client = class_310.method_1551();
		var graphics = (class_332) ctx;
		if (client.field_1724 == null) {
			return;
		}

		if (!placeholder && autoHide.get()) {
			if (isPerformingAction()) {
				hide = -1;
			} else if (hide == -1) {
				hide = System.currentTimeMillis();
			}

			if (hide != -1 && System.currentTimeMillis() - hide > 500) {
				return;
			}
		}

		float lerpY = (lastYOffset + ((yOffset - lastYOffset) * delta));

		float scale = getScale() * 40;

		Quaternionf quaternion = new Quaternionf().rotateZ((float) Math.PI);

		// Rotate to whatever is wanted. Also make sure to offset the yaw
		float deltaYaw = client.field_1724.method_61415(delta);
		if (dynamicRotation.get()) {
			deltaYaw -= (lastYawOffset + ((yawOffset - lastYawOffset) * delta));
		}

		Quaternionf quaternionf2 = new Quaternionf().fromAxisAngleDeg(new Vector3f(0, 1, 0), deltaYaw - 180 + rotation.get().floatValue());
		quaternion.mul(quaternionf2);

		renderEntityInInventory(graphics,
			(int) (x),
			(int) (y),
			(int) (x + getContentWidth() * getScale()),
			(int) (y + getContentHeight() * getScale()),
			scale / client.field_1724.method_55693(),
			new Vector3f(0, client.field_1724.method_17682() / 2f - lerpY * client.field_1724.method_55693(), 0),
			quaternion,
			quaternionf2,
			client.field_1724);
	}

	@SuppressWarnings("unchecked")
	private void renderEntityInInventory(
		class_332 guiGraphics,
		int i,
		int j,
		int k,
		int l,
		float f,
		Vector3f vector3f,
		Quaternionf quaternionf,
		@Nullable Quaternionf quaternionf2,
		class_1309 livingEntity
	) {
		class_310 mc = class_310.method_1551();
		class_898 entityRenderDispatcher = mc.method_1561();
		if (renderer == null)
			renderer = new PlayerHudEntityRenderer(mc.method_22940().method_23000(), entityRenderDispatcher);
		class_897<class_1309, class_10042> entityRenderer = (class_897<class_1309, class_10042>) entityRenderDispatcher.method_3953(livingEntity);
		if (reusedPlayerRendererState == null) {
			reusedPlayerRendererState = entityRenderer.method_55269();
		}
		entityRenderer.method_62354(livingEntity, reusedPlayerRendererState, 1.0f);
		reusedPlayerRendererState.field_53337 = null;
		((GuiGraphicsAccessor) guiGraphics).getGuiRenderState().method_70922(new PlayerHudEntityRenderState(reusedPlayerRendererState, vector3f, quaternionf, quaternionf2, i, j, k, l, f, ((GuiGraphicsAccessor) guiGraphics).getScissorStack().method_70863(), renderer));
	}

	private boolean isPerformingAction() {
		// inspired by tr7zw's mod
		class_746 player = class_310.method_1551().field_1724;
		//noinspection DataFlowIssue
		return player.method_18276() || player.method_5624() || player.method_6128() || player.method_31549().field_7479 ||
			player.method_5869() || player.method_20232() || player.method_5765() || player.method_6115() ||
			player.method_3144() || player.field_6235 > 0 || player.method_5809();
	}
}
