/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.class_11876;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;

public class KeystrokePositioningScreen extends class_437 {
	private final class_437 parent;
	private final KeystrokeHud hud;
	private KeystrokeHud.Keystroke focused;
	private final KeystrokeHud.Keystroke editing;

	public KeystrokePositioningScreen(class_437 parent, KeystrokeHud hud, KeystrokeHud.Keystroke focused) {
		super(class_2561.method_43471("keystrokes.stroke.move"));
		this.parent = parent;
		this.hud = hud;
		if (hud.keystrokes == null) {
			hud.setKeystrokes();
		}
		this.editing = focused;
		mouseDown = false;
	}

	public KeystrokePositioningScreen(class_437 parent, KeystrokeHud hud) {
		this(parent, hud, null);
	}

	private DrawPosition offset = null;
	private boolean mouseDown;
	private SnappingHelper snap;

	@Override
	public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		guiGraphics.method_51448().pushMatrix();
		//guiGraphics.pose().translate(0, 0, -300);
		super.method_25420(guiGraphics, mouseX, mouseY, partialTick);
		HudManager.getInstance().renderPlaceholder(guiGraphics, partialTick);
		guiGraphics.method_51448().popMatrix();
		method_52752(guiGraphics);
	}

	@Override
	protected void method_25426() {
		method_37063(class_4185.method_46430(class_5244.field_24339, b -> method_25419()).method_46433(field_22789 / 2 - 75, field_22790 - 50 + 22).method_46432(150).method_46431());
		this.method_37063(class_4185.method_46430(class_2561.method_43471("hud.snapping").method_27693(": ")
				.method_10852(class_2561.method_43471(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off")),
			buttonWidget -> {
				HudEditScreen.toggleSnapping();
				buttonWidget.method_25355(class_2561.method_43471("hud.snapping").method_27693(": ")
					.method_10852(class_2561.method_43471(HudEditScreen.isSnappingEnabled() ? "options.on" : "options.off")));
				AxolotlClient.getInstance().getConfigManager().save();
			}).method_46434(field_22789 / 2 - 50, field_22790 - 50, 100, 20).method_46431());
	}

	@Override
	public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
		super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		if (editing != null) {
			drawStroke(guiGraphics, mouseX, mouseY, editing);
		} else {
			hud.keystrokes.forEach(s -> drawStroke(guiGraphics, mouseX, mouseY, s));
		}
		if (mouseDown && snap != null) {
			snap.renderSnaps(guiGraphics);
		}
	}

	private void drawStroke(class_332 guiGraphics, int mouseX, int mouseY, KeystrokeHud.Keystroke s) {
		var rect = getScaledRenderPos(s);
		if (rect.isMouseOver(mouseX, mouseY)) {
			DrawUtil.fillRect(guiGraphics, rect, ClientColors.SELECTOR_BLUE.withAlpha(100));
			guiGraphics.method_74037(class_11876.field_62458);
		} else {
			DrawUtil.fillRect(guiGraphics, rect, ClientColors.WHITE.withAlpha(50));
		}
		guiGraphics.method_51448().pushMatrix();
		guiGraphics.method_51448().scale(hud.getScale(), hud.getScale());
		s.render(guiGraphics);
		guiGraphics.method_51448().popMatrix();
		DrawUtil.outlineRect(guiGraphics, rect, Colors.BLACK);
	}

	@Override
	public boolean method_25402(class_11909 event, boolean doubleClick) {
		var value = super.method_25402(event, doubleClick);
		if (event.method_74245() == 0) {
			var mouseX = event.comp_4798();
			var mouseY = event.comp_4799();
			Optional<KeystrokeHud.Keystroke> entry = Optional.empty();
			Optional<Rectangle> pos = Optional.empty();
			if (editing == null) {
				for (KeystrokeHud.Keystroke k : hud.keystrokes) {
					pos = Optional.of(getScaledRenderPos(k));
					if (pos.get().isMouseOver(mouseX, mouseY)) {
						entry = Optional.of(k);
						break;
					}
				}
			} else {
				pos = Optional.of(getScaledRenderPos(editing));
				if (pos.get().isMouseOver(mouseX, mouseY)) {
					entry = Optional.of(editing);
				}
			}
			if (entry.isPresent()) {
				focused = entry.get();
				mouseDown = true;
				var rect = pos.get();
				offset = new DrawPosition((int) Math.round(mouseX - rect.x()),
					(int) Math.round(mouseY - rect.y()));
				updateSnapState();
				return true;
			} else {
				focused = null;
			}
		}
		return value;
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
		hud.saveKeystrokes();
	}

	@Override
	public boolean method_25406(class_11909 event) {
		if (focused != null) {
			hud.saveKeystrokes();
		}
		snap = null;
		mouseDown = false;
		focused = null;
		return super.method_25406(event);
	}

	@Override
	public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
		if (focused != null && mouseDown) {
			focused.setX((int) Math.round((event.comp_4798() - offset.x()) / hud.getScale()));
			focused.setY((int) Math.round((event.comp_4799() - offset.y()) / hud.getScale()));
			if (snap != null) {
				Integer snapX, snapY;
				var rect = getScaledRenderPos(focused);
				snap.setCurrent(rect);
				if ((snapX = snap.getCurrentXSnap()) != null) {
					focused.setX(Math.round(snapX / hud.getScale()));
				}
				if ((snapY = snap.getCurrentYSnap()) != null) {
					focused.setY(Math.round(snapY / hud.getScale()));
				}
			}
			return true;
		}
		return false;
	}

	private Rectangle getScaledRenderPos(KeystrokeHud.Keystroke stroke) {
		return stroke.getRenderPosition().scale(hud.getScale());
	}

	private List<Rectangle> getAllBounds() {
		return Stream.concat(HudManager.getInstance().getAllBounds().stream(), hud.keystrokes.stream().map(this::getScaledRenderPos)).toList();
	}

	private void updateSnapState() {
		if (HudEditScreen.isSnappingEnabled() && focused != null) {
			snap = new SnappingHelper(getAllBounds(), getScaledRenderPos(focused));
		} else if (snap != null) {
			snap = null;
		}
	}
}
