/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import io.github.axolotlclient.api.chat.ChatWidget;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import lombok.Getter;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.client.gui.*;

public class ChatsSidebar extends class_437 implements ContextMenuScreen {

	private static final int ANIM_STEP = 8;
	private final class_437 parent;
	private int sidebarAnimX;
	private int sidebarWidth;
	private boolean remove;
	private boolean hasChat;
	private ListWidget list;
	private class_342 input;
	private Channel channel;

	private ChatWidget chatWidget;

	private ContextMenuContainer contextMenu;

	public ChatsSidebar(class_437 parent) {
		super(class_2561.method_43471("api.chats.sidebar"));
		this.parent = parent;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		if (parent != null) {
			parent.method_25394(graphics, mouseX, mouseY, delta);
		}
		graphics.method_51448().method_22903();
		graphics.method_51448().method_46416(0, 0, 1000);
		graphics.method_25294(sidebarAnimX, 0, sidebarWidth + sidebarAnimX, field_22790, 0x99000000);

		//noinspection DataFlowIssue
		graphics.method_27535(field_22787.field_1772, class_2561.method_43471("api.chats"), 10 + sidebarAnimX, 10, -1);

		if (hasChat) {
			graphics.method_25294(70 + sidebarAnimX, 0, 70 + sidebarAnimX + 1, field_22790, 0xFF000000);
			graphics.method_25303(field_22787.field_1772, channel.getName(), sidebarAnimX + 75, 20, -1);
			if (channel.isDM() && ((Channel.DM) channel).getReceiver().getStatus().isOnline()) {
				graphics.method_25303(field_22787.field_1772, class_124.field_1056 + ((Channel.DM) channel).getReceiver().getStatus().getTitle() + ": " + ((Channel.DM) channel).getReceiver().getStatus().getDescription(),
					sidebarAnimX + 80, 30, 8421504);
			}
		}

		super.method_25394(graphics, mouseX, mouseY, delta);

		animate();
		graphics.method_51448().method_22909();
	}

	@Override
	protected void method_25426() {
		removeChat();
		sidebarWidth = 70;
		sidebarAnimX = -sidebarWidth;

		if (parent != null) {
			parent.method_25396().stream().filter(element -> element instanceof class_339)
				.map(e -> (class_339) e).filter(e -> e.method_25369().equals(class_2561.method_43471("api.chats"))).forEach(e -> e.field_22764 = false);
		}

		ChannelRequest.getChannelList().whenCompleteAsync((list, t) ->
			method_37063(this.list = new ListWidget(list, 10, 30, 50, field_22790 - 70))
		);

		method_37063(class_4185.method_46430(class_5244.field_24339, buttonWidget -> remove()).method_46434(10 - sidebarWidth, field_22790 - 30, 50, 20).method_46431());
		method_37063(contextMenu = new ContextMenuContainer());
	}

	public void remove() {
		remove = true;

	}

	@Override
	public void method_25432() {
		if (chatWidget != null) {
			chatWidget.remove();
		}
	}

	@Override
	public boolean method_25421() {
		return parent != null && parent.method_25421();
	}

	private void animate() {
		if (sidebarAnimX < 0 && !remove) {
			if (sidebarAnimX > -ANIM_STEP) {
				sidebarAnimX = -ANIM_STEP;
			}
			sidebarAnimX += ANIM_STEP;
			if (list != null) {
				list.visible = false;
			}
			getButtons().forEach(button -> button.method_46421(button.method_46426() + ANIM_STEP));
		} else if (remove) {
			if (sidebarAnimX < -sidebarWidth) {
				close();
			}
			sidebarAnimX -= ANIM_STEP;
			if (list != null) {
				list.setX(list.getX() - ANIM_STEP);
			}
			getButtons().forEach(button -> button.method_46421(button.method_46426() - ANIM_STEP));
			if (chatWidget != null) {
				chatWidget.method_25333(chatWidget.method_25342() - ANIM_STEP);
			}
		} else {
			if (list != null && !list.visible) {
				list.visible = true;
			}
		}
	}

	public List<class_339> getButtons() {
		return method_25396().stream().filter(element -> element instanceof class_339).map(element -> (class_339) element).collect(Collectors.toList());
	}

	private void close() {
		//noinspection DataFlowIssue
		field_22787.method_1507(parent);
		if (chatWidget != null) {
			chatWidget.remove();
		}
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (contextMenu.getMenu() != null) {
			if (contextMenu.method_25402(mouseX, mouseY, button)) {
				return true;
			}
			contextMenu.removeMenu();
		}
		if (mouseX > sidebarWidth) {
			remove();
			return true;
		}
		return super.method_25402(mouseX, mouseY, button);
	}

	private void removeChat() {
		hasChat = false;
		method_37066(chatWidget);
		method_37066(input);
	}

	private void addChat(Channel channel) {
		if (hasChat) {
			removeChat();
		}
		hasChat = true;
		list.elements.forEach(b -> b.field_22763 = true);
		this.channel = channel;
		int w;
		if (channel.isDM()) {
			User chatUser = ((Channel.DM) channel).getReceiver();
			//noinspection DataFlowIssue
			w = Math.max(field_22787.field_1772.method_1727(chatUser.getStatus().getTitle() + ": " + chatUser.getStatus().getDescription()) + 5,
				field_22787.field_1772.method_1727(channel.getName()));
		} else {
			//noinspection DataFlowIssue
			w = field_22787.field_1772.method_1727(channel.getName());
		}
		sidebarWidth = Math.min(Math.max(field_22789 * 5 / 12, w + 5), field_22789 / 2);
		chatWidget = new ChatWidget(channel, 75, 50, sidebarWidth - 80, field_22790 - 100, this);
		method_37063(chatWidget);
		method_37063(input = new class_342(field_22793, 75, field_22790 - 30, sidebarWidth - 80, 20, class_2561.method_43471("api.friends.chat.input")) {
			@Override
			public boolean method_25404(int keyCode, int scanCode, int modifiers) {
				if (keyCode == class_3675.field_31957) {
					ChatHandler.getInstance().sendMessage(channel, input.method_1882());
					input.method_1852("");
					return true;
				}
				return super.method_25404(keyCode, scanCode, modifiers);
			}
		});
		input.method_1887(input.method_25369().getString());
		input.method_1863(s -> {
			if (s.isEmpty()) {
				input.method_1887(input.method_25369().getString());
			} else {
				input.method_1887("");
			}
		});
		input.method_1880(1024);
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return contextMenu;
	}

	@Override
	public class_437 getSelf() {
		return this;
	}

	@Override
	public class_437 getParent() {
		return parent;
	}

	private class ListWidget extends class_362 implements class_4068, class_364, class_6379 {
		private final List<class_339> elements;
		private final int y;
		private final int width;
		private final int height;
		private final int entryHeight = 25;
		protected boolean hovered;
		@Getter
		private int x;
		private int scrollAmount;
		private boolean visible;

		public ListWidget(List<Channel> list, int x, int y, int width, int height) {
			this.x = x;
			this.y = y;
			this.width = width;
			this.height = height;
			AtomicInteger buttonY = new AtomicInteger(y);
			elements = list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName()))
				.map(channel -> class_4185.method_46430(class_2561.method_30163(channel.getName()), buttonWidget -> {
						addChat(channel);
						buttonWidget.field_22763 = false;
					})
					.method_46434(x, buttonY.getAndAdd(entryHeight), width, entryHeight - 5).method_46431()).collect(Collectors.toList());
		}

		@Override
		public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
			if (visible) {
				graphics.method_51448().method_22903();
				graphics.method_44379(x, y, x + width, y + height);

				AtomicInteger buttonY = new AtomicInteger(y);
				elements.forEach(e -> {
					e.method_46419(buttonY.get() - scrollAmount);
					e.method_25394(graphics, mouseX, mouseY, delta);
					buttonY.getAndAdd(entryHeight);
				});

				graphics.method_44380();
				graphics.method_51448().method_22909();
			}
		}

		@Override
		public List<? extends class_364> method_25396() {
			return elements;
		}

		@Override
		public boolean method_25401(double mouseX, double mouseY, double amountY) {
			if (this.method_25405(mouseX, mouseY)) {
				if (elements.size() * entryHeight > height) {
					int a = scrollAmount;
					a -= (int) (amountY * (entryHeight / 2f));
					scrollAmount = class_3532.method_15340(a, 0, elements.size() * entryHeight - height);
					return true;
				}
			}
			return super.method_25401(mouseX, mouseY, amountY);
		}

		@Override
		public boolean method_25405(double mouseX, double mouseY) {
			return hovered = visible && mouseX >= (double) this.x && mouseY >= (double) this.y && mouseX < (double) (this.x + this.width) && mouseY < (double) (this.y + this.height);
		}

		public void setX(int x) {
			this.x = x;
			elements.forEach(e -> e.method_46421(x));
		}

		@Override
		public void method_37020(class_6382 builder) {

		}

		@Override
		public class_6380 method_37018() {
			return this.hovered ? class_6380.field_33785 : class_6380.field_33784;
		}
	}
}
