/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Persistence;
import io.github.axolotlclient.api.util.UUIDHelper;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_357;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8130;
import net.minecraft.client.gui.widget.*;

public class ChannelSettingsScreen extends class_437 {
	private final class_437 parent;
	private final Channel channel;

	protected ChannelSettingsScreen(class_437 parent, Channel channel) {
		super(class_2561.method_43471("api.channel.configure"));
		this.parent = parent;
		this.channel = channel;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
	}

	@Override
	protected void method_25426() {
		method_37063(new class_7842(field_22789 / 2 - field_22793.method_27525(field_22785) / 2, 36 / 2 - field_22793.field_2000 / 2, field_22793.method_27525(field_22785), field_22793.field_2000, field_22785, field_22793));

		int leftColX = field_22789 / 2 - 4 - 150;
		int leftColYStep = field_22793.field_2000 + 20 - field_22793.field_2000 + 8 - 5 + 5;
		int leftColY = 36 + 5 + 30;
		int rightColX = field_22789 / 2 + 4;
		int rightColYStep = 20 + 8;
		int rightColY = 36 + 30;

		var nameField = new class_342(field_22793, rightColX, rightColY, 150, 20, class_2561.method_43473());
		nameField.method_1852(channel.getRealName());
		method_37063(text("api.chat.groups.name", leftColX, leftColY));
		method_37063(nameField);
		rightColY += rightColYStep;
		leftColY += leftColYStep;

		AtomicReference<Supplier<Integer>> count = new AtomicReference<>();
		AtomicReference<Supplier<Long>> duration = new AtomicReference<>();

		AtomicReference<Consumer<Boolean>> countDisabler = new AtomicReference<>();
		AtomicReference<Consumer<Boolean>> durationDisabler = new AtomicReference<>();
		var persistence = class_5676.<Persistence.Type>method_32606(type -> class_2561.method_43471("api.chat.persistence." + type.getId()))
			.method_32624(Persistence.Type.values()).method_32616().method_32617(rightColX, rightColY, 150, 20, class_2561.method_43473(), (cyclingButtonWidget, object) -> {
				switch (object) {
					case COUNT_DURATION -> {
						countDisabler.get().accept(true);
						countDisabler.get().accept(true);
					}
					case DURATION -> {
						durationDisabler.get().accept(true);
						countDisabler.get().accept(false);
					}
					case COUNT -> {
						countDisabler.get().accept(true);
						durationDisabler.get().accept(false);
					}
					case CHANNEL -> {
						countDisabler.get().accept(false);
						durationDisabler.get().accept(false);
					}
				}
			});
		persistence.method_32605(channel.getPersistence().type());
		rightColY += rightColYStep;
		method_37063(text("api.chat.groups.persistence", leftColX, leftColY));
		leftColY += leftColYStep;
		method_37063(persistence);
		method_37063(text("api.chat.groups.persistence.count", "api.chat.groups.persistence.count.tooltip", leftColX, leftColY));
		leftColY += leftColYStep;
		countDisabler.set(sliderAssembly(rightColX, rightColY, val -> (int) (val * 100d), count::set, channel.getPersistence().count() / 100d));
		rightColY += rightColYStep;
		method_37063(text("api.chat.groups.persistence.duration", "api.chat.groups.persistence.duration.tooltip", leftColX, leftColY));
		leftColY += leftColYStep;
		durationDisabler.set(sliderAssembly(rightColX, rightColY, val -> (long) (val * 100d), duration::set, channel.getPersistence().duration() / 100d));
		rightColY += rightColYStep;
		countDisabler.get().accept(false);
		durationDisabler.get().accept(false);

		var namesInput = method_37063(new class_342(field_22793, rightColX, rightColY, 150, 20, class_2561.method_43473()));
		method_37063(text("api.chat.groups.add_participants", leftColX, leftColY));


		int footerY = field_22790 - 36 / 2 - 20 / 2;
		method_37063(class_4185.method_46430(class_5244.field_24335, widget -> field_22787.method_1507(parent)).method_46434(field_22789 / 2 - 150 - 4, footerY, 150, 20).method_46431());
		method_37063(class_4185.method_46430(class_5244.field_24334, widget -> {
			ChannelRequest.updateChannel(channel.getId(), nameField.method_1882(),
				Persistence.of(persistence.method_32603(), count.get().get(), duration.get().get()),
				Arrays.stream(namesInput.method_1882().split(",")).filter(s -> !s.isEmpty()).map(UUIDHelper::ensureUuid).toArray(String[]::new));
			field_22787.method_1507(parent);
		}).method_46434(field_22789 / 2 + 4, footerY, 150, 20).method_46431());
	}

	private <T> Consumer<Boolean> sliderAssembly(int x, int y, Function<Double, T> valueFunc, Consumer<Supplier<T>> value, double initialValue) {

		AtomicReference<T> currentVal = new AtomicReference<>();
		var slider = new class_357(x, y, 128, 20, class_2561.method_43473(), initialValue) {
			@Override
			protected void method_25346() {
				method_25355(class_2561.method_43470(String.valueOf(valueFunc.apply(field_22753))));
			}

			@Override
			protected void method_25344() {
				currentVal.set(valueFunc.apply(field_22753));
			}
		};
		slider.method_25346();
		slider.method_25344();
		value.accept(currentVal::get);
		var text = new class_342(field_22793, x, y, 128, 20, class_2561.method_43473());
		var textButton = new class_4185(x + 130, y, 20, 20, class_2561.method_43473(), w -> {
			if (slider.field_22764) {
				text.method_48229(slider.method_46426(), slider.method_46427());
				text.method_25358(slider.method_25368());
				text.method_1852(String.valueOf(currentVal.get()));
			} else {
				try {
					slider.method_25348(slider.method_46426() + (1d / slider.method_25368()) * Double.parseDouble(text.method_1882()), slider.method_46427());
				} catch (Exception ignored) {
				}
			}
			slider.field_22764 = !slider.field_22764;
			text.field_22764 = !slider.field_22764;
		}, s -> class_2561.method_43471("slider.text_input")) {
			@Override
			protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
				super.method_48579(graphics, mouseX, mouseY, delta);
				graphics.method_25293(new class_2960("axolotlclient", "textures/gui/sprites/cursor.png"),
					method_46426() + method_25368() / 2 - 4, method_46427() + method_25364() / 2 - 4,
					8, 8, 0, 0, 8, 8, 8, 8);

			}
		};
		text.field_22764 = false;
		method_37063(text);
		return val -> slider.field_22763 = textButton.field_22763 = text.field_22763 = val;
	}

	private class_339 text(String translationKey, int x, int y) {
		class_2561 text = class_2561.method_43471(translationKey);
		return new class_8130(x, y, 150, field_22793.field_2000, text, field_22793) {

			@Override
			protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
				method_49605(graphics, field_22793, method_25369(), method_46426(), method_46427(), method_46426() + method_25368(), method_46427() + method_25364(), method_48979());
			}
		};
	}

	private class_339 text(String translationKey, String tooltipKey, int x, int y) {
		class_2561 text = class_2561.method_43471(translationKey);
		class_8130 widget = new class_8130(x, y, field_22793.method_27525(text), field_22793.field_2000, text, field_22793) {

			@Override
			protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
				method_49605(graphics, field_22793, method_25369(), method_46426(), method_46427(), method_46426() + method_25368(), method_46427() + method_25364(), method_48979());
			}
		};
		widget.method_47400(class_7919.method_47407(class_2561.method_43471(tooltipKey)));
		return widget;
	}
}
