/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenuContainer;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3675;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class ChatScreen extends class_437 implements ContextMenuScreen {

	private final Channel channel;
	private final class_437 parent;
	private final ContextMenuContainer contextMenu = new ContextMenuContainer();
	private ChatWidget widget;
	private ChatUserListWidget users;
	private class_342 input;

	public ChatScreen(class_437 parent, Channel channel) {
		super(class_2561.method_43470(channel.getName()));
		this.channel = channel;
		this.parent = parent;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);

		graphics.method_25300(this.field_22793, channel.getName(), this.field_22789 / 2, 15, 16777215);
	}

	@Override
	protected void method_25426() {
		method_37060(contextMenu);

		var chatList = method_37063(new ChatListWidget(this, field_22789, field_22790, 0, 30, 55, field_22790 - 90));
		ChannelRequest.getChannelList().thenAccept(chatList::addChannels).thenRun(() -> chatList.setActiveChannel(channel));

		method_37063(widget = new ChatWidget(channel, 65, 30, field_22789 - 155, field_22790 - 90, this));

		users = new ChatUserListWidget(this, field_22787, 80, field_22790 - 20, 30, field_22790 - 60, 25);
		users.method_25333(field_22789 - 80);
		users.setUsers(channel.getAllUsers(), channel);
		method_37063(users);

		//noinspection DataFlowIssue
		method_37063(input = new class_342(field_22787.field_1772, field_22789 / 2 - 150, field_22790 - 50,
			300, 20, class_2561.method_43471("api.chat.enterMessage")) {

			@Override
			public boolean method_25404(int keyCode, int scanCode, int modifiers) {
				if (keyCode == class_3675.field_31957 && !method_1882().isEmpty()) {
					ChatHandler.getInstance().sendMessage(channel, method_1882());
					method_1852("");
					return true;
				}
				return super.method_25404(keyCode, scanCode, modifiers);
			}
		});

		input.method_1887(class_2561.method_43469(channel.isDM() ? "api.chat.messageUser" : "api.chat.messageGroup", channel.getName()).getString());
		input.method_1863(s -> {
			if (s.isEmpty()) {
				input.method_1887(class_2561.method_43469(channel.isDM() ? "api.chat.messageUser" : "api.chat.messageGroup", channel.getName()).getString());
			} else {
				input.method_1887("");
			}
		});
		input.method_1880(1024);

		if (channel.getOwner().equals(API.getInstance().getSelf())) {
			method_37063(class_4185.method_46430(class_2561.method_43471("api.channel.configure"), b -> field_22787.method_1507(new ChannelSettingsScreen(this, channel)))
				.method_46434(field_22789 - 60, 5, 50, 20).method_46431());
		}

		this.method_37063(class_4185.method_46430(class_5244.field_24339, button -> this.field_22787.method_1507(this.parent))
			.method_46434(this.field_22789 / 2 - 75, this.field_22790 - 28, 150, 20)
			.method_46431()
		);
	}

	@Override
	public void method_25432() {
		if (widget != null) {
			widget.remove();
		}
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		if (contextMenu.getMenu() != null) {
			if (contextMenu.method_25402(mouseX, mouseY, button)) {
				return true;
			}
			contextMenu.removeMenu();
		}
		return super.method_25402(mouseX, mouseY, button);
	}

	@Override
	public ContextMenuContainer getMenuContainer() {
		return contextMenu;
	}

	@Override
	public class_437 getParent() {
		return parent;
	}

	@Override
	public class_437 getSelf() {
		return this;
	}
}
