/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.api.multiplayer;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_642;
import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.util.UUIDHelper;

public class ServerInfoUtil {
	public static Status.Activity.ServerInfo getServerInfo(String levelName, class_2926 status) {
		if (status == null) {
			return new Status.Activity.ServerInfo(levelName, null, null, null, null);
		}
		return new Status.Activity.ServerInfo(levelName, status.comp_1273().getString(),
			new Status.Activity.ServerInfo.Favicon(status.comp_1276().map(class_2926.class_8145::comp_1278).orElse(null)),
			status.comp_1274().map(p ->
				new Status.Activity.ServerInfo.Players(p.comp_1279(), p.comp_1280(),
					p.comp_1281().stream().map(prof -> new Status.Activity.ServerInfo.Players.Player(prof.getName(), UUIDHelper.toUndashed(prof.getId()))).toList())
			).orElse(null),
			status.comp_1275().map(v -> new Status.Activity.ServerInfo.Version(v.comp_1282(), v.comp_1283())).orElse(null));
	}

	public static class_2926 getServerStatus(Status.Activity.ServerInfo info) {
		return new class_2926(class_2561.method_30163(info.levelName()),
			Optional.ofNullable(info.players()).map(p -> new class_2926.class_2927(p.max(),
				p.online(),
				p.sample().stream().map(prof -> new GameProfile(UUIDHelper.fromUndashed(prof.uuid()), prof.name())).toList())),
			Optional.ofNullable(info.version()).map(v -> new class_2926.class_2930(v.name(), v.protocol())),
			Optional.ofNullable(info.icon()).map(f -> new class_2926.class_8145(f.iconBytes())),
			false);
	}

	public static class_642 getServerData(String username, Status.Activity.E4mcMetadata metadata) {
		class_2926 serverMetadata = metadata.serverInfo() != null ? getServerStatus(metadata.serverInfo()) : null;
		var data = new class_642(username, metadata.domain(), false);
		if (serverMetadata != null) {
			serverMetadata.comp_1276().ifPresent(icon -> data.method_49305(icon.comp_1278()));
			data.field_3757 = class_2561.method_43470(metadata.serverInfo().levelName());
			serverMetadata.comp_1275().ifPresentOrElse(ver -> {
				data.field_3760 = class_2561.method_43470(ver.comp_1282());
				data.field_3756 = ver.comp_1283();
			}, () -> {
				data.field_3760 = class_2561.method_43471("multiplayer.status.old");
				data.field_3756 = 0;
			});
			serverMetadata.comp_1274().ifPresentOrElse(player -> {
				data.field_3753 = class_2561.method_43470(Integer.toString(player.comp_1280())).method_10852(class_2561.method_43470("/").method_27692(class_124.field_1063)).method_27693(Integer.toString(player.comp_1279())).method_27692(class_124.field_1080);
				data.field_41861 = player;
				if (!player.comp_1281().isEmpty()) {
					List<class_2561> list = new ArrayList<>(player.comp_1281().size());

					for (GameProfile gameProfile : player.comp_1281()) {
						list.add(class_2561.method_43470(gameProfile.getName()));
					}

					if (player.comp_1281().size() < player.comp_1280()) {
						list.add(class_2561.method_43469("multiplayer.status.and_more", player.comp_1280() - player.comp_1281().size()));
					}

					data.field_3762 = list;
				} else {
					data.field_3762 = List.of();
				}
			}, () -> data.field_3757 = class_2561.method_43471("multiplayer.status.unknown").method_27692(class_124.field_1063));
		}
		return data;
	}
}
