/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin;

import java.io.IOException;
import java.util.List;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2535;
import net.minecraft.class_2539;
import net.minecraft.class_2561;
import net.minecraft.class_2889;
import net.minecraft.class_2921;
import net.minecraft.class_2923;
import net.minecraft.class_2924;
import net.minecraft.class_2935;
import net.minecraft.class_2937;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_6368;
import net.minecraft.class_6370;
import net.minecraft.class_639;
import net.minecraft.class_642;
import com.google.common.hash.Hashing;
import io.github.axolotlclient.bridge.PlatformDispatch;
import io.github.axolotlclient.bridge.impl.AxoSpriteImpl;
import io.github.axolotlclient.bridge.render.AxoSprite;
import io.github.axolotlclient.mixin.MinecraftServerAccessor;
import io.github.axolotlclient.modules.hypixel.autoboop.FilterListConfigurationScreen;
import io.github.axolotlclient.util.ThreadExecuter;
import org.apache.commons.lang3.mutable.MutableInt;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value = PlatformDispatch.class, remap = false)
public abstract class PlatformDispatchMixin {
	@Unique
	private static void getRealTimeServerPing(class_642 server, MutableInt currentServerPing) {
		ThreadExecuter.scheduleTask(() -> {
			try {
				var address = class_639.method_2950(server.field_3761);
				var optional = class_6370.field_33745.method_36907(address).map(class_6368::method_36902);

				if (optional.isPresent()) {
					final class_2535 clientConnection = class_2535.method_10753(optional.get(), false);
					class_2921 listener = new class_2921() {

						private long currentSystemTime = 0L;

						@Override
						public void method_12667(class_2924 packet) {
							this.currentSystemTime = net.minecraft.class_156.method_658();
							clientConnection.method_10743(new class_2935(this.currentSystemTime));
						}

						@Override
						public void method_12666(class_2923 packet) {
							var time = this.currentSystemTime;
							var latency = net.minecraft.class_156.method_658();
							currentServerPing.setValue((int) (latency - time));
							clientConnection.method_10747(class_2561.method_43471("multiplayer.status.finished"));
						}

						@Override
						public void method_10839(class_2561 reason) {
						}

						@Override
						public boolean method_48106() {
							return clientConnection.method_10758();
						}
					};
					clientConnection.method_10763(listener);
					clientConnection.method_10743(new class_2889(address.method_2952(), address.method_2954(),
						class_2539.field_20592));
					clientConnection.method_10743(new class_2937());
				}
			} catch (Exception ignored) {
			}
		});
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge.
	 */
	@Overwrite
	public static void pingHud$updatePing(MutableInt currentServerPing) {
		final var minecraft = class_310.method_1551();
		if (minecraft.method_1558() != null) {
			getRealTimeServerPing(minecraft.method_1558(), currentServerPing);
		} else if (minecraft.method_1496()) {
			currentServerPing.setValue(1);
		}
	}

	/**
	 * @author Flowey
	 * @reason Implement bridge.
	 */
	@SuppressWarnings("deprecation")
	@Overwrite
	public static AxoSprite.Dynamic ipHud$getServerIcon() throws IOException {
		final var minecraft = class_310.method_1551();
		final var serverEntry = minecraft.method_1558();
		final class_1011 img;
		if (serverEntry == null) {
			var icon = minecraft.method_1576().method_3765().comp_1276();
			if (icon.isEmpty()) {
				return null;
			} else {
				img = class_1011.method_49277(icon.get().comp_1278());
			}
		} else {
			img = class_1011.method_49277(serverEntry.method_49306());
		}
		final var icon = new class_1043(img);
		final var iconId = new class_2960("axolotlclient",
			serverEntry == null ? "worlds/" + Hashing.sha1().hashUnencodedChars(((MinecraftServerAccessor) minecraft.method_1576()).getStorageSource().method_27005()) + "/icon" :
				"servers/" + Hashing.sha1().hashUnencodedChars(minecraft.method_1558().field_3761) + "/icon"
		);

		icon.method_4524();
		minecraft.method_1531().method_4616(iconId, icon);

		class Impl implements AxoSprite.Dynamic, AxoSpriteImpl {
			@Override
			public void draw(class_310 client, class_332 stack, int sX, int sY, int sW, int sH) {
				client.method_1531().method_22813(iconId);
				stack.method_25290(iconId, sX, sY, 0, 0, sW, sH, sW, sH);
			}

			@Override
			public void close() {
				minecraft.execute(() -> {
					minecraft.method_1531().method_4615(iconId);
					icon.close();
				});
			}
		}

		return new Impl();
	}

	/**
	 * @author moehreag
	 * @reason Implement bridge.
	 */
	@Overwrite
	public static void autoBoop$openFiltersScreen(List<String> filters) {
		class_310.method_1551().method_1507(new FilterListConfigurationScreen(filters, class_310.method_1551().field_1755));
	}
}
