/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.entity;

import com.mojang.authlib.GameProfile;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.item.AxoItem;
import io.github.axolotlclient.bridge.item.AxoPlayerInventory;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1657.class)
public abstract class PlayerEntityMixin implements AxoPlayer {
	@Final
	@Shadow
	private class_1661 inventory;

	@Shadow
	public abstract class_1799 getArrowType(class_1799 stack);

	@Shadow
	@Final
	private GameProfile gameProfile;

	@Override
	public AxoPlayerInventory br$getInventory() {
		return this.inventory;
	}

	@Override
	public @Nullable AxoItem br$getProjectileItem() {
		return getArrowType(class_1802.field_8102.method_7854()).method_7909();
	}

	@Override
	public String br$getName() {
		return gameProfile.getName();
	}
}
