/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.bridge.mixin.world;

import java.util.Collections;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import io.github.axolotlclient.bridge.entity.AxoPlayer;
import io.github.axolotlclient.bridge.math.Vec3;
import io.github.axolotlclient.bridge.world.AxoWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(class_1937.class)
public abstract class WorldMixin implements AxoWorld, class_1936 {
	@Shadow
	public abstract long getTimeOfDay();

	@Override
	public long br$getTimeOfDay() {
		return getTimeOfDay();
	}

	@Override
	public List<? extends AxoPlayer> br$getPlayers() {
		return Collections.unmodifiableList(method_18456());
	}

	@Override
	public String br$getBiomeName(Vec3 pos) {
		var biome = method_23753(new class_2338(class_3532.method_15357(pos.x()), class_3532.method_15357(pos.y()), class_3532.method_15357(pos.z()))).method_40229().left().orElse(null);
		if (biome == null) {
			return class_1074.method_4662("coordshud.unknown_biome");
		}
		String path = biome.method_29177().method_12832();
		if (!biome.method_29177().method_12836().equals("minecraft")) {
			String namespace = biome.method_29177().method_12836();
			path += " (" + Character.toTitleCase(namespace.charAt(0)) + namespace.substring(1) + ")";
		}
		final String str = path.replace("_", " ");
		if (str.isEmpty()) {
			return str;
		}

		final int[] codepoints = str.codePoints().toArray();
		boolean capitalizeNext = true;
		for (int i = 0; i < codepoints.length; i++) {
			final int ch = codepoints[i];
			if (Character.isWhitespace(ch)) {
				capitalizeNext = true;
			} else if (capitalizeNext) {
				codepoints[i] = Character.toTitleCase(ch);
				capitalizeNext = false;
			}
		}
		return new String(codepoints, 0, codepoints.length);
	}
}
