/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.modules.sky.SkyboxManager;
import net.minecraft.class_4184;
import net.minecraft.class_5636;
import net.minecraft.class_758;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_758.class)
public abstract class BackgroundRendererMixin {

	@Inject(method = "applyFog", at = @At("TAIL"))
	private static void axolotlclient$applyNoFog(class_4184 camera, class_758.class_4596 fogType, float viewDistance,
												 boolean thickFog, float tickDelta, CallbackInfo ci) {
		if (camera.method_19334() == class_5636.field_27888
			&& (thickFog || fogType == class_758.class_4596.field_20946)) {
			if (SkyboxManager.getInstance().hasSkyBoxes()) {
				RenderSystem.setShaderFogStart(Short.MAX_VALUE - 1);
				RenderSystem.setShaderFogEnd(Short.MAX_VALUE);
			}
		}
	}
}
