/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import io.github.axolotlclient.AxolotlClientConfigCommon;
import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ChatsSidebar;
import io.github.axolotlclient.api.FriendsScreen;
import io.github.axolotlclient.modules.hud.HudEditScreen;
import io.github.axolotlclient.modules.hypixel.HypixelAbstractionLayer;
import io.github.axolotlclient.modules.hypixel.HypixelMods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_433.class)
public abstract class GameMenuScreenMixin extends class_437 {

	protected GameMenuScreenMixin(class_2561 title) {
		super(title);
	}

	@Inject(method = "initWidgets", at = @At("TAIL"))
	private void axolotlclient$addSidebarButton(CallbackInfo ci) {
		if (API.getInstance().isSocketConnected()) {
			method_37063(class_4185.method_46430(class_2561.method_43471("api.chats"),
					button -> field_22787.method_1507(new ChatsSidebar(this)))
				.method_46434(10, field_22790 - 55, 75, 20).method_46431());
			method_37063(class_4185.method_46430(class_2561.method_43471("api.friends"),
					button -> field_22787.method_1507(new FriendsScreen(this)))
				.method_46434(10, field_22790 - 30, 75, 20).method_46431());
		}
	}

	@Redirect(method = "initWidgets", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/screen/GameMenuScreen;createLinkConfirmationButton(Lnet/minecraft/text/Text;Ljava/lang/String;)Lnet/minecraft/client/gui/widget/ButtonWidget;", ordinal = 1))
	private class_4185 axolotlclient$addClientOptionsButton(class_433 instance, class_2561 text, String string) {
		if (!AxolotlClientConfigCommon.instance().gameMenuScreenOptionButtonMode.get().showButton()) {
			return createLinkConfirmationButton(text, string);
		}

		return createButton(class_2561.method_43471("title_short"), () -> new HudEditScreen(this));
	}

	@Shadow
	protected abstract class_4185 createLinkConfirmationButton(class_2561 par1, String par2);

	@Shadow
	protected abstract class_4185 createButton(class_2561 par1, Supplier<class_437> par2);

	@ModifyArg(method = "initWidgets", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/gui/widget/ButtonWidget;builder(Lnet/minecraft/text/Text;Lnet/minecraft/client/gui/widget/ButtonWidget$PressAction;)Lnet/minecraft/client/gui/widget/ButtonWidget$Builder;", ordinal = 1), index = 1)
	private class_4185.class_4241 axolotlclient$clearFeatureRestrictions(class_4185.class_4241 onPress) {
		return (buttonWidget) -> {
			if (Objects.equals(HypixelMods.getInstance().cacheMode.get(),
				HypixelMods.HypixelApiCacheMode.ON_CLIENT_DISCONNECT)) {
				HypixelAbstractionLayer.getInstance().clearPlayerData();
			}
			onPress.onPress(buttonWidget);
		};
	}
}
