/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import io.github.axolotlclient.bridge.key.AxoKeybinding;
import io.github.axolotlclient.util.events.Events;
import io.github.axolotlclient.util.events.impl.KeyBindChangeEvent;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_304.class)
public abstract class KeyBindMixin {

	@Inject(method = "setBoundKey", at = @At("RETURN"))
	public void axolotlclient$boundKeySet(class_3675.class_306 key, CallbackInfo ci) {
		Events.KEYBIND_CHANGE.invoker().invoke(new KeyBindChangeEvent(key));
	}

	@Inject(method = "setPressed", at = @At("RETURN"))
	public void axolotlclient$onPress(boolean pressed, CallbackInfo ci) {
		if (pressed) {
			io.github.axolotlclient.bridge.events.Events.KEY_INPUT.invoker().accept(((AxoKeybinding) this).br$getBoundKey());
		}
	}
}
