/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.mixin;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3298;
import net.minecraft.class_3304;
import net.minecraft.class_3902;
import net.minecraft.class_4011;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.hud.PackDisplayHud;
import io.github.axolotlclient.modules.hypixel.HypixelAbstractionLayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3304.class)
public abstract class ReloadableResourceManagerMixin {

	@Inject(method = "reload", at = @At("TAIL"))
	private void axolotlclient$reload(Executor prepareExecutor, Executor applyExecutor, CompletableFuture<class_3902> initialStage,
									  List<class_3262> resourcePacks, CallbackInfoReturnable<class_4011> cir) {
		HypixelAbstractionLayer.getInstance().clearPlayerData();

		PackDisplayHud hud = (PackDisplayHud) HudManager.getInstance().get(PackDisplayHud.ID);
		if (hud != null) {
			hud.update();
		}
	}

	@Inject(method = "getResource", at = @At("HEAD"), cancellable = true)
	private void axolotlclient$getResource(class_2960 id, CallbackInfoReturnable<Optional<class_3298>> cir) {
		if (AxolotlClient.runtimeResources.get(id) != null) {
			cir.setReturnValue(Optional.of(AxolotlClient.runtimeResources.get(id)));
		}
	}
}
