/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.api.API;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class AuthWidget extends class_4185 {

	public AuthWidget(int x, int y) {
		super(x, y,
			class_310.method_1551().field_1772.method_1727(Auth.getInstance().getCurrent().getName()) + 28,
			20, class_2561.method_30163("    " + Auth.getInstance().getCurrent().getName()), buttonWidget -> MinecraftClient.getInstance().setScreen(new AccountsScreen(MinecraftClient.getInstance().currentScreen)), field_40754);
	}

	@Override
	public void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
		super.method_48579(graphics, mouseX, mouseY, delta);
		class_2960 texture = Auth.getInstance().getSkinTexture(Auth.getInstance().getCurrent());
		RenderSystem.enableBlend();
		graphics.method_25293(texture, method_46426() + 1, method_46427() + 1, method_25364() - 2, method_25364() - 2, 8, 8, 8, 8, 64, 64);
		graphics.method_25293(texture, method_46426() + 1, method_46427() + 1, method_25364() - 2, method_25364() - 2, 40, 8, 8, 8, 64, 64);
		RenderSystem.disableBlend();
		if (API.getInstance().getApiOptions().enabled.get()) {
			graphics.method_51448().method_22903();
			graphics.method_51448().method_46416(method_46426() + method_25364() - 1, method_46427() + method_25364() - 1, 0);
			graphics.method_51448().method_22905(0.25f, 0.25f, 1);
			graphics.method_51448().method_46416(-8, -8, 0);
			int color = API.getInstance().getIndicatorColor();
			graphics.method_25294(0, 4, 16, 12, color);
			graphics.method_25294(4, 0, 12, 16, color);
			graphics.method_25294(2, 2, 14, 14, color);
			graphics.method_51448().method_22909();
		}
	}
}
