/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth;

import java.net.URI;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5481;
import io.github.axolotlclient.util.OSUtil;
import io.github.axolotlclient.util.Util;

public class DeviceCodeDisplayScreen extends class_437 {
	private final class_437 parent;
	private final String verificationUri, userCode;
	private final List<class_5481> message;
	private int ticksLeft;
	private class_2561 status;
	private boolean working;
	private final class_2960 qrCode;
	private final DeviceFlowData data;

	public DeviceCodeDisplayScreen(class_437 parent, DeviceFlowData data) {
		super(class_2561.method_43471("auth.add"));
		this.parent = parent;
		this.message = class_310.method_1551().field_1772.method_1728(class_2561.method_30163(data.getMessage()), 400);
		this.verificationUri = data.getVerificationUri();
		this.userCode = data.getUserCode();
		this.ticksLeft = data.getExpiresIn() * 20;
		this.qrCode = Util.getTexture(data.getQrCode(), "device_auth_" + data.getUserCode());
		this.status = class_2561.method_43469("auth.time_left",
			((ticksLeft / 20) / 60) + "m" + ((ticksLeft / 20) % 60) + "s");
		data.setStatusConsumer(s -> {
			if (s.equals("auth.finished")) {
				class_310.method_1551().execute(() -> class_310.method_1551().method_1507(parent));
			}
			working = true;
			method_37067();
			status = class_2561.method_43471(s);
		});
		this.data = data;
	}

	@Override
	public void method_25432() {
		data.cancel();
	}

	@Override
	protected void method_25426() {
		method_37063(class_4185.method_46430(class_2561.method_43471("auth.copy_and_open"),
			buttonWidget -> {
				field_22787.field_1774.method_1455(userCode);
				OSUtil.getOS().open(URI.create(verificationUri));
			}).method_46434(field_22789 / 2 - 100, field_22790 / 2, 200, 20).method_46431());
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);

		graphics.method_27534(field_22787.field_1772, field_22785, field_22789 / 2, 25, -1);

		int y = field_22790 / 4;
		for (class_5481 orderedText : message) {
			graphics.method_35719(field_22787.field_1772, orderedText, field_22789 / 2, y, -1);
			y += 10;
		}
		graphics.method_27534(field_22787.field_1772, working ? status : class_2561.method_43469("auth.time_left",
				((ticksLeft / 20) / 60) + "m" + ((ticksLeft / 20) % 60) + "s"),
			field_22789 / 2, y + 10, -1);

		y = field_22790 / 2 + 30;
		if (field_22790 - y > 40) {
			int qrImageSize = field_22790 - y - 20;
			graphics.method_25290(qrCode, field_22789 / 2 - qrImageSize / 2, y, 0, 0, qrImageSize, qrImageSize, qrImageSize, qrImageSize);
		}
	}

	@Override
	public void method_25393() {
		ticksLeft--;
	}
}
