/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.auth.skin;

import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4608;
import net.minecraft.class_5602;
import net.minecraft.class_591;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;

public class SkinRenderer {
	private static class_591<?> classicModel, slimModel;
	private static final class_310 minecraft = class_310.method_1551();

	private SkinRenderer() {
	}

	public static void render(class_332 graphics, boolean classicVariant,
							  class_2960 skinTexture,
							  @Nullable class_2960 cape,
							  float rotationX,
							  float rotationY,
							  float pivotY,
							  int x0,
							  int y0,
							  int x1,
							  int y1,
							  float scale) {
		if (classicModel == null && classicVariant) {
			classicModel = new class_591<>(minecraft.method_31974().method_32072(class_5602.field_27577), false);
			classicModel.field_3448 = false;
		}
		if (slimModel == null && !classicVariant) {
			slimModel = new class_591<>(minecraft.method_31974().method_32072(class_5602.field_27581), true);
			slimModel.field_3448 = false;
		}

		int width = x1 - x0;
		class_308.method_34742();
		graphics.method_51448().method_22903();
		graphics.method_51448().method_46416(x0 + width / 2.0F, (float) (y1), 100.0F);
		graphics.method_51448().method_22905(scale, scale, scale);
		graphics.method_51448().method_46416(0.0F, -0.0625F, 0.0F);
		graphics.method_51448().method_49278(class_7833.field_40714.rotationDegrees(rotationX), 0.0F, pivotY, 0.0F);
		graphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(rotationY));
		graphics.method_51452();
		graphics.method_51448().method_22903();
		graphics.method_51448().method_22905(1.0F, 1.0F, -1.0F);
		graphics.method_51448().method_46416(0.0F, -1.5F, 0.0F);
		var model = classicVariant ? classicModel : slimModel;
		class_1921 renderLayer = class_1921.method_23573(skinTexture);
		model.method_2828(graphics.method_51448(), graphics.method_51450().getBuffer(renderLayer), class_765.field_32767, class_4608.field_21444, 1, 1, 1, 1);
		if (cape != null) {
			graphics.method_51448().method_46416(0.0F, 0.0F, 0.125F);
			graphics.method_51448().method_22907(class_7833.field_40714.rotationDegrees(6.0F));
			graphics.method_51448().method_22907(class_7833.field_40716.rotationDegrees(180.0F));
			model.method_2823(graphics.method_51448(), graphics.method_51450().getBuffer(class_1921.method_23573(cape)), class_765.field_32767, class_4608.field_21444);
		}
		graphics.method_51448().method_22909();
		graphics.method_51452();
		graphics.method_51448().method_22909();
		class_308.method_24211();
	}
}
