/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.blur;

import java.io.IOException;

import com.google.gson.JsonSyntaxException;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.FloatOption;
import io.github.axolotlclient.mixin.ShaderEffectAccessor;
import io.github.axolotlclient.modules.AbstractModule;
import lombok.Getter;
import net.minecraft.class_279;
import net.minecraft.class_284;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.apache.commons.io.IOUtils;

public class MotionBlur extends AbstractModule {

	@Getter
	private static final MotionBlur Instance = new MotionBlur();
	public final BooleanOption enabled = new BooleanOption("enabled", false);
	public final FloatOption strength = new FloatOption("strength", 50F, 1F, 99F);
	public final BooleanOption inGuis = new BooleanOption("inGuis", false);
	public final OptionCategory category = OptionCategory.create("motionBlur");
	private final class_2960 shaderLocation = new class_2960("minecraft:shaders/post/motion_blur.json");
	private final class_310 client = class_310.method_1551();
	public class_279 shader;
	private float currentBlur;

	private int lastWidth;
	private int lastHeight;

	private static float getBlur() {
		return MotionBlur.getInstance().strength.get() / 100F;
	}

	@Override
	public void init() {
		category.add(enabled, strength, inGuis);

		AxolotlClient.config().rendering.add(category);
		AxolotlClient.runtimeResources.put(shaderLocation, new MotionBlurShader());
	}

	public void onUpdate() {
		if ((shader == null || class_310.method_1551().method_1522().field_1482 != lastWidth
			|| class_310.method_1551().method_1522().field_1481 != lastHeight)
			&& class_310.method_1551().method_1522().field_1482 > 0
			&& class_310.method_1551().method_1522().field_1481 > 0) {
			currentBlur = getBlur();
			try {
				shader = new class_279(client.method_1531(), client.method_1478(),
					client.method_1522(), shaderLocation);
				shader.method_1259(class_310.method_1551().method_1522().field_1482,
					class_310.method_1551().method_1522().field_1481);
			} catch (JsonSyntaxException | IOException e) {
				AxolotlClient.LOGGER.error("Could not load motion blur: ", e);
			}
		}
		if (currentBlur != getBlur() && shader != null) {
			((ShaderEffectAccessor) shader).axolotlclient$getPasses().forEach(shader -> {
				class_284 blendFactor = shader.method_1295().method_1271("BlendFactor");
				if (blendFactor != null) {
					blendFactor.method_1251(getBlur());
				}
			});
			currentBlur = getBlur();
		}

		lastWidth = class_310.method_1551().method_1522().field_1482;
		lastHeight = class_310.method_1551().method_1522().field_1481;
	}

	private static class MotionBlurShader extends class_3298 {

		public MotionBlurShader() {
			super(class_310.method_1551().method_45573(), () -> IOUtils.toInputStream(String.format(
					"{\"targets\": [\"swap\",\"previous\"],\"passes\": [{            \"name\": \"motion_blur\",            \"intarget\": \"minecraft:main\","
						+ "            \"outtarget\": \"swap\"," + "            \"auxtargets\": [" + "                {"
						+ "                    \"name\": \"PrevSampler\"," + "                    \"id\": \"previous\""
						+ "                }" + "            ]," + "            \"uniforms\": [" + "                {"
						+ "                    \"name\": \"BlendFactor\"," + "                    \"values\": [ %s ]"
						+ "                }" + "            ]" + "        }," + "        {"
						+ "            \"name\": \"blit\"," + "            \"intarget\": \"swap\","
						+ "            \"outtarget\": \"previous\"        }," + "        {"
						+ "            \"name\": \"blit\"," + "            \"intarget\": \"swap\","
						+ "            \"outtarget\": \"minecraft:main\"" + "        }" + "    ]" + "}", getBlur()),
				"utf-8"));
		}
	}
}
