/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.freelook;

import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.class_1297;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_5498;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.StringArrayOption;
import io.github.axolotlclient.modules.AbstractCommonModule;
import io.github.axolotlclient.util.FeatureDisabler;
import io.github.axolotlclient.util.keybinds.KeyBinds;
import io.github.axolotlclient.util.options.ForceableBooleanOption;

public class Freelook extends AbstractCommonModule {

	private static final Freelook INSTANCE = new Freelook();
	private static final class_304 KEY = KeyBinds.getInstance().register(new class_304("key.freelook", class_3675.field_31911, "category.axolotlclient"));
	private static final class_304 KEY_ALT = KeyBinds.getInstance().register(new class_304("key.freelook.alt", class_3675.field_16237.method_1444(), "category.axolotlclient"));
	public final ForceableBooleanOption enabled = new ForceableBooleanOption("enabled", false);
	private final class_310 client = class_310.method_1551();
	private final OptionCategory category = OptionCategory.create("freelook");
	private final StringArrayOption mode = new StringArrayOption("mode",
		new String[]{"snap_perspective", "freelook"},
		"freelook", value -> FeatureDisabler.update());
	private final BooleanOption invert = new BooleanOption("invert", false);
	private final EnumOption<class_5498> perspective = new EnumOption<>("perspective", class_5498.class,
		class_5498.field_26665);
	private final BooleanOption toggle = new BooleanOption("toggle", "freelook.toggle.tooltip", false);
	private final EnumOption<class_5498> perspectiveAlt = new EnumOption<>("perspective.alt", class_5498.class,
		class_5498.field_26666);
	private final BooleanOption toggleAlt = new BooleanOption("toggle.alt", false);
	private final WrappedValue active = new WrappedValue(), activeAlt = new WrappedValue();
	private float yaw, pitch;
	private final Deque<class_5498> previousPerspectives = new ArrayDeque<>();

	public static Freelook getInstance() {
		return INSTANCE;
	}

	@Override
	public void init() {
		category.add(enabled, mode, perspective, invert, toggle);
		category.add(perspectiveAlt, toggleAlt);
		AxolotlClient.config().addCategory(category);
	}

	@Override
	public void tick() {
		if (!enabled.get() || client.field_1755 != null) return;
		tickSet(toggle, KEY, perspective, active);
		tickSet(toggleAlt, KEY_ALT, perspectiveAlt, activeAlt);
	}

	private void tickSet(BooleanOption toggle, class_304 key, EnumOption<class_5498> perspective, WrappedValue active) {
		if (toggle.get()) {
			if (key.method_1436()) {
				if (active.val) {
					stop(active);
				} else {
					start(perspective.get(), active);
				}
			}
		} else {
			if (key.method_1434()) {
				if (!active.val) {
					start(perspective.get(), active);
				}
			} else if (active.val) {
				stop(active);
			}
		}
	}

	private void stop(WrappedValue active) {
		active.val = false;
		client.field_1769.method_3292();
		setPerspective(previousPerspectives.pop());
	}

	private void start(class_5498 perspective, WrappedValue active) {
		previousPerspectives.push(client.field_1690.method_31044());
		active.val = true;
		setPerspective(perspective);

		class_1297 camera = client.method_1560();

		if (camera == null)
			camera = client.field_1724;
		if (camera == null)
			return;

		yaw = camera.method_36454();
		pitch = camera.method_36455();
	}

	private void setPerspective(class_5498 perspective) {
		client.field_1690.method_31043(perspective);
	}

	public boolean consumeRotation(double dx, double dy) {
		if (!(active.val || activeAlt.val) || !enabled.get() || !mode.get().equals("freelook"))
			return false;

		if (!invert.get())
			dy = -dy;

		if (class_310.method_1551().field_1690.method_31044().method_31035()
			|| class_310.method_1551().field_1690.method_31044().method_31034())
			dy *= -1;

		yaw += (float) (dx * 0.15F);
		pitch += (float) (dy * 0.15F);

		if (pitch > 90) {
			pitch = 90;
		} else if (pitch < -90) {
			pitch = -90;
		}

		client.field_1769.method_3292();
		return true;
	}

	public float yaw(float defaultValue) {
		if (!(active.val || activeAlt.val) || !enabled.get() || !mode.get().equals("freelook"))
			return defaultValue;

		return yaw;
	}

	public float pitch(float defaultValue) {
		if (!(active.val || activeAlt.val) || !enabled.get() || !mode.get().equals("freelook"))
			return defaultValue;

		return pitch;
	}

	public boolean needsDisabling() {
		return mode.get().equals("freelook");
	}

	public boolean isActive() {
		return active.val || activeAlt.val;
	}

	private static class WrappedValue {
		boolean val;
	}
}
