/*
 * Copyright © 2024 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4061;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;

public class HotbarHUD extends TextHudEntry {

	public static final class_2960 ID = new class_2960("axolotlclient", "hotbarhud");
	private static final class_2960 WIDGETS_TEXTURE = new class_2960("textures/gui/widgets.png");
	public static final class_2960 ICONS_TEXTURE = new class_2960("textures/gui/icons.png");

	private final class_310 client = (class_310) super.client;

	public HotbarHUD() {
		super(182, 22, false);
		supportsScaling = false;
	}

	@Override
	public void renderComponent(AxoRenderContext graphics, float delta) {
		graphics.br$pushMatrix();
		class_1657 playerEntity = class_310.method_1551().field_1719 instanceof class_1657
			? (class_1657) class_310.method_1551().field_1719
			: null;
		if (playerEntity != null) {
			class_1799 itemStack = playerEntity.method_6079();
			class_1306 arm = playerEntity.method_6068().method_5928();
			DrawPosition pos = getPos();
			int i = pos.x() + getWidth() / 2;
			graphics.br$pushMatrix();
			graphics.br$translateMatrix(0.0F, 0.0F, -90.0F);
			((class_332) graphics).method_25302(WIDGETS_TEXTURE, i - 91, pos.y(), 0, 0, 182, 22);
			((class_332) graphics).method_25302(WIDGETS_TEXTURE, i - 91 - 1 + playerEntity.method_31548().field_7545 * 20, pos.y() - 1, 0, 22, 24, 22);
			if (!itemStack.method_7960()) {
				if (arm == class_1306.field_6182) {
					((class_332) graphics).method_25302(WIDGETS_TEXTURE, i - 91 - 29, pos.y() - 1, 24, 22, 29, 24);
				} else {
					((class_332) graphics).method_25302(WIDGETS_TEXTURE, i + 91, pos.y() - 1, 53, 22, 29, 24);
				}
			}

			graphics.br$popMatrix();
			int l = 1;

			for (int m = 0; m < 9; ++m) {
				int n = i - 90 + m * 20 + 2;
				int o = pos.y() + 6 - 3;
				this.renderHotbarItem(graphics, n, o, delta, playerEntity, playerEntity.method_31548().field_7547.get(m), l++);
			}

			if (!itemStack.method_7960()) {
				int m = pos.y() + 6 - 3;
				if (arm == class_1306.field_6182) {
					this.renderHotbarItem(graphics, i - 91 - 26, m, delta, playerEntity, itemStack, l++);
				} else {
					this.renderHotbarItem(graphics, i + 91 + 10, m, delta, playerEntity, itemStack, l++);
				}
			}

			RenderSystem.enableBlend();
			if (this.client.field_1690.method_42565().method_41753() == class_4061.field_18153) {
				float f = this.client.field_1724.method_7261(0.0F);
				if (f < 1.0F) {
					int n = pos.y() + 2;
					int o = i + 91 + 6;
					if (arm == class_1306.field_6183) {
						o = i - 91 - 22;
					}

					int p = (int) (f * 19.0F);
					((class_332) graphics).method_25302(ICONS_TEXTURE, o, n, 0, 94, 18, 18);
					((class_332) graphics).method_25302(ICONS_TEXTURE, o, n + 18 - p, 18, 112 - p, 18, p);
				}
			}

			RenderSystem.disableBlend();
		}
		graphics.br$popMatrix();
	}

	private void renderHotbarItem(AxoRenderContext graphics, int x, int y, float tickDelta, class_1657 player, class_1799 stack, int seed) {
		if (!stack.method_7960()) {
			float f = (float) stack.method_7965() - tickDelta;
			if (f > 0.0F) {
				float g = 1.0F + f / 5.0F;
				graphics.br$pushMatrix();
				graphics.br$translateMatrix((float) (x + 8), (float) (y + 12), 0.0F);
				graphics.br$scaleMatrix(1.0F / g, (g + 1.0F) / 2.0F, 1.0F);
				graphics.br$translateMatrix((float) (-(x + 8)), (float) (-(y + 12)), 0.0F);
			}

			((class_332) graphics).method_51423(player, stack, x, y, seed);
			if (f > 0.0F) {
				graphics.br$popMatrix();
			}

			((class_332) graphics).method_51431(this.client.field_1772, stack, x, y);
		}
	}

	@Override
	public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
		DrawPosition pos = getPos();

		DrawUtil.drawCenteredString((class_332) graphics, class_310.method_1551().field_1772, getName(), pos.x() + width / 2,
			pos.y() + height / 2 - 4, -1, true);
	}

	@Override
	public class_2960 getId() {
		return ID;
	}

	@Override
	public boolean overridesF3() {
		return true;
	}

	@Override
	public List<Option<?>> getConfigurationOptions() {
		List<Option<?>> list = new ArrayList<>();
		list.add(enabled);
		list.add(hide);
		return list;
	}
}
