/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.IntegerWidget;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;
import io.github.axolotlclient.modules.hud.gui.layout.Justification;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5676;
import net.minecraft.class_6382;
import net.minecraft.class_7842;
import net.minecraft.client.gui.widget.*;

public class ConfigureKeyBindScreen extends class_437 {

	private final class_437 parent;
	private final KeystrokeHud hud;
	public final KeystrokeHud.Keystroke stroke;
	private final IntegerOption width;
	private final IntegerOption height;
	private final boolean isAddScreen;

	public ConfigureKeyBindScreen(class_437 parent, KeystrokeHud hud, KeystrokeHud.Keystroke stroke, boolean isAddScreen) {
		super(class_2561.method_43471("keystrokes.stroke.configure_stroke"));
		this.parent = parent;
		this.hud = hud;
		this.stroke = stroke;

		width = new IntegerOption("", stroke.getBounds().width(), v -> stroke.getBounds().width(v), 7, 100);
		height = new IntegerOption("", stroke.getBounds().height(), v -> stroke.getBounds().height(v), 7, 100);
		this.isAddScreen = isAddScreen;
	}

	@Override
	protected void method_25426() {

		int leftColX = super.field_22789 / 2 - 4 - 150;
		int leftColY = 36 + 5;
		int rightColX = super.field_22789 / 2 + 4;
		int rightColY = 36;

		method_37063(new class_339(super.field_22789 / 2 - 100, rightColY, 200, 40, class_2561.method_43473()) {
			@Override
			protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
				var rect = stroke.getRenderPosition();
				guiGraphics.method_51448().method_22903();
				guiGraphics.method_51448().method_46416(method_46426(), method_46427(), 0);
				float scale = Math.min((float) method_25364() / rect.height(), (float) method_25368() / rect.width());
				guiGraphics.method_51448().method_46416(method_25368() / 2f - (rect.width() * scale) / 2f, 0, 0);
				guiGraphics.method_51448().method_22905(scale, scale, 1);
				guiGraphics.method_51448().method_46416(-rect.x(), -rect.y(), 0);
				DrawUtil.fillRect(guiGraphics, rect, Colors.WHITE.withAlpha(128));
				stroke.render(guiGraphics);
				guiGraphics.method_51448().method_22909();
			}

			@Override
			protected void method_47399(class_6382 narrationElementOutput) {

			}
		}).field_22763 = false;
		leftColY += 48;
		rightColY += 48;

		class_7842 currentKey = method_37060(new class_7842(0, rightColY, super.field_22789, 9, class_2561.method_43473(), field_22793));
		if (stroke.getKey() != null) {
			currentKey.method_25355(class_2561.method_43469("keystrokes.stroke.key", stroke.getKey().getKeyName(), class_2561.method_43471(stroke.getKey().getTranslationKey())));
		} else {
			currentKey.method_25355(class_2561.method_43473());
		}
		leftColY += 9 + 8;
		rightColY += 9 + 8;

		if (stroke.isLabelEditable()) {
			method_37063(new class_7842(leftColX, leftColY, 150, 20, class_2561.method_43471("keystrokes.stroke.label"), field_22793));
			leftColY += 28;
			boolean supportsSynchronization = stroke instanceof KeystrokeHud.LabelKeystroke;

			var label = method_37063(new class_342(field_22793, rightColX, rightColY, supportsSynchronization ? 30 : 150, 20, class_2561.method_43473()));

			label.method_1852(stroke.getLabel());
			label.method_1863(stroke::setLabel);
			if (supportsSynchronization) {
				var s = (KeystrokeHud.LabelKeystroke) stroke;
				class_4185 synchronizeButton = method_37063(class_4185.method_46430(class_2561.method_43469("keystrokes.stroke.label.synchronize_with_key", s.isSynchronizeLabel() ? class_5244.field_24332 : class_5244.field_24333), b -> {
					s.setSynchronizeLabel(!s.isSynchronizeLabel());
					b.setMessage(Text.translatable("keystrokes.stroke.label.synchronize_with_key", s.isSynchronizeLabel() ? CommonTexts.ON : CommonTexts.OFF));
					label.setEditable(!s.isSynchronizeLabel());
					if (s.isSynchronizeLabel()) {
						label.setText(stroke.getLabel());
					}
				}).positionAndSize(rightColX + 30 + 4, rightColY, 58, 20).build());
				synchronizeButton.field_22763 = s.getKey() != null;
				label.method_1888(!s.isSynchronizeLabel());
				method_37063(class_5676.<Justification>method_32606(j -> class_2561.method_43471(j.toString())).method_32624(Justification.values())
					.method_32619(s.getJustification()).build(rightColX + 30 + 4 + 58 + 4, rightColY, 58, 20,
						class_2561.method_43471("justification"), (btn, val) -> s.setJustification(val)));
			}
			rightColY += 28;
		}
		method_37063(new class_7842(leftColX, leftColY, 150, 20, class_2561.method_43471("keystrokes.stroke.width"), field_22793));
		leftColY += 28;
		method_37063(new IntegerWidget(rightColX, rightColY, 150, 20, width));
		rightColY += 28;
		method_37063(new class_7842(leftColX, leftColY, 150, 20, class_2561.method_43471("keystrokes.stroke.height"), field_22793));
		leftColY += 28;
		method_37063(new IntegerWidget(rightColX, rightColY, 150, 20, height));

		rightColY += 28;

		method_37063(class_4185.method_46430(class_2561.method_43471("keystrokes.stroke.configure_key"), b -> {
			field_22787.method_1507(new KeyBindSelectionScreen(this, stroke));
		}).method_46434(super.field_22789 / 2 - 150 - 4, rightColY, 150, 20).method_46431());
		method_37063(class_4185.method_46430(class_2561.method_43471("keystrokes.stroke.configure_position"), b -> {
			field_22787.method_1507(new KeystrokePositioningScreen(this, hud, stroke));
		}).method_46434(super.field_22789 / 2 + 4, rightColY, 150, 20).method_46431());


		if (isAddScreen) {
			class_4185 addButton = method_37063(class_4185.method_46430(class_2561.method_43471("keystrokes.stroke.add"), b -> {
				hud.keystrokes.add(stroke);
				method_25419();
			}).method_46434(super.field_22789 / 2 - 150 - 4, super.field_22790 - 33 / 2 - 10, 150, 20).method_46431());
			addButton.field_22763 = stroke.getKey() != null;
		}
		method_37063(class_4185.method_46430(isAddScreen ? class_5244.field_24335 : class_5244.field_24339, b -> method_25419())
			.method_46434(isAddScreen ? super.field_22789 / 2 + 4 : super.field_22789 / 2 - 75, super.field_22790 - 33 / 2 - 10, 150, 20).method_46431());
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
		graphics.method_27534(field_22793, method_25440(), super.field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	public void method_25419() {
		field_22787.method_1507(parent);
		hud.saveKeystrokes();
	}
}
