/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hud.gui.keystrokes;

import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import io.github.axolotlclient.modules.hud.gui.hud.KeystrokeHud;

public class KeystrokesScreen extends class_437 {

	private final List<KeystrokeHud.Keystroke> keys;
	public final KeystrokeHud hud;
	private final class_437 screen;

	public KeystrokesScreen(KeystrokeHud hud, class_437 screen) {
		super(class_2561.method_43471("keystrokes.keys"));
		if (hud.keystrokes == null) {
			hud.setKeystrokes();
		}
		this.keys = hud.keystrokes;
		this.hud = hud;
		this.screen = screen;
	}

	@Override
	public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
		method_25420(graphics);
		super.method_25394(graphics, mouseX, mouseY, delta);
		graphics.method_27534(field_22793, method_25440(), field_22789 / 2, 33 / 2 - field_22793.field_2000 / 2, -1);
	}

	@Override
	protected void method_25426() {
		var keyBindsList = method_37063(new KeyBindsList(this));
		method_37063(class_4185.method_46430(class_2561.method_43471("controls.resetAll"), button -> {
			keys.clear();
			hud.setDefaultKeystrokes();
			keyBindsList.reload();
			hud.saveKeystrokes();
		}).method_46434(field_22789 / 2 - 150 - 4, field_22790 - 33 / 2 - 10, 150, 20).method_46431());
		method_37063(class_4185.method_46430(class_5244.field_24334, button -> this.method_25419())
			.method_46434(field_22789 / 2 + 4, field_22790 - 33 / 2 - 10, 150, 20).method_46431());

	}

	@Override
	public void method_25419() {
		this.field_22787.method_1507(this.screen);
		hud.saveKeystrokes();
	}

	public void removeKey(KeystrokeHud.Keystroke key) {
		keys.remove(key);
	}
}
