/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.hypixel.autoboop;

import java.util.List;

import com.google.common.collect.ImmutableList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import org.jetbrains.annotations.Nullable;

@Environment(EnvType.CLIENT)
public class FiltersList extends class_4265<FiltersList.Entry> {
	final FilterListConfigurationScreen screen;

	public FiltersList(FilterListConfigurationScreen screen) {
		super(class_310.method_1551(), screen.field_22789, screen.field_22790, 33, screen.field_22790 - 33, 24);
		this.screen = screen;

		reload();
	}

	public void reload() {
		method_25339();
		for (String entry : screen.filters) {
			this.method_25321(new FilterEntry(entry));
		}

		method_25321(new SpacerEntry());
		method_25321(new NewEntry());
	}

	@Override
	public int method_25322() {
		return 340;
	}

	public void apply() {
		screen.filters.clear();
		screen.filters.addAll(method_25396().stream().filter(e -> e instanceof FilterEntry)
			.map(e -> (FilterEntry) e)
			.map(e -> e.editBox.method_1882())
			.filter(s -> !s.isBlank()).toList());
	}

	@Override
	public boolean method_25402(double mouseX, double mouseY, int button) {
		method_25396().stream().filter(e -> e instanceof FilterEntry)
			.map(e -> (FilterEntry) e).map(e -> e.editBox).forEach(e -> e.method_25365(false));
		return super.method_25402(mouseX, mouseY, button);
	}

	@Environment(EnvType.CLIENT)
	public abstract static class Entry extends class_4265.class_4266<Entry> {

	}

	public static class SpacerEntry extends Entry {

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {

		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of();
		}

		@Override
		public @Nullable class_8016 method_48205(class_8023 event) {
			return null;
		}
	}

	@Environment(EnvType.CLIENT)
	public class FilterEntry extends Entry {
		private static final class_2561 REMOVE_BUTTON_TITLE = class_2561.method_43471("autoboop.filters.remove");
		private final class_342 editBox;
		private final class_4185 removeButton;

		FilterEntry(String filter) {
			this.editBox = new class_342(field_22740.field_1772, 0, 0, 200, 20, class_2561.method_43471("autoboop.filters.edit"));
			editBox.method_1852(filter);
			editBox.method_1880(16);
			this.removeButton = class_4185.method_46430(REMOVE_BUTTON_TITLE, b -> {
					method_25330(this);
					apply();
					method_25307(method_25341());
				}).method_46434(0, 0, 50, 20)
				.method_46431();
		}

		@Override
		public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = method_25329() - removeButton.method_25368() - 10;
			int j = top - 2;
			this.removeButton.method_48229(i, j);
			this.removeButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);

			this.editBox.method_48229(left, j);
			this.editBox.method_25358(i - left - 4);
			this.editBox.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return ImmutableList.of(this.editBox, removeButton);
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return ImmutableList.of(this.editBox, removeButton);
		}
	}

	public class NewEntry extends Entry {

		private final class_4185 addButton;

		public NewEntry() {
			this.addButton = class_4185.method_46430(class_2561.method_43471("autoboop.filters.add"), button -> {
					int i = FiltersList.this.method_25396().indexOf(this);
					FiltersList.this.method_25396().add(Math.max(i - 1, 0), new FilterEntry(""));
					apply();
					method_25307(method_25331());
				}).method_46434(0, 0, 150, 20)
				.method_46431();
		}

		@Override
		public List<? extends class_6379> method_37025() {
			return List.of(addButton);
		}

		@Override
		public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
			int i = method_25329() - width / 2 - 10 - addButton.method_25368() / 2;
			int j = top - 2;
			this.addButton.method_48229(i, j);
			this.addButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
		}

		@Override
		public List<? extends class_364> method_25396() {
			return List.of(addButton);
		}
	}
}
