/*
 * Copyright © 2023 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.modules.sky;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.util.Util;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import org.joml.Matrix4f;

public class MCPSkyboxInstance extends SkyboxInstance {

	public MCPSkyboxInstance(JsonObject json) {
		super(json);
		this.textures[0] = new class_2960(json.get("source").getAsString());
		try {
			this.fade[0] = convertToTicks(json.get("startFadeIn").getAsInt());
			this.fade[1] = convertToTicks(json.get("endFadeIn").getAsInt());
			this.fade[3] = convertToTicks(json.get("endFadeOut").getAsInt());
		} catch (Exception e) {
			this.alwaysOn = true;
		}
		try {
			this.fade[2] = convertToTicks(json.get("startFadeOut").getAsInt());
		} catch (Exception ignored) {
			this.fade[2] = Util.getTicksBetween(Util.getTicksBetween(fade[0], fade[1]), fade[3]);
		}
		try {
			this.rotate = json.get("rotate").getAsBoolean();
			if (rotate) {
				this.rotationSpeed = json.get("speed").getAsFloat();
			}
		} catch (Exception e) {
			this.rotate = false;
		}
		try {
			String[] axis = json.get("axis").getAsString().split(" ");
			for (int i = 0; i < axis.length; i++) {
				this.rotationAxis[i] = Float.parseFloat(axis[i]);
			}
		} catch (Exception ignored) {
		}

		try {
			this.blendMode = parseBlend(json.get("blend").getAsString());
		} catch (Exception ignored) {
		}
		showMoon = true;
		showSun = true;
	}

	protected int convertToTicks(int hourFormat) {
		hourFormat *= 10;
		hourFormat -= 6000;
		if (hourFormat < 0) {
			hourFormat += 24000;
		}
		if (hourFormat >= 24000) {
			hourFormat -= 24000;
		}
		return hourFormat;
	}

	@Override
	public void renderSkybox(class_4587 matrices) {
		this.alpha = getAlpha();

		RenderSystem.setShaderColor(1, 1, 1, 1);

		class_289 tessellator = class_289.method_1348();
		class_287 bufferBuilder = tessellator.method_1349();
		RenderSystem.setShaderTexture(0, textures[0]);

		for (int i = 0; i < 6; ++i) {
			if (textures[0] != null) {
				matrices.method_22903();

				float u;
				float v;

				if (i == 0) {
					u = 0;
					v = 0;
				} else if (i == 1) {
					matrices.method_22907(class_7833.field_40714.rotationDegrees(90));
					u = 1 / 3F;
					v = 0.5F;
				} else if (i == 2) {
					matrices.method_22907(class_7833.field_40714.rotationDegrees(-90));
					matrices.method_22907(class_7833.field_40716.rotationDegrees(180));
					u = 2 / 3F;
					v = 0F;
				} else if (i == 3) {
					matrices.method_22907(class_7833.field_40714.rotationDegrees(180));
					u = 1 / 3F;
					v = 0F;
				} else if (i == 4) {
					matrices.method_22907(class_7833.field_40718.rotationDegrees(90));
					matrices.method_22907(class_7833.field_40716.rotationDegrees(-90));
					u = 2 / 3F;
					v = 0.5F;
				} else {
					matrices.method_22907(class_7833.field_40718.rotationDegrees(-90));
					matrices.method_22907(class_7833.field_40716.rotationDegrees(90));
					v = 0.5F;
					u = 0;
				}

				Matrix4f matrix4f = matrices.method_23760().method_23761();
				bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
				bufferBuilder.method_22918(matrix4f, -100, -100, -100).method_22913(u, v).method_22915(1F, 1F, 1F, alpha).method_1344();
				bufferBuilder.method_22918(matrix4f, -100, -100, 100).method_22913(u, v + 0.5F).method_22915(1F, 1F, 1F, alpha).method_1344();
				bufferBuilder.method_22918(matrix4f, 100, -100, 100).method_22913(u + 1 / 3F, v + 0.5F).method_22915(1F, 1F, 1F, alpha).method_1344();
				bufferBuilder.method_22918(matrix4f, 100, -100, -100).method_22913(u + 1 / 3F, v).method_22915(1F, 1F, 1F, alpha).method_1344();
				tessellator.method_1350();

				matrices.method_22909();
			}
		}
	}
}
