/*
 * Copyright © 2025 moehreag <moehreag@gmail.com> & Contributors
 *
 * This file is part of AxolotlClient.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * For more information, see the LICENSE file.
 */

package io.github.axolotlclient.util.options.vanilla;

import java.util.Base64;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Graphics;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.screen.GraphicsEditorScreen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.GraphicsWidget;
import io.github.axolotlclient.util.notifications.Notifications;

public class AxoGraphicsWidget extends GraphicsWidget {
	private final GraphicsOption option;

	public AxoGraphicsWidget(int x, int y, int width, int height, GraphicsOption option) {
		super(x, y, width, height, option);
		this.option = option;
	}

	@Override
	public void method_25306() {
		class_310.method_1551().method_1507(new AxoGraphicsEditorScreen(class_310.method_1551().field_1755, this.option));
	}

	public static class AxoGraphicsEditorScreen extends GraphicsEditorScreen {
		private final Graphics graphics;

		public AxoGraphicsEditorScreen(class_437 parent, GraphicsOption option) {
			super(parent, option);
			this.graphics = option.get();
		}

		@Override
		public void method_25426() {
			super.method_25426();

			int buttonX = gridX + maxGridWidth + 10;
			int buttonY = gridY + 60;
			var back = (class_4185) method_25396().get(method_25396().size() - 1);
			method_37066(back);
			method_37063(class_4185.method_46430(class_2561.method_43471("graphics.copy_text"),
					btn -> field_22787.field_1774.method_1455(Base64.getEncoder().encodeToString(graphics.getPixelData())))
				.method_46433(buttonX, buttonY + 25).method_46432(100).method_46431());
			method_37063(class_4185.method_46430(class_2561.method_43471("graphics.paste_text"),
					btn -> {
						try {
							graphics.setPixelData(Base64.getDecoder().decode(field_22787.field_1774.method_1460()));
						} catch (IllegalArgumentException e) {
							Notifications.getInstance().addStatus("graphics.paste_text.failed", "graphics.paste_text.failed.desc");
						}
					})
				.method_46433(buttonX, buttonY + 50).method_46432(100).method_46431());
			method_37063(back);
		}
	}
}
