/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.multiplayer;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.logging.LogUtils;
import io.github.axolotlclient.api.multiplayer.FriendsMultiplayerScreen;
import io.github.axolotlclient.api.multiplayer.ServerInfoUtil;
import io.github.axolotlclient.api.types.PkSystem;
import io.github.axolotlclient.api.types.Status;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.modules.auth.Auth;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_124;
import net.minecraft.class_140;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_642;
import net.minecraft.class_7413;
import net.minecraft.class_7532;
import net.minecraft.class_8573;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class FriendsMultiplayerSelectionList
extends class_4280<Entry> {
    static final class_2960 SERVER_SELECTION_TEXTURE = new class_2960("textures/gui/server_selection.png");
    static final class_2960 ICONS = new class_2960("textures/gui/icons.png");
    static final Logger LOGGER = LogUtils.getLogger();
    static final ThreadPoolExecutor THREAD_POOL = new ScheduledThreadPoolExecutor(5, new ThreadFactoryBuilder().setNameFormat("Friends Server Pinger #%d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new class_140(LOGGER)).build());
    static final class_2561 CANT_RESOLVE_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_resolve").method_27694(style -> style.method_36139(-65536));
    static final class_2561 CANT_CONNECT_TEXT = class_2561.method_43471((String)"multiplayer.status.cannot_connect").method_27694(style -> style.method_36139(-65536));
    static final class_2561 INCOMPATIBLE_STATUS = class_2561.method_43471((String)"multiplayer.status.incompatible");
    static final class_2561 NO_CONNECTION_STATUS = class_2561.method_43471((String)"multiplayer.status.no_connection");
    static final class_2561 PINGING_STATUS = class_2561.method_43471((String)"multiplayer.status.pinging");
    static final class_2561 ONLINE_STATUS = class_2561.method_43471((String)"multiplayer.status.online");
    static final class_2561 NOT_PUBLISHED_STATUS = class_2561.method_43471((String)"api.worldhost.joinability.not_published").method_27692(class_124.field_1061);
    private final FriendsMultiplayerScreen screen;
    private final List<Entry> friendEntries = new ArrayList<Entry>();
    private final LoadingHeader loadingHeader = new LoadingHeader();
    private static final int STATUS_ICON_HEIGHT = 8;
    private static final int STATUS_ICON_WIDTH = 10;

    public FriendsMultiplayerSelectionList(FriendsMultiplayerScreen screen, class_310 minecraft, int width, int height, int y, int itemHeight) {
        super(minecraft, screen.field_22789, screen.field_22790, y, y + height, itemHeight);
        this.screen = screen;
        this.method_25321((class_350.class_351)this.loadingHeader);
    }

    private void refreshEntries() {
        this.method_25339();
        this.friendEntries.forEach(x$0 -> this.method_25321((class_350.class_351)x$0));
    }

    public void setSelected(@Nullable Entry entry) {
        super.method_25313((class_350.class_351)entry);
        this.screen.onSelectedChange();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        Entry entry = (Entry)this.method_25334();
        return entry != null && entry.method_25404(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public void updateList(List<User> friends) {
        this.friendEntries.clear();
        for (User friend : friends) {
            if (!friend.getStatus().isOnline()) continue;
            this.friendEntries.add(this.createEntry(friend));
        }
        this.refreshEntries();
    }

    private Entry createEntry(User friend) {
        if (friend.getStatus().getActivity() != null && friend.getStatus().getActivity().hasMetadata()) {
            if (friend.getStatus().getActivity().hasMetadata("external_server")) {
                return this.externalServerEntry(this.screen, friend);
            }
            return this.e4mcServerFriendEntry(this.screen, friend);
        }
        return new StatusFriendEntry(this.screen, friend);
    }

    public void updateEntry(User user) {
        this.friendEntries.stream().filter(e1 -> {
            if (e1 instanceof StatusFriendEntry) {
                StatusFriendEntry statusFriendEntry = (StatusFriendEntry)e1;
                return statusFriendEntry.getUser().equals((Object)user);
            }
            if (e1 instanceof ServerEntry) {
                ServerEntry serverEntry = (ServerEntry)e1;
                return serverEntry.getUser().equals((Object)user);
            }
            return false;
        }).findFirst().ifPresent(e -> {
            this.friendEntries.set(this.friendEntries.indexOf(e), this.createEntry(user));
            this.refreshEntries();
        });
    }

    public int method_25322() {
        return 305;
    }

    private ExternalServerFriendEntry externalServerEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity.ExternalServerMetadata metadata = (Status.Activity.ExternalServerMetadata)friend.getStatus().getActivity().metadata().attributes();
        return new ExternalServerFriendEntry(screen, metadata, new class_642(metadata.serverName(), metadata.address(), false), friend);
    }

    private E4mcServerFriendEntry e4mcServerFriendEntry(FriendsMultiplayerScreen screen, User friend) {
        Status.Activity activity = friend.getStatus().getActivity();
        Status.Activity.E4mcMetadata metadata = activity.hasMetadata("world_host") ? ((Status.Activity.WorldHostMetadata)activity.metadata().attributes()).asE4mcMetadata() : (Status.Activity.E4mcMetadata)activity.metadata().attributes();
        return new E4mcServerFriendEntry(screen, metadata, ServerInfoUtil.getServerData(friend.getName(), metadata), friend);
    }

    @Environment(value=EnvType.CLIENT)
    public static class LoadingHeader
    extends Entry {
        private final class_310 minecraft = class_310.method_1551();

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int i = top + height / 2 - 4;
            String string = class_7413.method_43449((long)class_156.method_658());
            guiGraphics.method_25303(this.minecraft.field_1772, string, this.minecraft.field_1755.field_22789 / 2 - this.minecraft.field_1772.method_1727(string) / 2, i, -8355712);
        }

        @NotNull
        public class_2561 method_37006() {
            return class_2561.method_43473();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static abstract class Entry
    extends class_4280.class_4281<Entry>
    implements AutoCloseable {
        @Override
        public void close() {
        }

        public boolean canJoin() {
            return false;
        }

        public class_642 getServerData() {
            return null;
        }
    }

    public class ExternalServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.ExternalServerMetadata statusDescription;

        private ExternalServerFriendEntry(FriendsMultiplayerScreen screen, Status.Activity.ExternalServerMetadata statusDescription, class_642 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        public boolean canJoin() {
            return this.statusDescription.address() != null;
        }
    }

    public class E4mcServerFriendEntry
    extends ServerEntry {
        private final Status.Activity.E4mcMetadata statusDescription;

        protected E4mcServerFriendEntry(FriendsMultiplayerScreen screen, Status.Activity.E4mcMetadata statusDescription, class_642 serverData, User friend) {
            super(screen, serverData, friend);
            this.statusDescription = statusDescription;
            this.refreshStatus();
        }

        @Override
        protected boolean isPublished() {
            return this.statusDescription.domain() != null;
        }

        @Override
        protected void refreshStatus() {
            super.refreshStatus();
            this.serverData.serverInfo.field_3757 = class_2561.method_30163((String)this.statusDescription.serverInfo().levelName());
        }
    }

    public class StatusFriendEntry
    extends Entry {
        private final User user;

        protected StatusFriendEntry(FriendsMultiplayerScreen screen, User friend) {
            this.user = friend;
        }

        public class_2561 method_37006() {
            return class_2561.method_43470((String)this.user.getName());
        }

        public void method_25343(class_332 graphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            if (this.user.isSystem()) {
                class_5250 fronters = class_2561.method_43470((String)this.user.getSystem().getFronters().stream().map(PkSystem.Member::getDisplayName).collect(Collectors.joining("/")));
                class_5250 tag = class_2561.method_43470((String)("(" + this.user.getSystem().getName() + "/" + this.user.getName() + ")")).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(true)).method_10977(class_124.field_1080));
                graphics.method_51439(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, (class_2561)fronters.method_10852((class_2561)tag), left + 3, top + 1, -1, false);
            } else {
                graphics.method_51433(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getName(), left + 3 + 32, top + 1, -1, false);
            }
            if (this.user.getStatus().isOnline() && this.user.getStatus().getActivity() != null) {
                graphics.method_51433(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getStatus().getTitle(), left + 3 + 32, top + 12, 0x808080, false);
                graphics.method_51433(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getStatus().getDescription(), left + 3 + 40, top + 23, 0x808080, false);
            } else if (this.user.getStatus().getLastOnline() != null) {
                graphics.method_51433(((FriendsMultiplayerSelectionList)FriendsMultiplayerSelectionList.this).field_22740.field_1772, this.user.getStatus().getLastOnline(), left + 3 + 32, top + 12, 0x808080, false);
            }
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user);
            class_7532.method_44445((class_332)graphics, (class_2960)texture, (int)(left - 1), (int)(top - 1), (int)32, (boolean)true, (boolean)false);
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    protected class ServerEntry
    extends Entry {
        private static final int ICON_WIDTH = 32;
        private static final int ICON_HEIGHT = 32;
        private static final int SPACING = 5;
        private static final int STATUS_ICON_WIDTH = 10;
        private static final int STATUS_ICON_HEIGHT = 8;
        private final FriendsMultiplayerScreen screen;
        private final class_310 minecraft;
        protected final ServerInfoEx serverData;
        private final class_8573 icon;
        private byte @Nullable [] lastIconBytes;
        private long lastClickTime;
        @Nullable
        private List<class_2561> onlinePlayersTooltip;
        private Sprite statusIcon;
        @Nullable
        private class_2561 statusIconTooltip;
        protected final User user;

        protected ServerEntry(FriendsMultiplayerScreen screen, class_642 serverData, User user) {
            this.screen = screen;
            this.minecraft = class_310.method_1551();
            this.serverData = new ServerInfoEx(serverData);
            this.icon = class_8573.method_52202((class_1060)this.minecraft.method_1531(), (String)(serverData.field_3761 != null ? serverData.field_3761 : user.getUuid() + "_" + serverData.field_3752));
            this.user = user;
        }

        @Override
        public class_642 getServerData() {
            return this.serverData.serverInfo();
        }

        protected void refreshStatus() {
            this.onlinePlayersTooltip = null;
            if (!this.isPublished()) {
                this.serverData.setPingResult(PingResult.UNREACHABLE);
            }
            switch (this.serverData.pingResult().ordinal()) {
                case 0: 
                case 1: {
                    this.statusIcon = Sprite.PING_1_SPRITE;
                    this.statusIconTooltip = PINGING_STATUS;
                    break;
                }
                case 3: {
                    this.statusIcon = Sprite.INCOMPATIBLE_SPRITE;
                    this.onlinePlayersTooltip = this.serverData.serverInfo.field_3762;
                    this.statusIconTooltip = INCOMPATIBLE_STATUS;
                    break;
                }
                case 2: {
                    this.statusIcon = Sprite.UNREACHABLE_SPRITE;
                    if (!this.isPublished()) break;
                    this.statusIconTooltip = NO_CONNECTION_STATUS;
                    break;
                }
                case 4: {
                    this.statusIcon = this.serverData.serverInfo.field_3758 < 150L ? Sprite.PING_5_SPRITE : (this.serverData.serverInfo.field_3758 < 300L ? Sprite.PING_4_SPRITE : (this.serverData.serverInfo.field_3758 < 600L ? Sprite.PING_3_SPRITE : (this.serverData.serverInfo.field_3758 < 1000L ? Sprite.PING_2_SPRITE : Sprite.PING_1_SPRITE)));
                    this.statusIconTooltip = class_2561.method_43469((String)"multiplayer.status.ping", (Object[])new Object[]{this.serverData.serverInfo.field_3758});
                    this.onlinePlayersTooltip = this.serverData.serverInfo.field_3762;
                }
            }
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            byte[] bs;
            int i;
            if (this.serverData.pingResult() == PingResult.INITIAL) {
                this.serverData.setPingResult(PingResult.PINGING);
                this.serverData.serverInfo.field_3757 = class_5244.field_39003;
                this.serverData.serverInfo.field_3753 = class_5244.field_39003;
                THREAD_POOL.submit(() -> {
                    try {
                        this.screen.getPinger().method_3003(this.serverData.serverInfo, () -> {});
                    }
                    catch (UnknownHostException var2) {
                        this.serverData.setPingResult(PingResult.UNREACHABLE);
                        this.serverData.serverInfo.field_3757 = CANT_RESOLVE_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                    catch (Exception var3) {
                        this.serverData.setPingResult(PingResult.UNREACHABLE);
                        this.serverData.serverInfo.field_3757 = CANT_CONNECT_TEXT;
                        this.minecraft.execute(this::refreshStatus);
                    }
                });
            }
            if (this.serverData.pingResult == PingResult.PINGING && this.serverData.serverInfo.field_3758 != -2L) {
                this.serverData.setPingResult(this.serverData.serverInfo.field_3756 == class_155.method_16673().method_48020() ? PingResult.SUCCESSFUL : PingResult.INCOMPATIBLE);
            }
            this.refreshStatus();
            guiGraphics.method_25303(this.minecraft.field_1772, this.serverData.serverInfo.field_3752, left + 32 + 3, top + 1, -1);
            List list = this.minecraft.field_1772.method_1728((class_5348)this.serverData.serverInfo.field_3757, width - 32 - 2);
            for (int i2 = 0; i2 < Math.min(list.size(), 2); ++i2) {
                guiGraphics.method_35720(this.minecraft.field_1772, (class_5481)list.get(i2), left + 32 + 3, top + 12 + 9 * i2, -8355712);
            }
            guiGraphics.method_25290(this.icon.method_52201(), left, top, 0.0f, 0.0f, 32, 32, 32, 32);
            class_2960 texture = Auth.getInstance().getSkinTexture(this.user);
            class_7532.method_44445((class_332)guiGraphics, (class_2960)texture, (int)(left + 32 - 10), (int)(top + 32 - 10), (int)10, (boolean)true, (boolean)false);
            if (this.serverData.pingResult() == PingResult.PINGING) {
                i = (int)(class_156.method_658() / 100L + (long)(index * 2) & 7L);
                if (i > 4) {
                    i = 8 - i;
                }
                this.statusIcon = switch (i) {
                    case 1 -> Sprite.PINGING_2_SPRITE;
                    case 2 -> Sprite.PINGING_3_SPRITE;
                    case 3 -> Sprite.PINGING_4_SPRITE;
                    case 4 -> Sprite.PINGING_5_SPRITE;
                    default -> Sprite.PINGING_1_SPRITE;
                };
            }
            i = left + width - 10 - 5;
            if (this.statusIcon != null) {
                this.statusIcon.draw(guiGraphics, i, top);
            }
            if (!Arrays.equals(bs = this.serverData.serverInfo.method_49306(), this.lastIconBytes)) {
                if (this.uploadIcon(bs)) {
                    this.lastIconBytes = bs;
                } else {
                    this.serverData.serverInfo.method_49305(null);
                }
            }
            Object component = !this.isPublished() ? NOT_PUBLISHED_STATUS : (this.serverData.pingResult() == PingResult.INCOMPATIBLE ? this.serverData.serverInfo.field_3760.method_27661().method_27692(class_124.field_1061) : this.serverData.serverInfo.field_3753);
            int j = this.minecraft.field_1772.method_27525((class_5348)component);
            int k = i - j - 5;
            guiGraphics.method_27535(this.minecraft.field_1772, component, k, top + 1, -8355712);
            if (this.statusIconTooltip != null && mouseX >= i && mouseX <= i + 10 && mouseY >= top && mouseY <= top + 8) {
                this.screen.method_47415(this.statusIconTooltip);
            } else if (this.onlinePlayersTooltip != null && mouseX >= k && mouseX <= k + j && mouseY >= top && mouseY <= top - 1 + 9) {
                this.screen.method_47414(Lists.transform(this.onlinePlayersTooltip, class_2561::method_30937));
            }
            if (((Boolean)this.minecraft.field_1690.method_42446().method_41753()).booleanValue() || hovering) {
                int l = mouseX - left;
                int m = mouseY - top;
                if (this.canJoin()) {
                    guiGraphics.method_25294(left, top, left + 32, top + 32, -1601138544);
                    if (l < 32 && l > 16) {
                        Sprite.JOIN_HIGHLIGHTED_SPRITE.draw(guiGraphics, left, top);
                    } else {
                        Sprite.JOIN_SPRITE.draw(guiGraphics, left, top);
                    }
                }
            }
        }

        protected boolean isPublished() {
            return true;
        }

        @Override
        public boolean canJoin() {
            return this.serverData.pingResult() == PingResult.SUCCESSFUL && this.isPublished();
        }

        private boolean uploadIcon(byte @Nullable [] iconBytes) {
            if (iconBytes == null) {
                this.icon.method_52198();
            } else {
                try {
                    this.icon.method_52199(class_1011.method_49277((byte[])iconBytes));
                }
                catch (Throwable var3) {
                    LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.serverInfo.field_3752, this.serverData.serverInfo.field_3761, var3});
                    return false;
                }
            }
            return true;
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)FriendsMultiplayerSelectionList.this.method_25342();
            double e = mouseY - (double)FriendsMultiplayerSelectionList.this.method_25337(FriendsMultiplayerSelectionList.this.method_25396().indexOf(this));
            if (d <= 32.0 && d < 32.0 && d > 16.0 && this.canJoin()) {
                this.screen.setSelected(this);
                this.screen.joinSelectedServer();
                return true;
            }
            this.screen.setSelected(this);
            if (class_156.method_658() - this.lastClickTime < 250L && this.canJoin()) {
                this.screen.joinSelectedServer();
            }
            this.lastClickTime = class_156.method_658();
            return super.method_25402(mouseX, mouseY, button);
        }

        @NotNull
        public class_2561 method_37006() {
            class_5250 mutableComponent = class_2561.method_43473();
            mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.serverData.serverInfo.field_3752}));
            mutableComponent.method_10852(class_5244.field_33850);
            switch (this.serverData.pingResult().ordinal()) {
                case 1: {
                    mutableComponent.method_10852(PINGING_STATUS);
                    break;
                }
                case 3: {
                    mutableComponent.method_10852(INCOMPATIBLE_STATUS);
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.version.narration", (Object[])new Object[]{this.serverData.serverInfo.field_3760}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.serverData.serverInfo.field_3757}));
                    break;
                }
                case 2: {
                    mutableComponent.method_10852(NO_CONNECTION_STATUS);
                    break;
                }
                default: {
                    mutableComponent.method_10852(ONLINE_STATUS);
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.ping.narration", (Object[])new Object[]{this.serverData.serverInfo.field_3758}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.motd.narration", (Object[])new Object[]{this.serverData.serverInfo.field_3757}));
                    if (this.serverData.serverInfo.field_41861 == null) break;
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852((class_2561)class_2561.method_43469((String)"multiplayer.status.player_count.narration", (Object[])new Object[]{this.serverData.serverInfo.field_41861.comp_1280(), this.serverData.serverInfo().field_41861.comp_1279()}));
                    mutableComponent.method_10852(class_5244.field_33850);
                    mutableComponent.method_10852(class_2564.method_37112((Collection)this.serverData.serverInfo.field_3762, (class_2561)class_2561.method_43470((String)", ")));
                }
            }
            return mutableComponent;
        }

        @Override
        public void close() {
            this.icon.close();
        }

        @Generated
        public User getUser() {
            return this.user;
        }
    }

    private static enum Sprite {
        UNREACHABLE_SPRITE(0, 5),
        INCOMPATIBLE_SPRITE(0, 5),
        PING_1_SPRITE(0, 4),
        PING_2_SPRITE(0, 3),
        PING_3_SPRITE(0, 2),
        PING_4_SPRITE(0, 3),
        PING_5_SPRITE(0, 0),
        PINGING_1_SPRITE(10, 0),
        PINGING_2_SPRITE(10, 1),
        PINGING_3_SPRITE(10, 2),
        PINGING_4_SPRITE(10, 3),
        PINGING_5_SPRITE(10, 4),
        JOIN_HIGHLIGHTED_SPRITE(0, 32, 32, 32, SERVER_SELECTION_TEXTURE),
        JOIN_SPRITE(0, 0, 32, 32, SERVER_SELECTION_TEXTURE);

        private final int u;
        private final int v;
        private final int texWidth;
        private final int texHeight;
        private final class_2960 atlas;

        private Sprite(int u, int v, int texWidth, int texHeight, class_2960 texture) {
            this.u = u;
            this.v = v;
            this.texWidth = texWidth;
            this.texHeight = texHeight;
            this.atlas = texture;
        }

        private Sprite(int u, int v) {
            this(u, 176 + v * 8, 10, 8, ICONS);
        }

        public void draw(class_332 graphics, int x, int y) {
            graphics.method_25290(this.atlas, x, y, (float)this.u, (float)this.v, this.texWidth, this.texHeight, 256, 256);
        }
    }

    protected static enum PingResult {
        INITIAL,
        PINGING,
        UNREACHABLE,
        INCOMPATIBLE,
        SUCCESSFUL;

    }

    protected static final class ServerInfoEx {
        private final class_642 serverInfo;
        private PingResult pingResult;

        private ServerInfoEx(class_642 serverInfo) {
            this.serverInfo = serverInfo;
            this.pingResult = PingResult.INITIAL;
        }

        public class_642 serverInfo() {
            return this.serverInfo;
        }

        public PingResult pingResult() {
            return this.pingResult;
        }

        @Generated
        public void setPingResult(PingResult pingResult) {
            this.pingResult = pingResult;
        }
    }
}

