/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.auth.skin;

import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Colors;
import io.github.axolotlclient.api.SimpleTextInputScreen;
import io.github.axolotlclient.api.util.UUIDHelper;
import io.github.axolotlclient.modules.auth.Account;
import io.github.axolotlclient.modules.auth.Auth;
import io.github.axolotlclient.modules.auth.MSApi;
import io.github.axolotlclient.modules.auth.skin.Asset;
import io.github.axolotlclient.modules.auth.skin.Cape;
import io.github.axolotlclient.modules.auth.skin.LoadingScreen;
import io.github.axolotlclient.modules.auth.skin.Skin;
import io.github.axolotlclient.modules.auth.skin.SkinImportUtil;
import io.github.axolotlclient.modules.auth.skin.SkinWidget;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.Watcher;
import io.github.axolotlclient.util.notifications.Notifications;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4069;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_4588;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import net.minecraft.class_7413;
import net.minecraft.class_7842;
import net.minecraft.class_7919;
import net.minecraft.class_8016;
import net.minecraft.class_8023;
import net.minecraft.class_8130;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class SkinManagementScreen
extends class_437 {
    private static final Path SKINS_DIR = FabricLoader.getInstance().getGameDir().resolve("skins");
    private static final int LIST_SKIN_WIDTH = 75;
    private static final int LIST_SKIN_HEIGHT = 110;
    private static final class_2561 TEXT_EQUIPPING = class_2561.method_43471((String)"skins.manage.equipping");
    private final class_437 parent;
    private final Account account;
    private MSApi.MCProfile cachedProfile;
    private SkinListWidget skinList;
    private SkinListWidget capesList;
    private boolean capesTab;
    private SkinWidget current;
    private final Watcher skinDirWatcher;
    private final CompletableFuture<MSApi.MCProfile> loadingFuture;

    public SkinManagementScreen(class_437 parent, Account account) {
        super((class_2561)class_2561.method_43471((String)"skins.manage"));
        this.parent = parent;
        this.account = account;
        this.skinDirWatcher = Watcher.createSelfTicking((Path)SKINS_DIR, () -> {
            AxolotlClientCommon.getInstance().getLogger().info("Reloading screen as local files changed!", new Object[0]);
            this.loadSkinsList();
        });
        this.loadingFuture = (account.needsRefresh() ? account.refresh(Auth.getInstance().getMsApi()) : CompletableFuture.completedFuture(null)).thenComposeAsync(unused -> Auth.getInstance().getMsApi().getProfile(account));
    }

    protected void method_25426() {
        int headerHeight = 33;
        int contentHeight = this.field_22790 - headerHeight * 2;
        int n = headerHeight / 2;
        Objects.requireNonNull(this.field_22793);
        int n2 = n - 9 / 2;
        Objects.requireNonNull(this.field_22793);
        class_7842 titleWidget = new class_7842(0, n2, this.field_22789, 9, this.method_25440(), this.field_22793);
        this.method_37063((class_364)titleWidget);
        class_4185 back = (class_4185)this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, btn -> this.method_25419()).method_46434(this.field_22789 / 2 - 75, this.field_22790 - headerHeight / 2 - 10, 150, 20).method_46431());
        var loadingPlaceholder = new class_339(0, headerHeight, this.field_22789, contentHeight, (class_2561)class_2561.method_43471((String)"skins.loading")){

            protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
                int centerX = this.method_46426() + this.method_25368() / 2;
                int centerY = this.method_46427() + this.method_25364() / 2;
                class_2561 text = this.method_25369();
                graphics.method_51439(SkinManagementScreen.this.field_22793, text, centerX - SkinManagementScreen.this.field_22793.method_27525((class_5348)text) / 2, centerY - 9, -1, false);
                String string = class_7413.method_43449((long)class_156.method_658());
                graphics.method_51433(SkinManagementScreen.this.field_22793, string, centerX - SkinManagementScreen.this.field_22793.method_1727(string) / 2, centerY + 9, -8355712, false);
            }

            protected void method_47399(class_6382 builder) {
            }
        };
        loadingPlaceholder.field_22763 = false;
        this.method_37063((class_364)loadingPlaceholder);
        this.method_37063((class_364)back);
        this.skinList = new SkinListWidget(this.field_22787, this.field_22789 / 2, contentHeight - 24, headerHeight + 24, 144);
        this.capesList = new SkinListWidget(this.field_22787, this.field_22789 / 2, contentHeight - 24, headerHeight + 24, this.skinList.getEntryContentsHeight() + 24);
        this.skinList.method_25333(this.field_22789 / 2);
        this.capesList.method_25333(this.field_22789 / 2);
        float currentHeight = Math.min((float)this.field_22789 / 2.0f * 120.0f / 85.0f, (float)contentHeight);
        float currentWidth = currentHeight * 85.0f / 120.0f;
        this.current = new SkinWidget((int)currentWidth, (int)currentHeight, null, this.account);
        this.current.method_48229((int)((float)this.field_22789 / 4.0f - currentWidth / 2.0f), (int)((float)this.field_22790 / 2.0f - currentHeight / 2.0f));
        if (!this.capesTab) {
            this.capesList.active = false;
            this.capesList.visible = false;
        } else {
            this.skinList.active = false;
            this.skinList.visible = false;
        }
        ArrayList<class_4185> navBar = new ArrayList<class_4185>();
        class_4185 skinsTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skins.nav.skins"), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.field_22763 = true;
                }
            });
            btn.field_22763 = false;
            this.skinList.active = true;
            this.skinList.visible = true;
            this.capesList.active = false;
            this.capesList.visible = false;
            this.capesTab = false;
        }).method_46433(Math.max(this.field_22789 * 3 / 4 - 102, this.field_22789 / 2 + 2), headerHeight).method_46432(Math.min(100, this.field_22789 / 4 - 2)).method_46431();
        navBar.add(skinsTab);
        class_4185 capesTab = class_4185.method_46430((class_2561)class_2561.method_43471((String)"skins.nav.capes"), btn -> {
            navBar.forEach(w -> {
                if (w != btn) {
                    w.field_22763 = true;
                }
            });
            btn.field_22763 = false;
            this.skinList.active = false;
            this.skinList.visible = false;
            this.capesList.active = true;
            this.capesList.visible = true;
            this.capesTab = true;
        }).method_46433(this.field_22789 * 3 / 4 + 2, headerHeight).method_46432(Math.min(100, this.field_22789 / 4 - 2)).method_46431();
        navBar.add(capesTab);
        SpriteButton importButton = new SpriteButton((class_2561)class_2561.method_43471((String)"skins.manage.import.local"), btn -> {
            btn.field_22763 = false;
            ((CompletableFuture)SkinImportUtil.openImportSkinDialog().thenAccept(this::method_29638)).thenRun(() -> {
                btn.field_22763 = true;
            });
        }, new class_2960("axolotlclient", "textures/gui/sprites/folder.png"));
        SpriteButton downloadButton = new SpriteButton((class_2561)class_2561.method_43471((String)"skins.manage.import.online"), btn -> {
            btn.field_22763 = false;
            this.promptForSkinDownload();
        }, new class_2960("axolotlclient", "textures/gui/sprites/download.png"));
        if (this.field_22789 - (capesTab.method_46426() + capesTab.method_25368()) > 28) {
            importButton.method_46421(this.field_22789 - importButton.method_25368() - 2);
            downloadButton.method_46421(importButton.method_46426() - downloadButton.method_25368() - 2);
            importButton.method_46419(capesTab.method_46427() + capesTab.method_25364() - 11);
            downloadButton.method_46419(importButton.method_46427());
        } else {
            importButton.method_46421(capesTab.method_46426() + capesTab.method_25368() - 11);
            importButton.method_46419(capesTab.method_46427() - 13);
            downloadButton.method_46421(importButton.method_46426() - 2 - 11);
            downloadButton.method_46419(importButton.method_46427());
        }
        skinsTab.field_22763 = this.capesTab;
        capesTab.field_22763 = !this.capesTab;
        Runnable addWidgets = () -> {
            this.method_37067();
            this.method_37063((class_364)titleWidget);
            this.method_37063((class_364)this.current);
            this.method_37063((class_364)skinsTab);
            this.method_37063((class_364)capesTab);
            this.method_37063((class_364)downloadButton);
            this.method_37063((class_364)importButton);
            this.method_37063((class_364)this.skinList);
            this.method_37063((class_364)this.capesList);
            this.method_37063((class_364)back);
        };
        if (this.cachedProfile != null) {
            this.initDisplay();
            addWidgets.run();
            return;
        }
        ((CompletableFuture)this.loadingFuture.thenAcceptAsync(profile -> {
            this.cachedProfile = profile;
            this.initDisplay();
            addWidgets.run();
        })).exceptionally(t -> {
            if (t.getCause() instanceof CancellationException) {
                this.field_22787.method_1507(this.parent);
                return null;
            }
            AxolotlClientCommon.getInstance().getLogger().error("Failed to load skins!", new Object[]{t});
            class_5250 error = class_2561.method_43471((String)"skins.error.failed_to_load");
            class_5250 errorDesc = class_2561.method_43471((String)"skins.error.failed_to_load_desc");
            this.method_37067();
            this.method_37063((class_364)titleWidget);
            int n = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)error) / 2;
            int n2 = this.field_22790 / 2;
            Objects.requireNonNull(this.field_22793);
            int n3 = n2 - 9 - 2;
            int n4 = this.field_22793.method_27525((class_5348)error);
            Objects.requireNonNull(this.field_22793);
            this.method_37063((class_364)new class_7842(n, n3, n4, 9, (class_2561)error, this.field_22793));
            int n5 = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)errorDesc) / 2;
            int n6 = this.field_22790 / 2 + 1;
            int n7 = this.field_22793.method_27525((class_5348)errorDesc);
            Objects.requireNonNull(this.field_22793);
            this.method_37063((class_364)new class_7842(n5, n6, n7, 9, (class_2561)errorDesc, this.field_22793));
            this.method_37063((class_364)back);
            return null;
        });
    }

    private void promptForSkinDownload() {
        this.field_22787.method_1507((class_437)new SimpleTextInputScreen(this, (class_2561)class_2561.method_43471((String)"skins.manage.import.online"), (class_2561)class_2561.method_43471((String)"skins.manage.import.online.input"), s -> UUIDHelper.ensureUuidOpt((String)s).thenAccept(o -> {
            if (o.isPresent()) {
                AxolotlClientCommon.getInstance().getLogger().info("Downloading skin of {} ({})", new Object[]{s, o.get()});
                ((CompletableFuture)Auth.getInstance().getMsApi().getTextures((String)o.get()).exceptionally(th -> {
                    AxolotlClientCommon.getInstance().getLogger().info("Failed to download skin of {} ({})", new Object[]{s, o.get(), th});
                    return null;
                })).thenAccept(t -> {
                    if (t == null) {
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_download", s);
                        return;
                    }
                    try {
                        byte[] bytes = (byte[])t.skin().join();
                        Path out = this.ensureNonexistent(SKINS_DIR.resolve(t.skinKey()));
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", t.classicModel(), "name", t.name(), "uuid", t.id(), "download_time", Instant.now()));
                        Files.write(out, bytes, new OpenOption[0]);
                        this.field_22787.execute(this::loadSkinsList);
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.downloaded", t.name());
                        AxolotlClientCommon.getInstance().getLogger().info("Downloaded skin of {} ({})", new Object[]{t.name(), o.get()});
                    }
                    catch (IOException e) {
                        AxolotlClientCommon.getInstance().getLogger().warn("Failed to write skin file", new Object[]{e});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.failed_to_save", t.name());
                    }
                });
            } else {
                Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.import.online.not_found", s);
            }
        })));
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    private void initDisplay() {
        this.loadSkinsList();
        this.loadCapesList();
    }

    private void refreshCurrentList() {
        if (this.capesTab) {
            double scroll = this.capesList.method_25341();
            this.loadCapesList();
            this.capesList.method_25307(scroll);
        } else {
            double scroll = this.skinList.method_25341();
            this.loadSkinsList();
            this.skinList.method_25307(scroll);
        }
    }

    private void loadCapesList() {
        ArrayList<Row> rows = new ArrayList<Row>();
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.field_22789 / 2 - 25) / 75);
        List capes = profile.capes();
        SkinWidget deselectCape = this.createWidgetForCape(this.current.getSkin(), null);
        Optional<MSApi.MCProfile.OnlineCape> activeCape = capes.stream().filter(Asset::active).findFirst();
        this.current.setCape(activeCape.orElse(null));
        deselectCape.noCape(activeCape.isEmpty());
        for (int i = 0; i < capes.size() + 1; i += columns) {
            Entry widget;
            if (i == 0) {
                widget = this.createEntry(this.capesList.getEntryContentsHeight(), deselectCape, (class_2561)class_2561.method_43471((String)"skins.capes.no_cape"));
            } else {
                MSApi.MCProfile.OnlineCape cape = (MSApi.MCProfile.OnlineCape)capes.get(i - 1);
                widget = this.createEntryForCape(this.current.getSkin(), (Cape)cape, this.capesList.getEntryContentsHeight());
            }
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            widgets.add(widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= capes.size() + 1 - c) continue;
                MSApi.MCProfile.OnlineCape cape2 = (MSApi.MCProfile.OnlineCape)capes.get(i + c - 1);
                Entry widget2 = this.createEntryForCape(this.current.getSkin(), (Cape)cape2, this.capesList.getEntryContentsHeight());
                widgets.add(widget2);
            }
            rows.add(new Row(widgets));
        }
        this.field_22787.execute(() -> this.capesList.method_25314(rows));
    }

    private void loadSkinsList() {
        MSApi.MCProfile profile = this.cachedProfile;
        int columns = Math.max(2, (this.field_22789 / 2 - 25) / 75);
        ArrayList<Skin> skins = new ArrayList<Skin>(profile.skins());
        Set hashes = skins.stream().map(Asset::sha256).collect(Collectors.toSet());
        Skin defaultSkin = Skin.getDefaultSkin((Account)this.account);
        ArrayList<Skin> local = new ArrayList<Skin>(this.loadLocalSkins());
        Map localHashes = local.stream().collect(Collectors.toMap(Asset::sha256, Function.identity(), (skin, skin2) -> skin));
        local.removeIf(s -> !localHashes.containsValue(s));
        skins.replaceAll(s -> {
            if (s instanceof MSApi.MCProfile.OnlineSkin) {
                Object patt0$temp;
                MSApi.MCProfile.OnlineSkin online = (MSApi.MCProfile.OnlineSkin)s;
                if (localHashes.containsKey(s.sha256()) && (patt0$temp = localHashes.get(s.sha256())) instanceof Skin.LocalSkin) {
                    Skin.LocalSkin file = (Skin.LocalSkin)patt0$temp;
                    local.remove(localHashes.remove(s.sha256()));
                    return new Skin.Shared((Skin.Local)file, online);
                }
            }
            return s;
        });
        skins.addAll(local);
        if (!hashes.contains(defaultSkin.sha256())) {
            skins.add(defaultSkin);
        }
        this.populateSkinList(skins, columns);
    }

    private List<Skin> loadLocalSkins() {
        List<Skin> list;
        block8: {
            Files.createDirectories(SKINS_DIR, new FileAttribute[0]);
            Stream<Path> skins = Files.list(SKINS_DIR);
            try {
                list = skins.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).sorted(Comparator.comparingLong(p -> {
                    try {
                        return Files.getLastModifiedTime(p, new LinkOption[0]).toMillis();
                    }
                    catch (IOException e) {
                        return 0L;
                    }
                }).reversed()).map(Auth.getInstance().getSkinManager()::read).filter(Objects::nonNull).toList();
                if (skins == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (skins != null) {
                        try {
                            skins.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to read skins dir!", new Object[]{e});
                    return Collections.emptyList();
                }
            }
            skins.close();
        }
        return list;
    }

    private void populateSkinList(List<? extends Skin> skins, int columns) {
        int entryHeight = this.skinList.getEntryContentsHeight();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < skins.size(); i += columns) {
            Skin s = skins.get(i);
            if (s != null && s.active()) {
                this.current.setSkin(s);
            }
            Entry widget = this.createEntryForSkin(s, entryHeight);
            ArrayList<class_339> widgets = new ArrayList<class_339>();
            widgets.add(widget);
            for (int c = 1; c < columns; ++c) {
                if (i >= skins.size() - c) continue;
                Skin s2 = skins.get(i + c);
                if (s2 != null && s2.active()) {
                    this.current.setSkin(s2);
                }
                Entry widget2 = this.createEntryForSkin(s2, entryHeight);
                widgets.add(widget2);
            }
            rows.add(new Row(widgets));
        }
        this.field_22787.execute(() -> this.skinList.method_25314(rows));
    }

    private Path ensureNonexistent(Path p) {
        if (Files.exists(p, new LinkOption[0])) {
            int counter = 0;
            while (Files.exists(p = p.resolveSibling(p.getFileName().toString() + "_" + ++counter), new LinkOption[0])) {
            }
        }
        return p;
    }

    public void method_29638(List<Path> packs) {
        if (packs.isEmpty()) {
            return;
        }
        CompletableFuture[] futs = new CompletableFuture[packs.size()];
        for (int i = 0; i < packs.size(); ++i) {
            Path p = packs.get(i);
            futs[i] = CompletableFuture.runAsync(() -> {
                try {
                    Path target = this.ensureNonexistent(SKINS_DIR.resolve(p.getFileName()));
                    Skin skin = Auth.getInstance().getSkinManager().read(p, false);
                    if (skin != null) {
                        Files.write(target, skin.image(), new OpenOption[0]);
                    } else {
                        AxolotlClientCommon.getInstance().getLogger().info("Skipping dragged file {} because it does not seem to be a valid skin!", new Object[]{p});
                        Notifications.getInstance().addStatus("skins.notification.title", "skins.notification.not_copied", p.getFileName());
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to copy skin file: ", new Object[]{e});
                }
            }, (Executor)this.field_22787);
        }
        CompletableFuture.allOf(futs).thenRun(this::loadSkinsList);
    }

    @NotNull
    private Entry createEntryForSkin(Skin skin, int entryHeight) {
        return this.createEntry(entryHeight, new SkinWidget(75, 110, skin, this.account));
    }

    @NotNull
    private Entry createEntryForCape(Skin currentSkin, Cape cape, int entryHeight) {
        return this.createEntry(entryHeight, this.createWidgetForCape(currentSkin, cape), (class_2561)class_2561.method_43470((String)cape.alias()));
    }

    private SkinWidget createWidgetForCape(Skin currentSkin, Cape cape) {
        SkinWidget widget2 = new SkinWidget(75, 110, currentSkin, cape, this.account);
        widget2.setRotationY(210.0f);
        return widget2;
    }

    protected void method_41843() {
        Auth.getInstance().getSkinManager().releaseAll();
        super.method_41843();
    }

    public void method_25432() {
        Auth.getInstance().getSkinManager().releaseAll();
        Watcher.close((Watcher)this.skinDirWatcher);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    private SkinListWidget getCurrentList() {
        return this.capesTab ? this.capesList : this.skinList;
    }

    Entry createEntry(int height, SkinWidget widget) {
        return this.createEntry(height, widget, null);
    }

    Entry createEntry(int height, SkinWidget widget, class_2561 label) {
        return new Entry(height, widget, label);
    }

    private class SkinListWidget
    extends class_4265<Row> {
        public boolean active;
        public boolean visible;

        public SkinListWidget(class_310 minecraft, int width, int height, int y, int entryHeight) {
            super(minecraft, width, SkinManagementScreen.this.field_22790, y, y + height, entryHeight);
            this.active = true;
            this.visible = true;
            this.method_25315(false, 0);
        }

        protected int method_25329() {
            return this.field_19087 - 8;
        }

        public int method_25342() {
            return this.field_19088 + 3;
        }

        public int method_25322() {
            if (this.method_25331() <= 0) {
                return this.field_22742 - 4;
            }
            return this.field_22742 - 14;
        }

        public int getEntryContentsHeight() {
            return this.field_22741 - 4;
        }

        @Nullable
        public class_8016 method_48205(class_8023 event) {
            if (!this.active || !this.visible) {
                return null;
            }
            return super.method_48205(event);
        }

        public void method_25314(Collection<Row> newEntries) {
            super.method_25314(newEntries);
        }

        public void centerScrollOn(Row entry) {
            super.method_25324((class_350.class_351)entry);
        }

        public boolean method_25401(double mouseX, double mouseY, double amountY) {
            if (!this.visible) {
                return false;
            }
            return super.method_25401(mouseX, mouseY, amountY);
        }

        public boolean method_25405(double mouseX, double mouseY) {
            return this.active && this.visible && super.method_25405(mouseX, mouseY);
        }

        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            if (!this.visible) {
                return;
            }
            super.method_25394(graphics, mouseX, mouseY, delta);
        }
    }

    private static class SpriteButton
    extends class_4185 {
        private class_2960 sprite;

        public SpriteButton(class_2561 message, class_4185.class_4241 onPress, class_2960 sprite) {
            super(0, 0, 11, 11, message, onPress, field_40754);
            this.sprite = sprite;
            this.method_47400(class_7919.method_47408((class_2561)message, (class_2561)class_2561.method_43473()));
        }

        public void method_25355(class_2561 message) {
            super.method_25355(message);
            this.method_47400(class_7919.method_47408((class_2561)message, (class_2561)class_2561.method_43473()));
        }

        protected void method_48579(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_48579(graphics, mouseX, mouseY, delta);
            graphics.method_25290(this.sprite, this.method_46426() + 2, this.method_46427() + 2, 0.0f, 0.0f, 7, 7, 7, 7);
        }

        public void method_48589(class_332 graphics, class_327 renderer, int color) {
        }
    }

    private class Entry
    extends class_339
    implements class_4069 {
        private final SkinWidget skinWidget;
        @Nullable
        private final class_339 label;
        private final List<class_339> actionButtons;
        private final class_339 equipButton;
        private boolean equipping;
        private long equippingStart;
        @Nullable
        private class_364 focused;
        private boolean dragging;

        public Entry(int height, @Nullable SkinWidget widget, class_2561 label) {
            super(0, 0, widget.method_25368(), height, (class_2561)class_2561.method_43473());
            this.actionButtons = new ArrayList<class_339>();
            widget.method_25358(this.method_25368() - 4);
            Asset asset = widget.getFocusedAsset();
            if (asset != null) {
                Asset.Online online;
                if (asset instanceof Skin) {
                    Skin skin = (Skin)asset;
                    class_2960 wideSprite = new class_2960("axolotlclient", "textures/gui/sprites/wide.png");
                    class_2960 slimSprite = new class_2960("axolotlclient", "textures/gui/sprites/slim.png");
                    class_5250 slimText = class_2561.method_43471((String)"skins.manage.variant.classic");
                    class_5250 wideText = class_2561.method_43471((String)"skins.manage.variant.slim");
                    this.actionButtons.add((class_339)new SpriteButton((class_2561)(skin.classicVariant() ? wideText : slimText), btn -> {
                        SpriteButton self = (SpriteButton)btn;
                        skin.classicVariant(!skin.classicVariant());
                        self.sprite = skin.classicVariant() ? slimSprite : wideSprite;
                        self.method_25355((class_2561)(skin.classicVariant() ? wideText : slimText));
                    }, skin.classicVariant() ? slimSprite : wideSprite));
                }
                if (asset instanceof Asset.Local) {
                    Asset.Local local = (Asset.Local)asset;
                    this.actionButtons.add((class_339)new SpriteButton((class_2561)class_2561.method_43471((String)"skins.manage.delete"), btn -> {
                        btn.field_22763 = false;
                        SkinManagementScreen.this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                            SkinManagementScreen.this.field_22787.method_1507((class_437)new LoadingScreen(SkinManagementScreen.this.method_25440(), (class_2561)class_2561.method_43471((String)"menu.working")));
                            if (confirmed) {
                                try {
                                    Files.delete(local.file());
                                    Skin.LocalSkin.deleteMetadata((Path)local.file());
                                }
                                catch (IOException e) {
                                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to delete: ", new Object[]{e});
                                }
                            }
                            SkinManagementScreen.this.field_22787.method_1507((class_437)SkinManagementScreen.this);
                            btn.field_22763 = true;
                        }, (class_2561)class_2561.method_43471((String)"skins.manage.delete.confirm"), (class_2561)(asset.active() ? class_2561.method_43471((String)"skins.manage.delete.confirm.desc_active") : class_2561.method_43471((String)"skins.manage.delete.confirm.desc")).br$color(Colors.RED.toInt())));
                    }, new class_2960("axolotlclient", "textures/gui/sprites/delete.png")));
                }
                if (asset instanceof Asset.Online && (online = (Asset.Online)asset).supportsDownload() && !(asset instanceof Asset.Local)) {
                    this.actionButtons.add((class_339)new SpriteButton((class_2561)class_2561.method_43471((String)"skins.manage.download"), btn -> {
                        btn.field_22763 = false;
                        this.download(asset).thenRun(() -> {
                            SkinManagementScreen.this.refreshCurrentList();
                            btn.field_22763 = true;
                        });
                    }, new class_2960("axolotlclient", "textures/gui/sprites/download.png")));
                }
            }
            if (label != null) {
                this.label = new class_8130(0, 0, widget.method_25368(), 16, label, SkinManagementScreen.this.field_22793){

                    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                        this.method_49604(guiGraphics, SkinManagementScreen.this.field_22793, 2, -1);
                    }
                };
                this.label.field_22763 = false;
            } else {
                this.label = null;
            }
            this.equipButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(widget.isEquipped() ? "skins.manage.equipped" : "skins.manage.equip")), btn -> {
                this.equippingStart = class_156.method_658();
                this.equipping = true;
                btn.method_25355(TEXT_EQUIPPING);
                btn.field_22763 = false;
                Consumer<CompletableFuture> consumer = f -> ((CompletableFuture)f.thenAcceptAsync(p -> {
                    SkinManagementScreen.this.cachedProfile = p;
                    if (((SkinManagementScreen)SkinManagementScreen.this).field_22787.field_1755 == SkinManagementScreen.this) {
                        SkinManagementScreen.this.refreshCurrentList();
                    } else {
                        SkinManagementScreen.this.field_22787.execute(() -> SkinManagementScreen.this.field_22787.method_1507((class_437)SkinManagementScreen.this));
                    }
                })).exceptionally(t -> {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to equip asset!", new Object[]{t});
                    this.equipping = false;
                    return null;
                });
                if (asset instanceof Skin && !(SkinManagementScreen.this.current.getSkin() instanceof Skin.Local)) {
                    SkinManagementScreen.this.field_22787.method_1507((class_437)new class_410(confirmed -> {
                        SkinManagementScreen.this.field_22787.method_1507((class_437)new LoadingScreen(SkinManagementScreen.this.method_25440(), TEXT_EQUIPPING));
                        if (confirmed) {
                            consumer.accept((CompletableFuture)this.download((Asset)SkinManagementScreen.this.current.getSkin()).thenCompose(a -> widget.equip()));
                        } else {
                            consumer.accept(widget.equip());
                        }
                    }, (class_2561)class_2561.method_43471((String)"skins.manage.equip.confirm"), (class_2561)class_2561.method_43471((String)"skins.manage.equip.download_current")));
                } else {
                    consumer.accept(widget.equip());
                }
            }).method_46432(widget.method_25368()).method_46431();
            this.equipButton.field_22763 = !widget.isEquipped();
            this.skinWidget = widget;
        }

        @NotNull
        private CompletableFuture<?> download(Asset asset) {
            return CompletableFuture.runAsync(() -> {
                try {
                    Path out = SKINS_DIR.resolve(asset.sha256());
                    Files.createDirectories(out.getParent(), new FileAttribute[0]);
                    Files.write(out, asset.image(), new OpenOption[0]);
                    if (asset instanceof Skin) {
                        Skin skin = (Skin)asset;
                        Skin.LocalSkin.writeMetadata((Path)out, Map.of("variant_classic", skin.classicVariant()));
                    }
                }
                catch (IOException e) {
                    AxolotlClientCommon.getInstance().getLogger().warn("Failed to download: ", new Object[]{e});
                }
            });
        }

        public final boolean method_25397() {
            return this.dragging;
        }

        public final void method_25398(boolean dragging) {
            this.dragging = dragging;
        }

        @Nullable
        public class_364 method_25399() {
            return this.focused;
        }

        public void method_25395(@Nullable class_364 child) {
            if (this.focused != null) {
                this.focused.method_25365(false);
            }
            if (child != null) {
                child.method_25365(true);
            }
            this.focused = child;
        }

        @Nullable
        public class_8016 method_48205(class_8023 event) {
            return super.method_48205(event);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            return super.method_25402(mouseX, mouseY, button);
        }

        public boolean method_25406(double mouseX, double mouseY, int button) {
            return super.method_25406(mouseX, mouseY, button);
        }

        public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
        }

        public boolean method_25370() {
            return super.method_25370();
        }

        public void method_25365(boolean focused) {
            super.method_25365(focused);
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return Stream.concat(this.actionButtons.stream(), Stream.of(new class_339[]{this.skinWidget, this.label, this.equipButton})).filter(Objects::nonNull).toList();
        }

        private float applyEasing(float x) {
            return x * x * x;
        }

        protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
            int y = this.method_46427() + 4;
            int x = this.method_46426() + 2;
            this.skinWidget.method_48229(x, y);
            this.skinWidget.method_25358(this.method_25368() - 4);
            if (this.skinWidget.isEquipped() || this.equipping) {
                long prog = ((Boolean)Auth.getInstance().skinManagerAnimations.get()).booleanValue() ? (this.equipping ? (class_156.method_658() - this.equippingStart) / 20L % 100L : Math.abs(class_156.method_658() / 30L % 200L - 100L)) : 100L;
                float percent = (float)prog / 100.0f;
                float gradientWidth = this.equipping ? percent * Math.min((float)this.method_25368() / 3.0f, (float)this.method_25364() / 3.0f) : Math.min((float)this.method_25368() / 15.0f, (float)this.method_25364() / 6.0f) + this.applyEasing(percent) * Math.min((float)(this.method_25368() * 2) / 15.0f, (float)this.method_25364() / 6.0f);
                GradientHoleRectangleRenderState.render(guiGraphics, this.method_46426() + 2, this.method_46427() + 2, this.method_46426() + this.method_25368() - 2, this.skinWidget.method_46427() + this.skinWidget.method_25364() + 2, gradientWidth, this.equipping ? -65400 : ClientColors.SELECTOR_GREEN.toInt(), 0);
            }
            this.skinWidget.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            int actionButtonY = this.method_46427() + 2;
            for (class_339 button : this.actionButtons) {
                button.method_48229(this.skinWidget.method_46426() + this.skinWidget.method_25368() - button.method_25368(), actionButtonY);
                if (this.method_49606() || button.method_25367()) {
                    button.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                }
                actionButtonY += button.method_25364() + 2;
            }
            if (this.label != null) {
                this.label.method_48229(x, this.skinWidget.method_46427() + this.skinWidget.method_25364() + 6);
                this.label.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                this.label.method_25358(this.method_25368() - 4);
                this.equipButton.method_48229(x, this.label.method_46427() + this.label.method_25364() + 2);
            } else {
                this.equipButton.method_48229(x, this.skinWidget.method_46427() + this.skinWidget.method_25364() + 4);
            }
            this.equipButton.method_25358(this.method_25368() - 4);
            this.equipButton.method_25394(guiGraphics, mouseX, mouseY, partialTick);
            if (this.method_49606()) {
                guiGraphics.br$outlineRect(this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), -1);
            }
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.skinWidget.method_37020(narrationElementOutput);
            this.actionButtons.forEach(w -> w.method_37020(narrationElementOutput));
            if (this.label != null) {
                this.label.method_37020(narrationElementOutput);
            }
            this.equipButton.method_37020(narrationElementOutput);
        }

        private static class GradientHoleRectangleRenderState {
            private GradientHoleRectangleRenderState() {
            }

            public static void render(class_332 graphics, int x0, int y0, int x1, int y1, float gradientWidth, int col1, int col2) {
                class_4588 vertexConsumer = graphics.method_51450().getBuffer(class_1921.method_51784());
                float z = 0.0f;
                Matrix4f pose = graphics.method_51448().method_23760().method_23761();
                vertexConsumer.method_22918(pose, (float)x0, (float)y0, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y0 + gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y0 + gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y0, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x0, (float)y1, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y1 - gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y0 + gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x0, (float)y0, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y1, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y1 - gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x0 + gradientWidth, (float)y1 - gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x0, (float)y1, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y0, z).method_39415(col1).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y0 + gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x1 - gradientWidth, (float)y1 - gradientWidth, z).method_39415(col2).method_1344();
                vertexConsumer.method_22918(pose, (float)x1, (float)y1, z).method_39415(col1).method_1344();
            }
        }
    }

    private class Row
    extends class_4265.class_4266<Row> {
        private final List<class_339> widgets;

        public Row(List<class_339> entries) {
            this.widgets = entries;
        }

        @NotNull
        public List<? extends class_6379> method_37025() {
            return this.widgets;
        }

        public void method_25343(class_332 guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            int x = left;
            if (this.widgets.isEmpty()) {
                return;
            }
            int count = this.widgets.size();
            int padding = (width - 5 * (count - 1)) / count;
            for (class_339 w : this.widgets) {
                w.method_48229(x, top);
                w.method_25358(padding);
                w.method_25394(guiGraphics, mouseX, mouseY, partialTick);
                x += w.method_25368() + 5;
            }
        }

        @NotNull
        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public void method_25395(@Nullable class_364 focused) {
            super.method_25395(focused);
            if (focused != null) {
                SkinManagementScreen.this.getCurrentList().centerScrollOn(this);
            }
        }
    }
}

