/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.AxolotlClientConfig;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.options.OptionCategory;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.util.ConfigStyles;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.HudEntryWidget;
import io.github.axolotlclient.modules.hud.HudManager;
import io.github.axolotlclient.modules.hud.gui.component.HudEntry;
import io.github.axolotlclient.modules.hud.snapping.SnappingHelper;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import org.lwjgl.glfw.GLFW;

public class HudEditScreen
extends class_437 {
    private static final BooleanOption snapping = new BooleanOption("snapping", Boolean.valueOf(true));
    private static final OptionCategory hudEditScreenCategory = OptionCategory.create((String)"hudEditScreen");
    private static final int GRAB_TOLERANCE = 5;
    private static final long MOVE_CURSOR = GLFW.glfwCreateStandardCursor((int)221193);
    private static final long DEFAULT_CURSOR = GLFW.glfwCreateStandardCursor((int)221185);
    private static final long NWSE_RESIZE_CURSOR = GLFW.glfwCreateStandardCursor((int)221191);
    private static final long NESW_RESIZE_CURSOR = GLFW.glfwCreateStandardCursor((int)221192);
    private final class_437 parent;
    private HudEntry current;
    private DrawPosition offset = null;
    private boolean mouseDown;
    private SnappingHelper snap;
    private long currentCursor;
    private ModificationMode mode = ModificationMode.NONE;

    public static boolean isSnappingEnabled() {
        return (Boolean)snapping.get();
    }

    public static void toggleSnapping() {
        snapping.toggle();
    }

    public HudEditScreen() {
        this(null);
    }

    public HudEditScreen(class_437 parent) {
        super((class_2561)class_2561.method_43473());
        this.updateSnapState();
        this.mouseDown = false;
        this.parent = parent;
    }

    private void updateSnapState() {
        if (((Boolean)snapping.get()).booleanValue() && this.current != null) {
            List bounds = HudManager.getInstance().getAllBounds();
            bounds.remove(this.current.getTrueBounds());
            this.snap = new SnappingHelper(bounds, this.current.getTrueBounds());
        } else if (this.snap != null) {
            this.snap = null;
        }
    }

    private void setCursor(long cursor) {
        if (cursor > 0L && cursor != this.currentCursor) {
            this.currentCursor = cursor;
            GLFW.glfwSetCursor((long)class_310.method_1551().method_22683().method_4490(), (long)cursor);
        }
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        Optional<HudEntry> entry;
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        if (this.current != null && this.mode != ModificationMode.NONE) {
            this.current.setHovered(true);
            entry = Optional.of(this.current);
        } else {
            entry = HudManager.getInstance().getEntryXY(mouseX, mouseY);
            entry.ifPresent(abstractHudEntry -> abstractHudEntry.setHovered(true));
        }
        HudManager.getInstance().renderPlaceholder((AxoRenderContext)graphics, delta);
        if (entry.isPresent()) {
            Rectangle bounds = entry.get().getTrueBounds();
            if (this.mode == ModificationMode.NONE && bounds.isMouseOver((double)mouseX, (double)mouseY)) {
                boolean supportsScaling = entry.get().supportsScaling();
                int xBound = Math.max(0, mouseX - bounds.x());
                int yBound = Math.max(0, mouseY - bounds.y());
                int tolerance = 5;
                if (supportsScaling && xBound < tolerance && yBound < tolerance) {
                    this.setCursor(NWSE_RESIZE_CURSOR);
                } else if (supportsScaling && Math.abs(xBound - bounds.width()) < tolerance && Math.abs(yBound - bounds.height()) < tolerance) {
                    this.setCursor(NWSE_RESIZE_CURSOR);
                } else if (supportsScaling && xBound < tolerance && Math.abs(yBound - bounds.height()) < tolerance) {
                    this.setCursor(NESW_RESIZE_CURSOR);
                } else if (supportsScaling && yBound < tolerance && Math.abs(xBound - bounds.width()) < tolerance) {
                    this.setCursor(NESW_RESIZE_CURSOR);
                } else {
                    this.setCursor(MOVE_CURSOR);
                }
            }
        } else if (this.current == null) {
            this.setCursor(DEFAULT_CURSOR);
            this.mode = ModificationMode.NONE;
        }
        if (this.mouseDown && this.snap != null) {
            this.snap.renderSnaps(graphics);
        }
    }

    public void method_25426() {
        this.mode = ModificationMode.NONE;
        HudManager.getInstance().getMoveableEntries().forEach(e -> this.method_37063(new HudEntryWidget((HudEntry)e)));
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"hud.snapping").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)((Boolean)snapping.get() != false ? "options.on" : "options.off"))), buttonWidget -> {
            snapping.toggle();
            buttonWidget.method_25355((class_2561)class_2561.method_43471((String)"hud.snapping").method_27693(": ").method_10852((class_2561)class_2561.method_43471((String)((Boolean)snapping.get() != false ? "options.on" : "options.off"))));
            AxolotlClient.getInstance().getConfigManager().save();
        }).method_46434(this.field_22789 / 2 - 50, this.field_22790 / 2 + 12, 100, 20).method_46431());
        this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"hud.clientOptions"), buttonWidget -> {
            class_437 screen = ConfigStyles.createScreen((class_437)this, (OptionCategory)AxolotlClient.getInstance().getConfigManager().getRoot());
            class_310.method_1551().method_1507(screen);
        }).method_46434(this.field_22789 / 2 - 75, this.field_22790 / 2 - 10, 150, 20).method_46431());
        if (this.parent != null) {
            this.method_37063((class_364)new class_4185.class_7840(class_5244.field_24339, buttonWidget -> class_310.method_1551().method_1507(this.parent)).method_46434(this.field_22789 / 2 - 75, this.field_22790 - 50 + 22, 150, 20).method_46431());
        } else {
            this.method_37063((class_364)new class_4185.class_7840((class_2561)class_2561.method_43471((String)"close"), buttonWidget -> class_310.method_1551().method_1507(null)).method_46434(this.field_22789 / 2 - 75, this.field_22790 - 50 + 22, 150, 20).method_46431());
        }
    }

    public void method_25432() {
        this.setCursor(DEFAULT_CURSOR);
        this.mode = ModificationMode.NONE;
        super.method_25432();
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        super.method_25402(mouseX, mouseY, button);
        Optional entry = HudManager.getInstance().getEntryXY((int)Math.round(mouseX), (int)Math.round(mouseY));
        if (button == 0) {
            this.mouseDown = true;
            if (entry.isPresent()) {
                this.current = (HudEntry)entry.get();
                this.offset = new DrawPosition((int)Math.round(mouseX - (double)this.current.getTruePos().x()), (int)Math.round(mouseY - (double)this.current.getTruePos().y()));
                Rectangle bounds = ((HudEntry)entry.get()).getTrueBounds();
                double xBound = Math.max(0.0, mouseX - (double)bounds.x());
                double yBound = Math.max(0.0, mouseY - (double)bounds.y());
                if (this.currentCursor == NWSE_RESIZE_CURSOR) {
                    if (xBound < (double)((float)bounds.width() / 2.0f) && yBound < (double)((float)bounds.height() / 2.0f)) {
                        this.mode = ModificationMode.TOP_LEFT;
                    } else if (xBound - (double)((float)bounds.width() / 2.0f) > 0.0 && yBound - (double)((float)bounds.height() / 2.0f) > 0.0) {
                        this.mode = ModificationMode.BOTTOM_RIGHT;
                    }
                } else if (this.currentCursor == NESW_RESIZE_CURSOR) {
                    if (xBound < (double)((float)bounds.width() / 2.0f) && yBound - (double)((float)bounds.height() / 2.0f) > 0.0) {
                        this.mode = ModificationMode.BOTTOM_LEFT;
                    } else if (xBound - (double)((float)bounds.width() / 2.0f) > 0.0 && yBound < (double)((float)bounds.height() / 2.0f)) {
                        this.mode = ModificationMode.TOP_RIGHT;
                    }
                } else if (this.currentCursor == MOVE_CURSOR) {
                    this.updateSnapState();
                    this.mode = ModificationMode.MOVE;
                }
                return true;
            }
            this.mode = ModificationMode.NONE;
            this.current = null;
        } else if (button == 1) {
            entry.ifPresent(abstractHudEntry -> {
                class_437 screen = ConfigStyles.createScreen((class_437)this, (OptionCategory)abstractHudEntry.getCategory());
                class_310.method_1551().method_1507(screen);
            });
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.current != null) {
            AxolotlClientConfig.getInstance().getConfigManager(this.current.getCategory()).save();
        }
        this.current = null;
        this.snap = null;
        this.mouseDown = false;
        this.mode = ModificationMode.NONE;
        this.setCursor(DEFAULT_CURSOR);
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.current != null) {
            if (this.mode == ModificationMode.MOVE) {
                this.current.setX((int)mouseX - this.offset.x() + this.current.offsetTrueWidth());
                this.current.setY((int)mouseY - this.offset.y() + this.current.offsetTrueHeight());
                if (this.snap != null) {
                    Integer snapY;
                    this.snap.setCurrent(this.current.getTrueBounds());
                    Integer snapX = this.snap.getCurrentXSnap();
                    if (snapX != null) {
                        this.current.setX(snapX + this.current.offsetTrueWidth());
                    }
                    if ((snapY = this.snap.getCurrentYSnap()) != null) {
                        this.current.setY(snapY + this.current.offsetTrueHeight());
                    }
                }
            } else {
                double newHeight;
                double newWidth;
                Rectangle bounds = this.current.getTrueBounds();
                if (this.mode == ModificationMode.TOP_LEFT) {
                    newWidth = mouseX - (double)bounds.xEnd();
                    newHeight = mouseY - (double)bounds.yEnd();
                } else if (this.mode == ModificationMode.BOTTOM_LEFT) {
                    newWidth = mouseX - (double)bounds.xEnd();
                    newHeight = mouseY - (double)bounds.y();
                } else if (this.mode == ModificationMode.TOP_RIGHT) {
                    newWidth = mouseX - (double)bounds.x();
                    newHeight = mouseY - (double)bounds.yEnd();
                } else if (this.mode == ModificationMode.BOTTOM_RIGHT) {
                    newWidth = mouseX - (double)bounds.x();
                    newHeight = mouseY - (double)bounds.y();
                } else {
                    newWidth = bounds.width();
                    newHeight = bounds.height();
                }
                float newScale = this.current.getScale() * Math.max((float)Math.abs(newWidth) / (float)bounds.width(), (float)Math.abs(newHeight) / (float)bounds.height());
                this.current.setScale(Math.max(0.1f, newScale));
                if (this.mode == ModificationMode.TOP_LEFT) {
                    this.current.setX(bounds.xEnd() - this.current.getTrueWidth() + this.current.offsetTrueWidth());
                    this.current.setY(bounds.yEnd() - this.current.getTrueHeight() + this.current.offsetTrueHeight());
                } else if (this.mode == ModificationMode.BOTTOM_LEFT) {
                    this.current.setX(bounds.xEnd() - this.current.getTrueWidth() + this.current.offsetTrueWidth());
                } else if (this.mode == ModificationMode.TOP_RIGHT) {
                    this.current.setY(bounds.yEnd() - this.current.getTrueHeight() + this.current.offsetTrueHeight());
                }
            }
            if (this.current.tickable()) {
                this.current.tick();
            }
            return true;
        }
        return false;
    }

    static {
        hudEditScreenCategory.add(new Option[]{snapping});
        AxolotlClient.config().hidden.add(new OptionCategory[]{hudEditScreenCategory});
    }

    private static enum ModificationMode {
        NONE,
        MOVE,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }
}

