/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientCommon;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Color;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.ColorOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.IntegerOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.config.profiles.ProfileAware;
import io.github.axolotlclient.mixin.KeyBindAccessor;
import io.github.axolotlclient.modules.hud.ClickInputTracker;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.keystrokes.KeystrokePositioningScreen;
import io.github.axolotlclient.modules.hud.gui.keystrokes.KeystrokesScreen;
import io.github.axolotlclient.modules.hud.gui.layout.Justification;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import io.github.axolotlclient.modules.hud.util.Rectangle;
import io.github.axolotlclient.util.ClientColors;
import io.github.axolotlclient.util.GsonHelper;
import io.github.axolotlclient.util.events.Events;
import io.github.axolotlclient.util.options.GenericOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_437;

public class KeystrokeHud
extends TextHudEntry
implements ProfileAware {
    private static final String KEYSTROKE_SAVE_FILE_NAME = "keystrokes.json";
    public static final class_2960 ID = new class_2960("kronhud", "keystrokehud");
    private final ColorOption pressedTextColor = new ColorOption("heldtextcolor", new Color(-16777216));
    private final ColorOption pressedBackgroundColor = new ColorOption("heldbackgroundcolor", new Color(0x64FFFFFF));
    private final ColorOption pressedOutlineColor = new ColorOption("heldoutlinecolor", ClientColors.BLACK);
    private final class_310 client;
    private final GenericOption keystrokesOption;
    private final GenericOption configurePositions;
    private final IntegerOption animationTime;
    public ArrayList<Keystroke> keystrokes;

    public KeystrokeHud() {
        super(53, 61, true);
        this.client = (class_310)((TextHudEntry)this).client;
        this.keystrokesOption = new GenericOption("keystrokes", "keystrokes.configure", () -> this.client.method_1507((class_437)new KeystrokesScreen(this, this.client.field_1755)));
        this.configurePositions = new GenericOption("keystrokes.positions", "keystrokes.positions.configure", () -> this.client.method_1507((class_437)new KeystrokePositioningScreen(this.client.field_1755, this)));
        this.animationTime = new IntegerOption("keystrokes.animation_time", Integer.valueOf(100), Integer.valueOf(0), Integer.valueOf(500));
        Events.KEYBIND_CHANGE.register(key -> {
            if (class_310.method_1551().method_22683() != null) {
                class_304.method_1437();
                class_304.method_1424();
            }
        });
    }

    public static Optional<String> getMouseKeyBindName(class_304 keyBinding) {
        if (keyBinding.method_1428().equalsIgnoreCase(class_3675.class_307.field_1672.method_1447(0).method_1441())) {
            return Optional.of("LMB");
        }
        if (keyBinding.method_1428().equalsIgnoreCase(class_3675.class_307.field_1672.method_1447(1).method_1441())) {
            return Optional.of("RMB");
        }
        if (keyBinding.method_1428().equalsIgnoreCase(class_3675.class_307.field_1672.method_1447(2).method_1441())) {
            return Optional.of("MMB");
        }
        return Optional.empty();
    }

    public void setDefaultKeystrokes() {
        DrawPosition pos = this.getPos();
        this.keystrokes.add(this.createFromKey(new Rectangle(0, 36, 26, 17), pos, this.client.field_1690.field_1886));
        this.keystrokes.add(this.createFromKey(new Rectangle(27, 36, 26, 17), pos, this.client.field_1690.field_1904));
        this.keystrokes.add(this.createFromKey(new Rectangle(18, 0, 17, 17), pos, this.client.field_1690.field_1894));
        this.keystrokes.add(this.createFromKey(new Rectangle(0, 18, 17, 17), pos, this.client.field_1690.field_1913));
        this.keystrokes.add(this.createFromKey(new Rectangle(18, 18, 17, 17), pos, this.client.field_1690.field_1881));
        this.keystrokes.add(this.createFromKey(new Rectangle(36, 18, 17, 17), pos, this.client.field_1690.field_1849));
        this.keystrokes.add(new CustomRenderKeystroke(SpecialKeystroke.SPACE));
    }

    public void setKeystrokes() {
        if (this.client.method_22683() == null) {
            this.keystrokes = null;
            return;
        }
        this.keystrokes = new ArrayList();
        this.setDefaultKeystrokes();
        this.loadKeystrokes();
        class_304.method_1437();
        class_304.method_1424();
    }

    public Keystroke createFromKey(Rectangle bounds, DrawPosition offset, class_304 key) {
        String name = KeystrokeHud.getMouseKeyBindName(key).orElse(key.method_16007().getString().toUpperCase());
        if (name.length() > 4) {
            name = name.substring(0, 2);
        }
        return this.createFromString(bounds, offset, key, name);
    }

    public Keystroke createFromString(Rectangle bounds, DrawPosition offset, class_304 key, String word) {
        return new LabelKeystroke(bounds, offset, key, word);
    }

    public void render(AxoRenderContext context, float delta) {
        class_332 graphics = (class_332)context;
        graphics.method_51448().method_22903();
        this.scale((AxoRenderContext)graphics);
        this.renderComponent((AxoRenderContext)graphics, delta);
        graphics.method_51448().method_22909();
    }

    public void renderComponent(AxoRenderContext context, float delta) {
        class_332 graphics = (class_332)context;
        if (this.keystrokes == null) {
            this.setKeystrokes();
        }
        for (Keystroke stroke : this.keystrokes) {
            stroke.render(graphics);
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
        this.renderComponent(graphics, delta);
    }

    public boolean tickable() {
        return true;
    }

    public void tick() {
        DrawPosition pos = this.getPos();
        if (this.keystrokes == null) {
            this.setKeystrokes();
        }
        for (Keystroke stroke : this.keystrokes) {
            stroke.offset = pos;
        }
    }

    protected boolean getShadowDefault() {
        return false;
    }

    public List<Option<?>> getConfigurationOptions() {
        ArrayList options = new ArrayList();
        options.add((Option<?>)this.enabled);
        options.add((Option<?>)this.scale);
        options.add((Option<?>)this.textColor);
        options.add((Option<?>)this.pressedTextColor);
        options.add((Option<?>)this.shadow);
        options.add((Option<?>)this.background);
        options.add((Option<?>)this.backgroundColor);
        options.add((Option<?>)this.pressedBackgroundColor);
        options.add((Option<?>)this.outline);
        options.add((Option<?>)this.outlineColor);
        options.add((Option<?>)this.pressedOutlineColor);
        options.add((Option<?>)this.animationTime);
        options.add((Option<?>)this.keystrokesOption);
        options.add((Option<?>)this.configurePositions);
        return options;
    }

    public class_2960 getId() {
        return ID;
    }

    public void reloadConfig() {
        this.keystrokes = null;
    }

    public void saveConfig() {
        this.saveKeystrokes();
    }

    private Keystroke deserializeKey(Map<String, Object> json) {
        if ("option".equals(json.get("type"))) {
            class_304 key = KeyBindAccessor.getAllKeyBinds().get((String)json.getOrDefault("key_name", json.get("option")));
            return new CustomRenderKeystroke(SpecialKeystroke.byId.get(((String)json.get("special_name")).toLowerCase(Locale.ROOT)), KeystrokeHud.getRectangle((Map)json.get("bounds")), this.getPos(), key);
        }
        class_304 key = KeyBindAccessor.getAllKeyBinds().get((String)json.get("key_name"));
        return new LabelKeystroke(KeystrokeHud.getRectangle((Map)json.get("bounds")), this.getPos(), key, (String)json.get("label"), (Boolean)json.get("synchronize_label"), Justification.valueOf((String)((String)json.getOrDefault("justification", "CENTER"))));
    }

    private static Rectangle getRectangle(Map<String, ?> json) {
        return new Rectangle((int)((Long)json.get("x")).longValue(), (int)((Long)json.get("y")).longValue(), (int)((Long)json.get("width")).longValue(), (int)((Long)json.get("height")).longValue());
    }

    public Keystroke newSpecialStroke(SpecialKeystroke stroke) {
        return new CustomRenderKeystroke(stroke);
    }

    public LabelKeystroke newStroke() {
        return new LabelKeystroke(new Rectangle(0, 0, 17, 17), this.getPos(), null, "", false, Justification.CENTER);
    }

    public void saveKeystrokes() {
        if (this.keystrokes == null) {
            return;
        }
        try {
            Path path = AxolotlClientCommon.resolveProfileConfigFile((String)KEYSTROKE_SAVE_FILE_NAME);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)GsonHelper.GSON.toJson(this.keystrokes.stream().map(Keystroke::serialize).toList()), new OpenOption[0]);
        }
        catch (Exception e) {
            AxolotlClient.LOGGER.warn("Failed to save keystroke configuration!", new Object[]{e});
        }
    }

    public void loadKeystrokes() {
        try {
            Path path = AxolotlClientCommon.resolveProfileConfigFile((String)KEYSTROKE_SAVE_FILE_NAME);
            if (Files.exists(path, new LinkOption[0])) {
                List entries = (List)GsonHelper.read((String)Files.readString(path));
                List<Keystroke> loaded = entries.stream().map(e -> (Map)e).map(this::deserializeKey).toList();
                if (this.keystrokes == null) {
                    this.keystrokes = new ArrayList();
                } else {
                    this.keystrokes.clear();
                }
                this.keystrokes.addAll(loaded);
            } else {
                this.saveKeystrokes();
            }
        }
        catch (Exception e2) {
            AxolotlClient.LOGGER.warn("Failed to load keystroke configuration, using defaults!", new Object[]{e2});
        }
    }

    public abstract class Keystroke {
        protected class_304 key;
        protected KeystrokeRenderer render;
        protected final Rectangle bounds;
        protected DrawPosition offset;
        private long start = -1L;
        private boolean wasPressed = false;

        public Keystroke(Rectangle bounds, DrawPosition offset, class_304 key, KeystrokeRenderer render) {
            this.bounds = bounds;
            this.offset = offset;
            this.key = key;
            this.render = render;
        }

        public void setX(int x) {
            this.bounds.x(x - this.offset.x());
        }

        public void setY(int y) {
            this.bounds.y(y - this.offset.y());
        }

        public Rectangle getRenderPosition() {
            return this.bounds.offset(this.offset);
        }

        public Color getFGColor() {
            return this.isKeyDown() ? ClientColors.blend((Color)KeystrokeHud.this.textColor.get(), (Color)KeystrokeHud.this.pressedTextColor.get(), (float)this.getPercentPressed()) : ClientColors.blend((Color)KeystrokeHud.this.pressedTextColor.get(), (Color)KeystrokeHud.this.textColor.get(), (float)this.getPercentPressed());
        }

        private float getPercentPressed() {
            return this.start == -1L ? 1.0f : class_3532.method_15363((float)((float)(class_156.method_658() - this.start) / (float)this.getAnimTime()), (float)0.0f, (float)1.0f);
        }

        public void render(class_332 matrices) {
            this.renderStroke(matrices);
            this.render.render(this, matrices);
        }

        public void renderStroke(class_332 matrices) {
            if (this.isKeyDown() != this.wasPressed) {
                this.start = class_156.method_658();
            }
            Rectangle rect = this.getRenderPosition();
            if (((Boolean)KeystrokeHud.this.background.get()).booleanValue()) {
                DrawUtil.fillRect(matrices, rect, this.getColor());
            }
            if (((Boolean)KeystrokeHud.this.outline.get()).booleanValue()) {
                DrawUtil.outlineRect(matrices, rect, this.getOutlineColor());
            }
            if ((float)(class_156.method_658() - this.start) / (float)this.getAnimTime() >= 1.0f) {
                this.start = -1L;
            }
            this.wasPressed = this.isKeyDown();
        }

        private int getAnimTime() {
            return (Integer)KeystrokeHud.this.animationTime.get();
        }

        private boolean isKeyDown() {
            return this.key != null && this.key.method_1434();
        }

        public Color getColor() {
            return this.isKeyDown() ? ClientColors.blend((Color)KeystrokeHud.this.backgroundColor.get(), (Color)KeystrokeHud.this.pressedBackgroundColor.get(), (float)this.getPercentPressed()) : ClientColors.blend((Color)KeystrokeHud.this.pressedBackgroundColor.get(), (Color)KeystrokeHud.this.backgroundColor.get(), (float)this.getPercentPressed());
        }

        public Color getOutlineColor() {
            return this.isKeyDown() ? ClientColors.blend((Color)KeystrokeHud.this.outlineColor.get(), (Color)KeystrokeHud.this.pressedOutlineColor.get(), (float)this.getPercentPressed()) : ClientColors.blend((Color)KeystrokeHud.this.pressedOutlineColor.get(), (Color)KeystrokeHud.this.outlineColor.get(), (float)this.getPercentPressed());
        }

        public Map<String, Object> serialize() {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("key", this.key.method_1428());
            map.put("bounds", Map.of("x", this.bounds.x(), "y", this.bounds.y(), "width", this.bounds.width(), "height", this.bounds.height()));
            return map;
        }

        public abstract String getLabel();

        public abstract void setLabel(String var1);

        public abstract boolean isLabelEditable();

        @Generated
        public class_304 getKey() {
            return this.key;
        }

        @Generated
        public void setKey(class_304 key) {
            this.key = key;
        }

        @Generated
        public Rectangle getBounds() {
            return this.bounds;
        }
    }

    public class CustomRenderKeystroke
    extends Keystroke {
        private static final Supplier<String> label = () -> String.valueOf(class_124.field_1056) + class_1074.method_4662((String)"keystrokes.stroke.custom_renderer", (Object[])new Object[0]);
        private final SpecialKeystroke parent;

        public CustomRenderKeystroke(SpecialKeystroke stroke, Rectangle bounds, DrawPosition offset, class_304 key) {
            super(bounds, offset, key, (Keystroke s, class_332 g) -> stroke.getRenderer().render(KeystrokeHud.this, s, g));
            this.parent = stroke;
        }

        public CustomRenderKeystroke(SpecialKeystroke stroke) {
            this(stroke, stroke.getRect().copy(), this$0.getPos(), stroke.getKey());
        }

        @Override
        public Map<String, Object> serialize() {
            Map<String, Object> json = super.serialize();
            json.put("type", "option");
            json.put("key_name", this.key.method_1431());
            json.put("special_name", this.parent.getId());
            return json;
        }

        @Override
        public String getLabel() {
            return label.get();
        }

        @Override
        public void setLabel(String label) {
        }

        @Override
        public boolean isLabelEditable() {
            return false;
        }
    }

    public static enum SpecialKeystroke {
        SPACE("space", new Rectangle(0, 54, 53, 7), class_310.method_1551().field_1690.field_1903, (hud, stroke, matrices) -> {
            Rectangle bounds = stroke.bounds;
            Rectangle spaceBounds = new Rectangle(bounds.x() + stroke.offset.x() + 4, bounds.y() + stroke.offset.y() + bounds.height() / 2 - 1, bounds.width() - 8, 1);
            DrawUtil.fillRect(matrices, spaceBounds, stroke.getFGColor());
            if (((Boolean)hud.shadow.get()).booleanValue()) {
                DrawUtil.fillRect(matrices, spaceBounds.offset(1, 1), new Color((stroke.getFGColor().toInt() & 0xFCFCFC) >> 2 | stroke.getFGColor().toInt() & 0xFF000000));
            }
        }),
        LMB_CPS("lmb_cps", new Rectangle(0, 36, 26, 17), class_310.method_1551().field_1690.field_1886, (hud, stroke, graphics) -> {
            Rectangle bounds = stroke.bounds;
            int centerX = bounds.x() + stroke.offset.x() + bounds.width() / 2;
            int y = bounds.y() + stroke.offset.y() + 3;
            int n = y + bounds.height() / 4;
            Objects.requireNonNull(hud.client.field_1772);
            int nameY = n - 9 / 2;
            DrawUtil.drawCenteredString(graphics, hud.client.field_1772, "LMB", centerX, nameY, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            int n2 = y + bounds.height() * 3 / 4;
            Objects.requireNonNull(hud.client.field_1772);
            int cpsY = n2 - 9 / 2;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)centerX, (float)cpsY, 0.0f);
            graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
            String cpsText = ClickInputTracker.getInstance().leftMouse.clicks() + " CPS";
            graphics.method_51448().method_46416((float)(-hud.client.field_1772.method_1727(cpsText)) / 2.0f, 0.0f, 0.0f);
            DrawUtil.drawString(graphics, cpsText, 0.0f, 0.0f, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            graphics.method_51448().method_22909();
        }),
        RMB_CPS("rmb_cps", new Rectangle(27, 36, 26, 17), class_310.method_1551().field_1690.field_1904, (hud, stroke, graphics) -> {
            Rectangle bounds = stroke.bounds;
            int centerX = bounds.x() + stroke.offset.x() + bounds.width() / 2;
            int y = bounds.y() + stroke.offset.y() + 3;
            int n = y + bounds.height() / 4;
            Objects.requireNonNull(hud.client.field_1772);
            int nameY = n - 9 / 2;
            DrawUtil.drawCenteredString(graphics, hud.client.field_1772, "RMB", centerX, nameY, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            int n2 = y + bounds.height() * 3 / 4;
            Objects.requireNonNull(hud.client.field_1772);
            int cpsY = n2 - 9 / 2;
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)centerX, (float)cpsY, 0.0f);
            graphics.method_51448().method_22905(0.5f, 0.5f, 1.0f);
            String cpsText = ClickInputTracker.getInstance().rightMouse.clicks() + " CPS";
            graphics.method_51448().method_46416((float)(-hud.client.field_1772.method_1727(cpsText)) / 2.0f, 0.0f, 0.0f);
            DrawUtil.drawString(graphics, cpsText, 0.0f, 0.0f, stroke.getFGColor(), (boolean)((Boolean)hud.shadow.get()));
            graphics.method_51448().method_22909();
        });

        private static final Map<String, SpecialKeystroke> byId;
        private final String id;
        private final Rectangle rect;
        private final class_304 key;
        private final SpecialKeystrokeRenderer renderer;

        @Generated
        private SpecialKeystroke(String id, Rectangle rect, class_304 key, SpecialKeystrokeRenderer renderer) {
            this.id = id;
            this.rect = rect;
            this.key = key;
            this.renderer = renderer;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public Rectangle getRect() {
            return this.rect;
        }

        @Generated
        public class_304 getKey() {
            return this.key;
        }

        @Generated
        public SpecialKeystrokeRenderer getRenderer() {
            return this.renderer;
        }

        static {
            byId = Arrays.stream(SpecialKeystroke.values()).collect(Collectors.toMap(SpecialKeystroke::getId, Function.identity()));
        }

        public static interface SpecialKeystrokeRenderer {
            public void render(KeystrokeHud var1, Keystroke var2, class_332 var3);
        }
    }

    public class LabelKeystroke
    extends Keystroke {
        private String label;
        private boolean synchronizeLabel;
        private Justification justification;

        public LabelKeystroke(Rectangle bounds, DrawPosition offset, class_304 key, String label) {
            this(bounds, offset, key, label, true, Justification.CENTER);
        }

        public LabelKeystroke(Rectangle bounds, DrawPosition offset, class_304 key, String label, boolean synchronizeLabel, Justification justification) {
            super(bounds, offset, key, (Keystroke stroke, class_332 matrices) -> {});
            this.label = label;
            this.render = (stroke, matrices) -> {
                Rectangle strokeBounds = stroke.bounds;
                int x = strokeBounds.x() + stroke.offset.x() + 2 + this.justification.getXOffset(this.getLabel(), strokeBounds.width() - 3);
                float y = (float)(strokeBounds.y() + stroke.offset.y()) + (float)strokeBounds.height() / 2.0f - 4.0f;
                DrawUtil.drawString(matrices, this.getLabel(), (float)x, (float)((int)y), stroke.getFGColor().toInt(), (boolean)((Boolean)KeystrokeHud.this.shadow.get()));
            };
            this.setSynchronizeLabel(synchronizeLabel);
            this.justification = justification;
        }

        @Override
        public Map<String, Object> serialize() {
            Map<String, Object> json = super.serialize();
            json.put("type", "custom");
            json.put("key_name", this.key.method_1431());
            json.put("label", this.label);
            json.put("synchronize_label", this.synchronizeLabel);
            json.put("justification", this.justification.name());
            return json;
        }

        public void setSynchronizeLabel(boolean synchronizeLabel) {
            if (synchronizeLabel) {
                String name = KeystrokeHud.getMouseKeyBindName(this.key).orElse(this.key.method_16007().getString().toUpperCase());
                if (name.length() > 4) {
                    name = name.substring(0, 2);
                }
                this.label = name;
            }
            this.synchronizeLabel = synchronizeLabel;
        }

        @Override
        public void setKey(class_304 key) {
            if (this.synchronizeLabel) {
                String name = KeystrokeHud.getMouseKeyBindName(key).orElse(key.method_16007().getString().toUpperCase());
                if (name.length() > 4) {
                    name = name.substring(0, 2);
                }
                this.label = name;
            }
            super.setKey(key);
        }

        @Override
        public String getLabel() {
            return this.label;
        }

        @Override
        public boolean isLabelEditable() {
            return true;
        }

        @Override
        @Generated
        public void setLabel(String label) {
            this.label = label;
        }

        @Generated
        public void setJustification(Justification justification) {
            this.justification = justification;
        }

        @Generated
        public boolean isSynchronizeLabel() {
            return this.synchronizeLabel;
        }

        @Generated
        public Justification getJustification() {
            return this.justification;
        }
    }

    public static interface KeystrokeRenderer {
        public void render(Keystroke var1, class_332 var2);
    }
}

