/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_332;
import net.minecraft.class_7367;

public class PackDisplayHud
extends TextHudEntry {
    public static final class_2960 ID = new class_2960("axolotlclient", "packdisplayhud");
    public final List<PackWidget> widgets = new ArrayList<PackWidget>();
    private final BooleanOption iconsOnly = new BooleanOption("iconsonly", Boolean.valueOf(false));
    private PackWidget placeholder;

    public PackDisplayHud() {
        super(200, 50, true);
    }

    public void renderComponent(AxoRenderContext graphics, float f) {
        DrawPosition pos = this.getPos();
        if (this.widgets.isEmpty()) {
            this.init();
        }
        if (((Boolean)this.background.get()).booleanValue()) {
            DrawUtil.fillRect((class_332)graphics, this.getBounds(), this.backgroundColor.get());
        }
        if (((Boolean)this.outline.get()).booleanValue()) {
            DrawUtil.outlineRect((class_332)graphics, this.getBounds(), this.outlineColor.get());
        }
        int y = pos.y() + 1;
        for (int i = this.widgets.size() - 1; i >= 0; --i) {
            this.widgets.get(i).render((class_332)graphics, pos.x() + 1, y);
            y += 18;
        }
        if (y - pos.y() + 1 != this.getHeight()) {
            this.setHeight(y - pos.y() - 1);
            this.onBoundsUpdate();
        }
    }

    public void init() {
        int listSize = class_310.method_1551().method_1520().method_14441().size();
        class_310.method_1551().method_1520().method_14444().forEach(profile -> {
            try (class_3262 pack = profile.method_14458();){
                if (listSize == 1) {
                    this.widgets.add(this.createWidget(profile.method_14457(), pack));
                } else if (!pack.method_14409().equalsIgnoreCase("vanilla")) {
                    this.widgets.add(this.createWidget(profile.method_14457(), pack));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AtomicInteger w = new AtomicInteger(20);
        this.widgets.forEach(packWidget -> {
            int textW = class_310.method_1551().field_1772.method_1727(packWidget.getName()) + 20;
            if (textW > w.get()) {
                w.set(textW);
            }
        });
        this.setWidth(w.get());
        this.setHeight(this.widgets.size() * 18);
        this.onBoundsUpdate();
    }

    private PackWidget createWidget(class_2561 displayName, class_3262 pack) throws IOException, AssertionError {
        class_7367 supplier = pack.method_14410(new String[]{"pack.png"});
        assert (supplier != null);
        InputStream stream = (InputStream)supplier.get();
        if (stream != null) {
            class_2960 id = class_310.method_1551().method_1531().method_4617(ID.method_12832(), new class_1043(class_1011.method_4309((InputStream)stream)));
            stream.close();
            return new PackWidget(displayName, id);
        }
        return null;
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float f) {
        boolean updateBounds = false;
        if (this.getHeight() < 18) {
            this.setHeight(18);
            updateBounds = true;
        }
        if (this.getWidth() < 56) {
            this.setWidth(56);
            updateBounds = true;
        }
        if (updateBounds) {
            this.onBoundsUpdate();
        }
        if (this.placeholder == null) {
            try (class_3268 defaultPack = class_310.method_1551().method_45573();){
                this.placeholder = this.createWidget(class_2561.method_30163((String)defaultPack.method_14409()), (class_3262)defaultPack);
            }
            catch (Exception exception) {}
        } else {
            this.placeholder.render((class_332)graphics, this.getPos().x() + 1, this.getPos().y() + 1);
        }
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.iconsOnly);
        return options;
    }

    public class_2960 getId() {
        return ID;
    }

    public void update() {
        this.widgets.clear();
        this.init();
    }

    public class PackWidget {
        public final String name;
        private final class_2960 texture;

        public PackWidget(class_2561 name, class_2960 id) {
            this.name = name.getString();
            this.texture = id;
        }

        public void render(class_332 graphics, int x, int y) {
            if (!((Boolean)PackDisplayHud.this.iconsOnly.get()).booleanValue()) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                graphics.method_25290(this.texture, x, y, 0.0f, 0.0f, 16, 16, 16, 16);
            }
            DrawUtil.drawString(graphics, this.name, (float)(x + 18), (float)(y + 6), PackDisplayHud.this.textColor.get().toInt(), (boolean)((Boolean)PackDisplayHud.this.shadow.get()));
        }

        @Generated
        public String getName() {
            return this.name;
        }
    }
}

