/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.modules.hud.gui.hud.vanilla;

import io.github.axolotlclient.AxolotlClientConfig.api.options.Option;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.BooleanOption;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.EnumOption;
import io.github.axolotlclient.bridge.render.AxoRenderContext;
import io.github.axolotlclient.mixin.BossBarHudAccessor;
import io.github.axolotlclient.modules.hud.gui.component.DynamicallyPositionable;
import io.github.axolotlclient.modules.hud.gui.entry.TextHudEntry;
import io.github.axolotlclient.modules.hud.gui.layout.AnchorPoint;
import io.github.axolotlclient.modules.hud.util.DefaultOptions;
import io.github.axolotlclient.modules.hud.util.DrawPosition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_5348;

public class BossBarHud
extends TextHudEntry
implements DynamicallyPositionable {
    public static final class_2960 ID = new class_2960("kronhud", "bossbarhud");
    private static final class_2960 BARS_TEXTURE = new class_2960("textures/gui/bars.png");
    private final class_1259 placeholder = new CustomBossBar((class_2561)class_2561.method_43470((String)"Boss bar"), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795);
    private final class_1259 placeholder2 = (class_1259)class_156.method_656(() -> {
        CustomBossBar boss = new CustomBossBar((class_2561)class_2561.method_43470((String)"More boss bars..."), class_1259.class_1260.field_5783, class_1259.class_1261.field_5795);
        boss.method_5408(0.45f);
        return boss;
    });
    private final BooleanOption text = new BooleanOption("text", Boolean.valueOf(true));
    private final BooleanOption bar = new BooleanOption("bar", Boolean.valueOf(true));
    private final EnumOption<AnchorPoint> anchor = DefaultOptions.getAnchorPoint();
    private Map<UUID, class_345> bossBars = new HashMap<UUID, class_345>();
    private final class_310 client;

    public BossBarHud() {
        super(184, 80, false);
        this.client = (class_310)((TextHudEntry)this).client;
    }

    public void renderComponent(AxoRenderContext graphics, float delta) {
        this.setBossBars();
        if (this.bossBars == null || this.bossBars.isEmpty()) {
            return;
        }
        DrawPosition scaledPos = this.getPos();
        int by = 12;
        for (class_345 bossBar : this.bossBars.values()) {
            this.renderBossBar((class_332)graphics, scaledPos.x(), by + scaledPos.y(), (class_1259)bossBar);
            if ((by += 19) <= this.getHeight()) continue;
            break;
        }
    }

    public void setBossBars() {
        int prevLength = this.bossBars.size();
        this.bossBars = ((BossBarHudAccessor)this.client.field_1705.method_1740()).axolotlclient$getBossBars();
        if (this.bossBars != null && this.bossBars.size() != prevLength) {
            if (this.bossBars.isEmpty()) {
                return;
            }
            this.setHeight(12 + prevLength * 19);
        }
    }

    private void renderBossBar(class_332 graphics, int x, int y, class_1259 bossBar) {
        if (((Boolean)this.bar.get()).booleanValue()) {
            int i;
            graphics.method_25290(BARS_TEXTURE, x, y, 0.0f, (float)(bossBar.method_5420().ordinal() * 5 * 2), 182, 5, 256, 256);
            if (bossBar.method_5415() != class_1259.class_1261.field_5795) {
                graphics.method_25290(BARS_TEXTURE, x, y, 0.0f, (float)(80 + (bossBar.method_5415().ordinal() - 1) * 5 * 2), 182, 5, 256, 256);
            }
            if ((i = (int)(bossBar.method_5412() * 183.0f)) > 0) {
                graphics.method_25290(BARS_TEXTURE, x, y, 0.0f, (float)(bossBar.method_5420().ordinal() * 5 * 2 + 5), i, 5, 256, 256);
                if (bossBar.method_5415() != class_1259.class_1261.field_5795) {
                    graphics.method_25290(BARS_TEXTURE, x, y, 0.0f, (float)(80 + (bossBar.method_5415().ordinal() - 1) * 5 * 2 + 5), i, 5, 256, 256);
                }
            }
        }
        if (((Boolean)this.text.get()).booleanValue()) {
            class_2561 text = bossBar.method_5414();
            float textX = (float)x + (float)this.getWidth() / 2.0f - (float)this.client.field_1772.method_27525((class_5348)text) / 2.0f;
            float textY = y - 9;
            graphics.method_51439(this.client.field_1772, text, (int)textX, (int)textY, this.textColor.get().toInt(), ((Boolean)this.shadow.get()).booleanValue());
        }
    }

    public void renderPlaceholderComponent(AxoRenderContext graphics, float delta) {
        DrawPosition pos = this.getPos();
        this.renderBossBar((class_332)graphics, pos.x(), pos.y() + 12, this.placeholder);
        this.renderBossBar((class_332)graphics, pos.x(), pos.y() + 31, this.placeholder2);
    }

    public class_2960 getId() {
        return ID;
    }

    public List<Option<?>> getConfigurationOptions() {
        List options = super.getConfigurationOptions();
        options.add(this.hide);
        options.add(this.text);
        options.add(this.bar);
        options.add(this.anchor);
        return options;
    }

    public AnchorPoint getAnchor() {
        return (AnchorPoint)this.anchor.get();
    }

    public static class CustomBossBar
    extends class_1259 {
        public CustomBossBar(class_2561 name, class_1259.class_1260 color, class_1259.class_1261 style) {
            super(class_3532.method_15394(), name, color, style);
        }
    }
}

