/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.util;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.github.axolotlclient.AxolotlClient;
import io.github.axolotlclient.AxolotlClientConfig.api.util.Graphics;
import io.github.axolotlclient.AxolotlClientConfig.impl.options.GraphicsOption;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_267;
import net.minecraft.class_268;
import net.minecraft.class_269;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3544;
import net.minecraft.class_5250;
import org.apache.commons.lang3.StringUtils;

public class Util {
    public static String lastgame;
    public static String game;

    public static int getTicksBetween(int start, int end) {
        if (end < start) {
            end += 24000;
        }
        return end - start;
    }

    public static String getGame() {
        List<String> sidebar = Util.getSidebar();
        game = sidebar.isEmpty() ? "" : (class_310.method_1551().method_1558() != null && class_310.method_1551().method_1558().field_3761.toLowerCase().contains(sidebar.get(0).toLowerCase()) ? (sidebar.get(sidebar.size() - 1).toLowerCase(Locale.ROOT).contains(class_310.method_1551().method_1558().field_3761.toLowerCase(Locale.ROOT)) || sidebar.get(sidebar.size() - 1).contains("Playtime") ? "In Lobby" : (sidebar.get(sidebar.size() - 1).contains("--------") ? "Playing Bridge Practice" : "Playing " + sidebar.get(sidebar.size() - 1))) : "Playing " + sidebar.get(0));
        if (!Objects.equals(lastgame, game) && game.isEmpty()) {
            game = lastgame;
        } else {
            lastgame = game;
        }
        if (game == null) {
            game = "";
        }
        return game;
    }

    public static List<String> getSidebar() {
        ArrayList<String> lines = new ArrayList<String>();
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return lines;
        }
        class_269 scoreboard = client.field_1687.method_8428();
        if (scoreboard == null) {
            return lines;
        }
        class_266 sidebar = scoreboard.method_1189(1);
        if (sidebar == null) {
            return lines;
        }
        ArrayList scores = scoreboard.method_1184(sidebar);
        ArrayList list = scores.stream().filter(input -> input != null && input.method_1129() != null && !input.method_1129().startsWith("#")).collect(Collectors.toList());
        scores = list.size() > 15 ? Lists.newArrayList((Iterable)Iterables.skip(list, (int)(scores.size() - 15))) : list;
        for (class_267 score : scores) {
            class_268 team = scoreboard.method_1164(score.method_1129());
            if (team == null) {
                return lines;
            }
            String text = team.method_1144().getString() + team.method_1136().getString();
            if (text.trim().isEmpty()) continue;
            lines.add(text);
        }
        lines.add(sidebar.method_1114().getString());
        Collections.reverse(lines);
        return lines;
    }

    public static class_2561 formatFromCodes(String formattedString) {
        class_5250 text = class_2561.method_43473();
        String[] arr = formattedString.split("\u00a7");
        ArrayList<class_124> modifiers = new ArrayList<class_124>();
        int length = arr.length;
        for (int i = 0; i < length; ++i) {
            String s = arr[i];
            if (s.isEmpty()) continue;
            if (i == 0) {
                text.method_27693(s);
                continue;
            }
            class_124 formatting = class_124.method_544((char)s.charAt(0));
            if (formatting != null && formatting.method_542()) {
                modifiers.add(formatting);
            }
            class_5250 part = class_2561.method_43470((String)(formatting != null ? s.substring(1) : s));
            if (formatting != null) {
                part.method_27692(formatting);
                if (!modifiers.isEmpty()) {
                    modifiers.forEach(arg_0 -> ((class_5250)part).method_27692(arg_0));
                    if (formatting.equals((Object)class_124.field_1070)) {
                        modifiers.clear();
                    }
                }
            }
            text.method_10852((class_2561)part);
        }
        return text;
    }

    public static void sendChatMessage(String msg) {
        msg = class_3544.method_43681((String)StringUtils.normalizeSpace((String)msg.trim()));
        assert (class_310.method_1551().field_1724 != null);
        if (msg.startsWith("/")) {
            class_310.method_1551().field_1724.field_3944.method_45731(msg.substring(1));
        } else {
            class_310.method_1551().field_1724.field_3944.method_45729(msg);
        }
    }

    public static void addMessageToChatHud(class_2561 msg) {
        class_310.method_1551().field_1705.method_1743().method_1812(msg);
    }

    public static class_2960 getTexture(GraphicsOption option) {
        return Util.getTexture((Graphics)option.get(), option.getName());
    }

    public static class_2960 getTexture(Graphics graphics, String name) {
        class_2960 id = new class_2960("axolotlclient", "graphics_" + name.toLowerCase(Locale.ROOT));
        try {
            class_1043 texture;
            if (class_310.method_1551().method_1531().method_34590(id, null) == null) {
                texture = new class_1043(class_1011.method_49277((byte[])graphics.getPixelData()));
                class_310.method_1551().method_1531().method_4616(id, (class_1044)texture);
            } else {
                texture = (class_1043)class_310.method_1551().method_1531().method_4619(id);
                for (int x = 0; x < graphics.getWidth(); ++x) {
                    for (int y = 0; y < graphics.getHeight(); ++y) {
                        texture.method_4525().method_4305(x, y, graphics.getPixelColor(x, y));
                    }
                }
            }
            texture.method_4524();
        }
        catch (IOException e) {
            AxolotlClient.LOGGER.error("Failed to bind texture for " + name + ": ", new Object[]{e});
        }
        return id;
    }

    public static double lerp(double start, double end, double percent) {
        return start + (end - start) * percent;
    }
}

