/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.AxolotlClientConfig.impl.util.DrawUtil;
import io.github.axolotlclient.api.ContextMenuContainer;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.chat.ChatWidget;
import io.github.axolotlclient.api.handlers.ChatHandler;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.User;
import io.github.axolotlclient.api.util.AlphabeticalComparator;
import io.github.axolotlclient.mixin.ScreenAccessor;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_1945050;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_2925725;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_8105098;
import org.lwjgl.input.Keyboard;

public class ChatsSidebar
extends C_3020744
implements ContextMenuScreen {
    private static final int ANIM_STEP = 8;
    private final C_3020744 parent;
    private int sidebarAnimX;
    private int sidebarWidth;
    private boolean remove;
    private boolean hasChat;
    private ListWidget list;
    private C_2925725 input;
    private Channel channel;
    private ChatWidget chatWidget;
    private ContextMenuContainer contextMenu;
    private final String title = C_3390001.m_2053009((String)"api.chats.sidebar", (Object[])new Object[0]);

    public ChatsSidebar(C_3020744 parent) {
        this.parent = parent;
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        if (this.parent != null) {
            this.parent.m_7261014(mouseX, mouseY, delta);
        }
        C_3754158.m_8373640();
        C_3754158.m_3172490((float)0.0f, (float)0.0f, (float)1000.0f);
        DrawUtil.pushScissor((int)0, (int)0, (int)Math.max(0, this.sidebarWidth + this.sidebarAnimX), (int)this.f_3080061);
        ChatsSidebar.m_7865719((int)this.sidebarAnimX, (int)0, (int)(this.sidebarWidth + this.sidebarAnimX), (int)this.f_3080061, (int)-1728053248);
        this.f_2020658.m_1950885(C_3390001.m_2053009((String)"api.chats", (Object[])new Object[0]), (float)(10 + this.sidebarAnimX), 10.0f, -1);
        if (this.list != null) {
            this.list.m_9734698(mouseX, mouseY, delta);
        }
        super.m_7261014(mouseX, mouseY, delta);
        if (this.input != null) {
            this.input.m_1620442();
        }
        if (this.hasChat) {
            ChatsSidebar.m_7865719((int)(70 + this.sidebarAnimX), (int)0, (int)(70 + this.sidebarAnimX + 1), (int)this.f_3080061, (int)-16777216);
            this.f_2020658.m_1950885(this.channel.getName(), (float)(this.sidebarAnimX + 75), 20.0f, -1);
            if (this.channel.isDM() && ((Channel.DM)this.channel).getReceiver().getStatus().isOnline()) {
                this.f_2020658.m_1950885(String.valueOf(C_1945050.f_8012292) + ((Channel.DM)this.channel).getReceiver().getStatus().getTitle() + ": " + ((Channel.DM)this.channel).getReceiver().getStatus().getDescription(), (float)(this.sidebarAnimX + 80), 30.0f, 0x808080);
            }
            this.chatWidget.m_9734698(mouseX, mouseY, delta);
        }
        this.contextMenu.render(this.f_7153641, mouseX, mouseY);
        this.animate();
        DrawUtil.popScissor();
        C_3754158.m_2041265();
    }

    public void m_3593494() {
        this.removeChat();
        this.sidebarWidth = 70;
        this.sidebarAnimX = -this.sidebarWidth;
        if (this.parent != null) {
            ((ScreenAccessor)this.parent).getButtons().stream().filter(e -> e.f_4865617.equals(C_3390001.m_2053009((String)"api.chats", (Object[])new Object[0]))).forEach(e -> {
                e.f_1990467 = false;
            });
        }
        ChannelRequest.getChannelList().whenCompleteAsync((list, t) -> {
            this.list = new ListWidget((List<Channel>)list, 10, 30, 50, this.f_3080061 - 70);
        });
        this.f_2213969.add(new C_2348249(0, 10 - this.sidebarWidth, this.f_3080061 - 30, 50, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0])));
        this.contextMenu = new ContextMenuContainer();
    }

    public void remove() {
        this.remove = true;
    }

    public void m_2450377() {
        if (this.input != null) {
            this.input.m_0296611();
        }
    }

    public void m_8984281() {
        if (this.chatWidget != null) {
            this.chatWidget.remove();
        }
    }

    public boolean m_0601517() {
        return this.parent != null && this.parent.m_0601517();
    }

    private void animate() {
        if (this.sidebarAnimX < 0 && !this.remove) {
            if (this.sidebarAnimX > -8) {
                this.sidebarAnimX = -8;
            }
            this.sidebarAnimX += 8;
            if (this.list != null) {
                this.list.visible = false;
            }
            this.f_2213969.forEach(button -> button.f_3923091 += 8);
        } else if (this.remove) {
            if (this.sidebarAnimX <= -this.sidebarWidth) {
                this.close();
            }
            this.sidebarAnimX -= 8;
            if (this.list != null) {
                this.list.m_3867153(this.list.getX() - 8);
            }
            this.f_2213969.forEach(button -> button.f_3923091 -= 8);
            if (this.chatWidget != null) {
                this.chatWidget.m_3867153(this.chatWidget.getX() - 8);
            }
            if (this.input != null) {
                this.input.f_2565579 -= 8;
            }
        } else if (this.list != null && !this.list.visible) {
            this.list.visible = true;
        }
    }

    private void close() {
        this.f_7153641.m_6408915(this.parent);
        if (this.chatWidget != null) {
            this.chatWidget.remove();
        }
    }

    public void m_7362766(int mouseX, int mouseY, int button) {
        if (this.contextMenu.getMenu() != null) {
            if (this.contextMenu.mouseClicked(mouseX, mouseY, button)) {
                return;
            }
            this.contextMenu.removeMenu();
        }
        if (mouseX > this.sidebarWidth) {
            this.remove();
            return;
        }
        if (this.list != null) {
            this.list.m_7379893(mouseX, mouseY, button);
        }
        if (this.input != null) {
            this.input.m_1129375(mouseX, mouseY, button);
        }
        if (this.chatWidget != null) {
            this.chatWidget.m_7379893(mouseX, mouseY, button);
        }
        super.m_7362766(mouseX, mouseY, button);
    }

    private void removeChat() {
        this.hasChat = false;
        this.chatWidget = null;
        this.input = null;
    }

    protected void m_7971793(C_2348249 buttonWidget) {
        if (buttonWidget.f_5920996 == 0) {
            this.remove();
        }
    }

    private void addChat(Channel channel) {
        int w;
        if (this.hasChat) {
            this.removeChat();
        }
        this.hasChat = true;
        this.list.elements.forEach(b -> {
            b.f_3831222 = true;
        });
        this.channel = channel;
        if (channel.isDM()) {
            User chatUser = ((Channel.DM)channel).getReceiver();
            w = Math.max(this.f_7153641.f_0426313.m_0040387(chatUser.getStatus().getTitle() + ": " + chatUser.getStatus().getDescription()) + 5, this.f_7153641.f_0426313.m_0040387(channel.getName()));
        } else {
            w = this.f_7153641.f_0426313.m_0040387(channel.getName());
        }
        this.sidebarWidth = Math.min(Math.max(this.f_5465691 * 5 / 12, w + 5), this.f_5465691 / 2);
        this.chatWidget = new ChatWidget(channel, 75, 50, this.sidebarWidth - 80, this.f_3080061 - 100, this);
        this.input = new C_2925725(2, this.f_2020658, 75, this.f_3080061 - 30, this.sidebarWidth - 80, 20){

            public boolean m_1973329(char c, int i) {
                if (i == Keyboard.KEY_RETURN) {
                    ChatHandler.getInstance().sendMessage(ChatsSidebar.this.channel, ChatsSidebar.this.input.m_4862541());
                    ChatsSidebar.this.input.m_1464552("");
                    return true;
                }
                return super.m_1973329(c, i);
            }

            public void m_1620442() {
                super.m_1620442();
                if (this.m_4862541().isEmpty()) {
                    this.m_6649515(ChatsSidebar.this.f_2020658, C_3390001.m_2053009((String)"api.friends.chat.input", (Object[])new Object[0]), this.f_2565579 + 2, this.f_8286097 + 6, -8355712);
                }
            }
        };
        this.input.m_1954651(1024);
    }

    @Override
    public ContextMenuContainer getMenuContainer() {
        return this.contextMenu;
    }

    @Override
    public C_3020744 getSelf() {
        return this;
    }

    @Override
    public C_3020744 getParent() {
        return this.parent;
    }

    public void m_3356138() {
        super.m_3356138();
        if (this.list != null) {
            this.list.m_1002325();
        }
        if (this.chatWidget != null) {
            this.chatWidget.m_1002325();
        }
    }

    protected void m_6992336(char c, int i) {
        if (this.input != null) {
            this.input.m_1973329(c, i);
        }
        super.m_6992336(c, i);
    }

    private class ListWidget
    extends C_1630332 {
        private final List<UserButton> elements;
        private final int entryHeight = 25;
        private boolean visible;

        public ListWidget(List<Channel> list, int x, int y, int width, int height) {
            super(C_8105098.m_0408063(), width, height, y, ChatsSidebar.this.f_3080061 - y, 25);
            this.entryHeight = 25;
            this.visible = true;
            this.f_8129586 = x;
            this.f_7901480 = x + width;
            this.f_9975269 = y;
            this.f_9145833 = y + height;
            AtomicInteger buttonY = new AtomicInteger(y);
            this.elements = list.stream().sorted((u1, u2) -> new AlphabeticalComparator().compare(u1.getName(), u2.getName())).map(channel -> new UserButton(x, buttonY.getAndAdd(25), width, 20, channel.getName(), buttonWidget -> {
                ChatsSidebar.this.addChat((Channel)channel);
                buttonWidget.f_3831222 = false;
            })).collect(Collectors.toList());
        }

        public int getX() {
            return this.f_8129586;
        }

        public void m_3867153(int x) {
            this.f_8129586 = x;
            this.f_7901480 = x + this.f_2695432;
            this.elements.forEach(e -> {
                e.f_3923091 = x;
            });
        }

        protected int m_3791031() {
            return this.elements.size();
        }

        public void m_9734698(int mouseX, int mouseY, float delta) {
            if (this.visible) {
                this.f_9602731 = mouseX;
                this.f_1139530 = mouseY;
                this.m_7189774();
                int m = this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2;
                int n = this.f_9975269 + 4 - (int)this.f_1867063;
                this.m_2972483(m, n, mouseX, mouseY);
            }
        }

        protected void m_2972483(int x, int y, int mouseX, int mouseY) {
            io.github.axolotlclient.modules.hud.util.DrawUtil.enableScissor(this.f_8129586, this.f_9975269, this.f_8129586 + this.f_2695432, this.f_9145833);
            super.m_2972483(x, y, mouseX, mouseY);
            io.github.axolotlclient.modules.hud.util.DrawUtil.disableScissor();
        }

        public C_1630332.C_8277969 m_7118949(int i) {
            return this.elements.get(i);
        }

        public class UserButton
        extends C_2348249
        implements C_1630332.C_8277969 {
            private final Action action;

            public UserButton(int x, int y, int width, int height, String string, Action action) {
                super(0, x, y, width, height, string);
                this.action = action;
                this.f_1990467 = true;
            }

            public void mouseClicked(int mouseX, int mouseY) {
                if (this.m_9491400(ListWidget.this.f_3511485, mouseX, mouseY)) {
                    this.m_1301911(ListWidget.this.f_3511485.m_7555106());
                    this.action.onPress(this);
                }
            }

            public void m_1433237(int i, int j, int k) {
            }

            public void m_2013749(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
                this.f_8532347 = y;
                this.m_5350167(ListWidget.this.f_3511485, mouseX, mouseY);
            }

            public boolean m_3739705(int index, int mouseX, int mouseY, int button, int x, int y) {
                if (this.m_9491400(ListWidget.this.f_3511485, mouseX, mouseY)) {
                    this.m_1301911(ListWidget.this.f_3511485.m_7555106());
                    this.action.onPress(this);
                    return true;
                }
                return false;
            }

            public void m_4703785(int i, int j, int k, int l, int m, int n) {
            }
        }
    }

    public static interface Action {
        public void onPress(ListWidget.UserButton var1);
    }
}

