/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api;

import io.github.axolotlclient.AxolotlClientConfig.impl.ui.ClickableWidget;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Element;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.Screen;
import io.github.axolotlclient.AxolotlClientConfig.impl.ui.vanilla.widgets.VanillaButtonWidget;
import io.github.axolotlclient.api.requests.GlobalDataRequest;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.util.List;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3754158;
import net.minecraft.unmapped.C_4976084;
import net.minecraft.unmapped.C_5819357;

public class NewsScreen
extends Screen {
    private final C_3020744 parent;

    public NewsScreen(C_3020744 parent) {
        super(C_3390001.m_2053009((String)"api.notes.title", (Object[])new Object[0]));
        this.parent = parent;
    }

    public void m_7261014(int mouseX, int mouseY, float delta) {
        super.m_7261014(mouseX, mouseY, delta);
        this.m_2717572(this.f_2020658, this.title, this.f_5465691 / 2, 20, -1);
    }

    public void m_3593494() {
        GlobalDataRequest.get().thenAccept(data -> this.addDrawableChild((Element)new NewsWidget(25, 35, this.f_5465691 - 50, this.f_3080061 - 100, data.notes().trim().replaceAll("([^\n])\n([^\n])", "$1 $2"))));
        this.addDrawableChild((Element)new VanillaButtonWidget(this.f_5465691 / 2 - 100, this.f_3080061 - 45, 200, 20, C_3390001.m_2053009((String)"gui.back", (Object[])new Object[0]), buttonWidget -> this.f_7153641.m_6408915(this.parent)));
    }

    private class NewsWidget
    extends AbstractTextAreaWidget {
        private final List<String> lines;
        private final int contentHeight;

        public NewsWidget(int x, int y, int width, int height, String component) {
            super(x, y, width, height, component);
            this.lines = NewsScreen.this.f_2020658.m_0466830(this.getMessage(), this.getWidth() - 4);
            this.contentHeight = this.lines.size() * ((NewsScreen)NewsScreen.this).f_2020658.f_6725889;
        }

        @Override
        protected int getInnerHeight() {
            return this.contentHeight;
        }

        @Override
        protected void renderContents(int mouseX, int mouseY, float partialTick) {
            int y = this.getY() + 2;
            for (String chsq : this.lines) {
                this.m_6649515(NewsScreen.this.f_2020658, chsq, this.getX() + 2, y, -1);
                y += ((NewsScreen)NewsScreen.this).f_2020658.f_6725889;
            }
        }

        @Override
        protected double scrollRate() {
            return ((NewsScreen)NewsScreen.this).f_2020658.f_6725889;
        }

        @Override
        protected void renderBackground() {
        }
    }

    public static abstract class AbstractScrollArea
    extends ClickableWidget {
        public static final int SCROLLBAR_WIDTH = 6;
        private double scrollAmount;
        private boolean scrolling;

        public AbstractScrollArea(int x, int y, int width, int height, String component) {
            super(x, y, width, height, component);
        }

        public boolean mouseScrolled(double mouseX, double mouseY, double amountX, double scrollY) {
            if (!this.visible) {
                return false;
            }
            this.setScrollAmount(this.scrollAmount() - scrollY * this.scrollRate());
            return true;
        }

        public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.scrolling) {
                if (mouseY < (double)this.getY()) {
                    this.setScrollAmount(0.0);
                } else if (mouseY > (double)this.getYEnd()) {
                    this.setScrollAmount(this.maxScrollAmount());
                } else {
                    double d = Math.max(1, this.maxScrollAmount());
                    int i = this.scrollerHeight();
                    double e = Math.max(1.0, d / (double)(this.getHeight() - i));
                    this.setScrollAmount(this.scrollAmount() + dragY * e);
                }
                return true;
            }
            return super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
        }

        public void onRelease(double mouseX, double mouseY) {
            this.scrolling = false;
        }

        public double scrollAmount() {
            return this.scrollAmount;
        }

        public void setScrollAmount(double scrollAmount) {
            this.scrollAmount = C_4976084.m_0987703((double)scrollAmount, (double)0.0, (double)this.maxScrollAmount());
        }

        public boolean updateScrolling(double mouseX, double mouseY, int button) {
            this.scrolling = this.scrollbarVisible() && this.isValidClickButton(button) && mouseX >= (double)this.scrollBarX() && mouseX <= (double)(this.scrollBarX() + 6) && mouseY >= (double)this.getY() && mouseY < (double)this.getYEnd();
            return this.scrolling;
        }

        public void refreshScrollAmount() {
            this.setScrollAmount(this.scrollAmount);
        }

        public int maxScrollAmount() {
            return Math.max(0, this.contentHeight() - this.getHeight());
        }

        protected boolean scrollbarVisible() {
            return this.maxScrollAmount() > 0;
        }

        protected int scrollerHeight() {
            return C_4976084.m_1109374((int)((int)((float)(this.getHeight() * this.getHeight()) / (float)this.contentHeight())), (int)32, (int)(this.getHeight() - 8));
        }

        protected int scrollBarX() {
            return this.getXEnd() - 6;
        }

        protected int scrollBarY() {
            return Math.max(this.getY(), (int)this.scrollAmount * (this.getHeight() - this.scrollerHeight()) / this.maxScrollAmount() + this.getY());
        }

        protected void renderScrollbar() {
            if (this.scrollbarVisible()) {
                int i = this.scrollBarX();
                int j = this.scrollerHeight();
                int k = this.scrollBarY();
                AbstractScrollArea.m_7865719((int)i, (int)this.getY(), (int)(i + 6), (int)this.getYEnd(), (int)-16777216);
                AbstractScrollArea.m_7865719((int)i, (int)k, (int)(i + 6), (int)(k + j), (int)-8355712);
                AbstractScrollArea.m_7865719((int)i, (int)k, (int)(i + 6 - 1), (int)(k + j - 1), (int)-4144960);
            }
        }

        protected int getYEnd() {
            return this.getY() + this.getHeight();
        }

        protected abstract int contentHeight();

        protected abstract double scrollRate();

        protected int getXEnd() {
            return this.getX() + this.getWidth();
        }
    }

    public static abstract class AbstractTextAreaWidget
    extends AbstractScrollArea {
        private static final int INNER_PADDING = 4;

        public AbstractTextAreaWidget(int x, int y, int width, int height, String component) {
            super(x, y, width, height, component);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            boolean bl = this.updateScrolling(mouseX, mouseY, button);
            return super.mouseClicked(mouseX, mouseY, button) || bl;
        }

        public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
            boolean bl2;
            boolean bl = keyCode == 265;
            boolean bl3 = bl2 = keyCode == 264;
            if (bl || bl2) {
                double d = this.scrollAmount();
                this.setScrollAmount(this.scrollAmount() + (double)(bl ? -1 : 1) * this.scrollRate());
                if (d != this.scrollAmount()) {
                    return true;
                }
            }
            return super.keyPressed(keyCode, scanCode, modifiers);
        }

        public void drawWidget(int mouseX, int mouseY, float partialTick) {
            if (this.visible) {
                this.renderBackground();
                DrawUtil.enableScissor(this.getX() + 1, this.getY() + 1, this.getX() + this.getWidth() - 1, this.getY() + this.getHeight() - 1);
                C_3754158.m_8373640();
                C_3754158.m_5322104((double)0.0, (double)(-this.scrollAmount()), (double)0.0);
                this.renderContents(mouseX, mouseY, partialTick);
                C_3754158.m_2041265();
                DrawUtil.disableScissor();
                this.renderDecorations();
            }
        }

        protected void renderDecorations() {
            this.renderScrollbar();
        }

        protected int innerPadding() {
            return 4;
        }

        protected int totalInnerPadding() {
            return this.innerPadding() * 2;
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return this.active && this.visible && mouseX >= (double)this.getX() && mouseY >= (double)this.getY() && mouseX < (double)(this.getXEnd() + 6) && mouseY < (double)this.getYEnd();
        }

        @Override
        protected int scrollBarX() {
            return this.getXEnd();
        }

        @Override
        protected int contentHeight() {
            return this.getInnerHeight() + this.totalInnerPadding();
        }

        protected void renderBackground() {
            this.renderBorder(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }

        protected void renderBorder(int x, int y, int width, int height) {
            int i = this.isFocused() ? -1 : -6250336;
            AbstractTextAreaWidget.m_7865719((int)this.getX(), (int)this.getY(), (int)this.getXEnd(), (int)this.getYEnd(), (int)i);
            AbstractTextAreaWidget.m_7865719((int)(this.getX() + 1), (int)(this.getY() + 1), (int)(this.getXEnd() - 1), (int)(this.getYEnd() - 1), (int)-16777216);
        }

        protected boolean withinContentAreaTopBottom(int top, int bottom) {
            return (double)bottom - this.scrollAmount() >= (double)this.getY() && (double)top - this.scrollAmount() <= (double)(this.getY() + this.getHeight());
        }

        protected abstract int getInnerHeight();

        protected abstract void renderContents(int var1, int var2, float var3);

        protected int getInnerLeft() {
            return this.getX() + this.innerPadding();
        }

        protected int getInnerTop() {
            return this.getY() + this.innerPadding();
        }

        public void playDownSound(C_5819357 handler) {
        }
    }
}

