/*
 * Decompiled with CFR 0.152.
 */
package io.github.axolotlclient.api.chat;

import io.github.axolotlclient.api.API;
import io.github.axolotlclient.api.ContextMenu;
import io.github.axolotlclient.api.ContextMenuScreen;
import io.github.axolotlclient.api.chat.ChannelSettingsScreen;
import io.github.axolotlclient.api.chat.ChatScreen;
import io.github.axolotlclient.api.requests.ChannelRequest;
import io.github.axolotlclient.api.types.Channel;
import io.github.axolotlclient.api.types.Relation;
import io.github.axolotlclient.modules.hud.util.DrawUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.unmapped.C_1441789;
import net.minecraft.unmapped.C_1630332;
import net.minecraft.unmapped.C_2348249;
import net.minecraft.unmapped.C_3020744;
import net.minecraft.unmapped.C_3390001;
import net.minecraft.unmapped.C_3831727;
import net.minecraft.unmapped.C_8105098;

public class ChatListWidget
extends C_1630332 {
    protected final ContextMenuScreen screen;
    private final Predicate<Channel> predicate;
    private final List<ChatListEntry> entries = new ArrayList<ChatListEntry>();

    public ChatListWidget(ContextMenuScreen screen, int screenWidth, int screenHeight, int x, int y, int width, int height, Predicate<Channel> filter) {
        super(C_8105098.m_0408063(), width, height, y, y + height, 25);
        this.m_3867153(x);
        this.screen = screen;
        this.predicate = filter;
    }

    public void addChannels(List<Channel> channels) {
        channels.stream().filter(this.predicate).sorted().forEach(c -> this.entries.add(0, new ChatListEntry((Channel)c)));
        this.f_1867063 = 0.0f;
    }

    public void setActiveChannel(Channel channel) {
        this.entries.stream().filter(e -> e.channel.equals((Object)channel)).findFirst().ifPresent(c -> {
            c.widget.f_3831222 = false;
        });
    }

    public int m_6519286() {
        return this.f_2695432 - 8;
    }

    public ChatListWidget(ContextMenuScreen screen, int screenWidth, int screenHeight, int x, int y, int width, int height) {
        this(screen, screenWidth, screenHeight, x, y, width, height, c -> true);
    }

    protected int m_3021017() {
        return this.f_8129586 + this.f_2695432 / 2 - this.m_6519286() / 2 + 2 + this.f_2695432 - 8;
    }

    protected void m_2972483(int i, int j, int k, int l) {
        DrawUtil.enableScissor(this.f_8129586, this.f_9975269, this.f_7901480, this.f_9145833);
        super.m_2972483(i, j, k, l);
        DrawUtil.disableScissor();
    }

    public C_1630332.C_8277969 m_7118949(int i) {
        return this.entries.get(i);
    }

    protected int m_3791031() {
        return this.entries.size();
    }

    public class ChatListEntry
    implements C_1630332.C_8277969 {
        private final Channel channel;
        private final C_2348249 widget;

        public ChatListEntry(Channel channel) {
            this.channel = channel;
            this.widget = new C_2348249(-1, 0, 0, ChatListWidget.this.m_6519286(), 20, channel.getName()){

                public void m_2717572(C_3831727 textRenderer, String string, int i, int j, int k) {
                    DrawUtil.drawScrollableText(textRenderer, string, this.f_3923091 + 2, this.f_8532347, this.f_3923091 + this.f_9527567 - 2, this.f_8532347 + this.f_7845401, k);
                }
            };
        }

        public void m_1433237(int i, int j, int k) {
        }

        public void m_2013749(int index, int x, int y, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean hovered) {
            this.widget.f_3923091 = x;
            this.widget.f_8532347 = y;
            this.widget.m_5350167(ChatListWidget.this.f_3511485, mouseX, mouseY);
        }

        public boolean m_3739705(int index, int mouseX, int mouseY, int button, int m, int n) {
            if (this.widget.m_9491400(ChatListWidget.this.f_3511485, mouseX, mouseY)) {
                if (button == 0) {
                    ChatListWidget.this.f_3511485.m_6408915((C_3020744)new ChatScreen(ChatListWidget.this.screen.getParent(), this.channel));
                    return true;
                }
                if (button == 1) {
                    ContextMenu.Builder builder = ContextMenu.builder().title(this.channel.getName()).spacer().entry(C_3390001.m_2053009((String)"api.channel.configure", (Object[])new Object[0]), w -> ChatListWidget.this.f_3511485.m_6408915((C_3020744)new ChannelSettingsScreen(ChatListWidget.this.screen.getSelf(), this.channel))).spacer();
                    if (this.channel.getOwner().equals((Object)API.getInstance().getSelf())) {
                        builder.entry(C_3390001.m_2053009((String)"api.channel.delete", (Object[])new Object[0]), w -> ChatListWidget.this.f_3511485.m_6408915((C_3020744)new C_1441789((bl, i) -> {
                            if (bl) {
                                ChannelRequest.leaveOrDeleteChannel((Channel)this.channel).whenComplete((o, throwable) -> ChatListWidget.this.f_3511485.m_2167033(() -> ChatListWidget.this.f_3511485.m_6408915(ChatListWidget.this.screen.getSelf())));
                            }
                        }, C_3390001.m_2053009((String)"api.channels.delete.confirm", (Object[])new Object[0]), C_3390001.m_2053009((String)"api.channels.delete.confirm.desc", (Object[])new Object[]{this.channel.getName()}), 0)));
                    } else {
                        builder.entry(C_3390001.m_2053009((String)"api.channel.leave", (Object[])new Object[0]), w -> ChatListWidget.this.f_3511485.m_6408915((C_3020744)new C_1441789((bl, i) -> {
                            if (bl) {
                                ChannelRequest.leaveOrDeleteChannel((Channel)this.channel).whenComplete((o, throwable) -> ChatListWidget.this.f_3511485.m_2167033(() -> ChatListWidget.this.f_3511485.m_6408915(ChatListWidget.this.screen.getSelf())));
                            }
                        }, C_3390001.m_2053009((String)"api.channels.leave.confirm", (Object[])new Object[0]), this.channel.getOwner().getRelation() == Relation.FRIEND ? C_3390001.m_2053009((String)"api.channels.leave.confirm.desc_add", (Object[])new Object[]{this.channel.getName()}) : C_3390001.m_2053009((String)"api.channels.leave.confirm.desc_invite", (Object[])new Object[]{this.channel.getName()}), 0)));
                    }
                    ChatListWidget.this.screen.setContextMenu(builder.build());
                    return true;
                }
            }
            return false;
        }

        public void m_4703785(int i, int j, int k, int l, int m, int n) {
        }
    }
}

